/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5;

import de.jstacs.io.SparseStringExtractor;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;

public class NeighborTest {
    private static String line;
    private static String tab;
    private static String control;
    private static String[] split;

    static {
        tab = "\t";
        control = "NoDNA";
    }

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("read mapping");
        String home = "dream5/data/";
        String[] names = new String[]{"1M-HK_024365_BCLeft_stagleft.txt", "1M-HK_024365_BCLeft_stagright.txt", "1M-ME_022071_BCLeft_stagright.txt", "1M-ME_022071_BCLeft_stagleft.txt"};
        Hashtable[] hash = new Hashtable[names.length];
        int i2 = 0;
        while (i2 < names.length) {
            hash[i2] = NeighborTest.getMapping(String.valueOf(home) + names[i2]);
            ++i2;
        }
        SparseStringExtractor sse = new SparseStringExtractor("dream5/data/DREAM5_PBM_Data_IdToGridFile.txt");
        Hashtable<String, Integer> info = new Hashtable<String, Integer>();
        while (sse.hasMoreElements()) {
            line = sse.nextElement();
            split = line.split(tab);
            i = 0;
            while (!names[i].equalsIgnoreCase(split[1])) {
                ++i;
            }
            info.put(String.valueOf(split[0]) + tab + split[1].substring(3, 5), i);
        }
        int[] dim = NeighborTest.getDim(hash[0].elements());
        System.out.println((dim[0] + 1) * (dim[1] + 1));
        double[][] intensities = new double[dim[0] + 1][dim[1] + 1];
        String zero = "0";
        DoubleList spot = new DoubleList();
        DoubleList neighbor = new DoubleList();
        int[][] nArrayArray = new int[10][];
        nArrayArray[0] = new int[1];
        nArrayArray[1] = new int[]{1};
        nArrayArray[2] = new int[]{2};
        nArrayArray[3] = new int[]{3};
        nArrayArray[4] = new int[]{4};
        nArrayArray[5] = new int[]{5};
        nArrayArray[6] = new int[]{6};
        nArrayArray[7] = new int[]{7};
        nArrayArray[8] = new int[]{1, 3, 5, 7};
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArrayArray[9] = nArray;
        int[][] test = nArrayArray;
        REnvironment re = null;
        try {
            try {
                re = new REnvironment("localhost", "", "");
                int idx = 3;
                while (idx <= 8) {
                    System.out.println(idx);
                    sse = new SparseStringExtractor("dream5/DREAM5_PBM_Data_TrainingSet.txt");
                    sse.nextElement();
                    line = sse.nextElement();
                    while (sse.hasMoreElements()) {
                        split = line.split(tab);
                        String tf = split[0];
                        String array = split[1];
                        String start = String.valueOf(tf) + tab + array;
                        i = (Integer)info.get(start);
                        NeighborTest.fill(intensities, Double.NaN);
                        int anz = 0;
                        do {
                            if ((split = line.split(tab))[split.length - 1].equalsIgnoreCase(zero)) {
                                int[] pos = (int[])hash[i].get(split[2].substring(0, 35));
                                intensities[pos[0]][pos[1]] = Double.parseDouble(split[idx]);
                            }
                            ++anz;
                        } while ((line = sse.nextElement()) != null && line.startsWith(start));
                        System.out.print(String.valueOf(start) + tab + names[i]);
                        re.createMatrix("int", intensities);
                        re.plotToPDF("image(int)", String.valueOf(home) + tf + "-" + array + "-" + idx + ".pdf", true);
                        System.out.print(String.valueOf(tab) + re.eval("min(int,na.rm=T)").asDouble());
                        System.out.print(String.valueOf(tab) + re.eval("mean(int,na.rm=T)").asDouble());
                        System.out.print(String.valueOf(tab) + re.eval("sd(int,na.rm=T)").asDouble());
                        System.out.print(String.valueOf(tab) + re.eval("median(int,na.rm=T)").asDouble());
                        System.out.print(String.valueOf(tab) + re.eval("mad(int,na.rm=T)").asDouble());
                        System.out.print(String.valueOf(tab) + re.eval("max(int,na.rm=T)").asDouble());
                        int t = 0;
                        while (t < test.length) {
                            spot.clear();
                            neighbor.clear();
                            NeighborTest.fill(test[t], intensities, spot, neighbor);
                            re.createVector("spot", spot.toArray());
                            re.createVector("neighbor", neighbor.toArray());
                            re.voidEval("cc=cor.test(spot,neighbor)");
                            System.out.print(String.valueOf(tab) + re.eval("cc$estimate").asDouble() + tab + re.eval("cc$p.value").asDouble());
                            ++t;
                        }
                        System.out.println();
                    }
                    System.out.println();
                    ++idx;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (re != null) {
                    re.close();
                }
            }
        }
        finally {
            if (re != null) {
                re.close();
            }
        }
    }

    private static Hashtable<String, int[]> getMapping(String fName) throws FileNotFoundException, IOException {
        SparseStringExtractor sse = new SparseStringExtractor(fName, '#');
        Hashtable<String, int[]> hash = new Hashtable<String, int[]>();
        while (sse.hasMoreElements()) {
            line = sse.nextElement();
            split = line.split(tab);
            if (split[5].equalsIgnoreCase(control)) continue;
            hash.put(split[7], new int[]{Integer.parseInt(split[3]) - 1, Integer.parseInt(split[4]) - 1});
        }
        return hash;
    }

    private static int[] getDim(Enumeration<int[]> enumeration) {
        int[] max = new int[2];
        while (enumeration.hasMoreElements()) {
            int[] current = enumeration.nextElement();
            int i = 0;
            while (i < max.length) {
                if (max[i] < current[i]) {
                    max[i] = current[i];
                }
                ++i;
            }
        }
        return max;
    }

    private static void fill(double[][] array, double value) {
        int i = 0;
        while (i < array.length) {
            Arrays.fill(array[i], value);
            ++i;
        }
    }

    private static void fill(int[] test, double[][] array, DoubleList spot, DoubleList neighbor) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                int t = 0;
                while (t < test.length) {
                    switch (test[t]) {
                        case 0: {
                            if (i <= 0 || j <= 0) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i - 1][j - 1]);
                            break;
                        }
                        case 1: {
                            if (i <= 0) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i - 1][j]);
                            break;
                        }
                        case 2: {
                            if (i <= 0 || j + 1 >= array[i].length) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i - 1][j + 1]);
                            break;
                        }
                        case 3: {
                            if (j + 1 >= array[i].length) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i][j + 1]);
                            break;
                        }
                        case 4: {
                            if (i + 1 >= array.length || j + 1 >= array[i].length) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i + 1][j + 1]);
                            break;
                        }
                        case 5: {
                            if (i + 1 >= array.length) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i + 1][j]);
                            break;
                        }
                        case 6: {
                            if (i + 1 >= array.length || j <= 0) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i + 1][j - 1]);
                            break;
                        }
                        case 7: {
                            if (j <= 0) break;
                            spot.add(array[i][j]);
                            neighbor.add(array[i][j - 1]);
                        }
                    }
                    ++t;
                }
                ++j;
            }
            ++i;
        }
    }
}

