/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5.paper;

import challenges.dream5.paper.Evaluation;
import challenges.dream5.paper.Interpolation;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.OneDataSetLogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.history.CappedHistory;
import de.jstacs.motifDiscovery.history.NoRevertHistory;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.MarkovRandomFieldDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.MixtureDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.DurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.SkewNormalLikeDurationDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.UniformDurationDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SafeOutputStream;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;

public class Dream {
    public static void main(String[] args) throws Exception {
        System.out.println("args: " + Arrays.toString(args));
        REnvironment re2 = null;
        try {
            String[] t;
            boolean mrf;
            try {
                re2 = new REnvironment("localhost", "", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String home = args[0];
            String tf = args[1];
            String array = args[2];
            String type = args[3];
            int fgOrder = -1;
            try {
                fgOrder = Integer.parseInt(args[4]);
                mrf = false;
            }
            catch (Exception e) {
                mrf = true;
            }
            int components = Integer.parseInt(args[5]);
            int bgOrder = Integer.parseInt(args[6]);
            int nStart = Integer.parseInt(args[7]);
            int threads = Integer.parseInt(args[8]);
            boolean bgsEq = Boolean.parseBoolean(args[9]);
            boolean adjust = Boolean.parseBoolean(args[10]);
            double p = Double.parseDouble(args[11]);
            Interpolation inter = Interpolation.RANK_LOG;
            int restarts = 1;
            int sl = 40;
            int motifL = 8;
            double eps = 1.0E-6;
            double lineps = eps * 0.001;
            double startD = 1.0;
            byte algo = 20;
            boolean fixedStrand = true;
            SafeOutputStream stream = SafeOutputStream.getSafeOutputStream(System.out);
            CappedHistory history = new CappedHistory(15, new NoRevertHistory(true, adjust, adjust));
            MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
            int anz = mrf ? 50 : 250;
            double[][] best = null;
            String fName = String.valueOf(home) + "/classifier/dream5-" + tf + "-" + array + "-" + type + "-fg-" + fgOrder + "-anz-" + components + "-bg-" + bgOrder + "-eqBg-" + bgsEq + "-" + adjust + "-" + inter.name() + "-" + p + "-" + nStart + ".xml";
            Pair<double[], DataSet> pair = Dream.getWeightedData(String.valueOf(home) + "/data/", tf, array, type);
            DataSet data = pair.getSecondElement();
            data = data.getInfixDataSet(0, sl);
            System.out.println(data.getNumberOfElements());
            double[] signal = pair.getFirstElement();
            double th = Interpolation.getThreshold(re2, signal, p);
            double[] fgWeights = Interpolation.getWeight(data, signal, th, inter);
            double[][] weights = new double[][]{fgWeights, Interpolation.getBgWeight(fgWeights)};
            DoubleList results = new DoubleList();
            Evaluation.fillResults(fgWeights, signal, data, null, results);
            Evaluation.printResults(System.out, results);
            try {
                re2.createVector("signal", signal);
                re2.createVector("weights", weights[0]);
                String plot = "h1=hist(signal,plot=F);\nh2=hist(weights,plot=F);\nlim1=c(min(h1$breaks),max(h1$breaks));lim2=c(min(h2$breaks),max(h2$breaks));m=matrix(c(2,1,4,3),ncol=2);\nlayout(m, widths = c(3,1), heights=c(1,3));\npar(mar=c(5,5,1,1));\nplot(signal,weights,xlab=\"mean\",ylab=expression(w^{fg}), xlim=lim1,ylim=lim2, cex.axis=1.5, cex.lab=2);\nmar = par(\"mar\");\n\nmyMar = mar;\nmyMar[1] = 0;\npar(mar=myMar);\nbarplot(h1$intensities,space=0,width=h1$breaks[2]-h1$breaks[1],col=3,axes=F,xlim=lim1,xpd=F);myMar = mar;\nmyMar[2] = 0;\npar(mar=myMar);\nbarplot(h2$intensities,space=0,width=h2$breaks[2]-h2$breaks[1],col=4,axes=F,ylim=lim2,horiz=T,xpd=F);";
                REnvironment.showImage("scatter " + (Object)((Object)inter), re2.plot(plot));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (re2 != null) {
                try {
                    re2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            double ess = 5.0;
            CompositeLogPrior prior = new CompositeLogPrior();
            double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MSP);
            int DataSetSize = 100;
            Cloneable[] score = new DifferentiableStatisticalModel[2];
            SkewNormalLikeDurationDiffSM motifPenalty = new SkewNormalLikeDurationDiffSM(1, 50, -1.5, -2.5, 4.2);
            System.out.println();
            HomogeneousMMDiffSM flanking = null;
            double[] flHyperPars = new double[bgOrder + 1];
            int i = 0;
            while (i < bgOrder) {
                flHyperPars[i] = ess * 0.2;
                ++i;
            }
            flHyperPars[flHyperPars.length - 1] = ess * ((double)(sl - bgOrder) - 0.2 * (double)motifL);
            flanking = new HomogeneousMMDiffSM(data.getAlphabetContainer(), bgOrder, ess * 0.2, flHyperPars, true, true, 1);
            double essMotif = ess * 0.8 / (double)components;
            AbstractDifferentiableStatisticalModel motif = !mrf ? new MarkovModelDiffSM(data.getAlphabetContainer(), motifL, essMotif, true, new InhomogeneousMarkov(fgOrder), (DurationDiffSM)motifPenalty) : new MarkovRandomFieldDiffSM(data.getAlphabetContainer(), motifL, essMotif, args[4]);
            motif = fixedStrand ? new StrandDiffSM((DifferentiableStatisticalModel)motif, 1, true, StrandDiffSM.InitMethod.INIT_FORWARD_STRAND, 0.5) : new StrandDiffSM((DifferentiableStatisticalModel)motif, 0.5, 1, true, StrandDiffSM.InitMethod.INIT_FORWARD_STRAND);
            motif.initializeFunctionRandomly(false);
            motif = new NormalizedDiffSM(motif, 1);
            double seqs = 1.0;
            double sd = (double)sl / 2.0;
            double skewSd = 1.0;
            double mu = (double)(sl - motifL) / 2.0;
            double[] q = new double[sl];
            Arrays.fill(q, 4.0);
            int i2 = 0;
            while (i2 < 3) {
                q[i2] = 3.0 / (1.0 + Math.exp(-1.0 - (double)i2)) + 1.0;
                ++i2;
            }
            i2 = 31;
            while (i2 < q.length) {
                q[i2] = 3.0 / (1.0 + Math.exp(-35.0 + (double)i2)) + 1.0;
                ++i2;
            }
            UniformDurationDiffSM pos = new UniformDurationDiffSM(0, sl - motifL, essMotif);
            DifferentiableStatisticalModel[] motifs = (DifferentiableStatisticalModel[])ArrayHandler.createArrayOf((Cloneable)motif, (int)components);
            if (components > 1) {
                motif = new MixtureDiffSM(1, false, motifs);
            }
            score[0] = new ExtendedZOOPSDiffSM(false, sl, 1, true, (HomogeneousDiffSM)flanking, (DifferentiableStatisticalModel)motif, pos, true);
            ess = score[0].getESS();
            double[] bgHyperPars = new double[bgsEq ? bgOrder + 1 : 1];
            int i3 = 0;
            while (i3 < bgHyperPars.length - 1) {
                bgHyperPars[i3] = ess * (1.0 - p) / p;
                ++i3;
            }
            bgHyperPars[bgHyperPars.length - 1] = ess * (double)(sl - (bgsEq ? bgOrder : 0)) * (1.0 - p) / p;
            score[1] = new HomogeneousMMDiffSM(data.getAlphabetContainer(), bgsEq ? bgOrder : 0, ess * (1.0 - p) / p, bgHyperPars, true, true, 1);
            LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
            double[][] smallWeights = new double[weights.length][];
            DataSet[] dd = new DataSet[2];
            LinkedList<Sequence> list = new LinkedList<Sequence>();
            DoubleList wList = new DoubleList();
            double[] help = (double[])weights[0].clone();
            System.out.println("for init:");
            int i4 = 0;
            while (i4 < weights.length) {
                list.clear();
                wList.clear();
                System.arraycopy(weights[i4], 0, help, 0, help.length);
                Arrays.sort(help);
                double t2 = help[help.length - DataSetSize];
                System.out.println(String.valueOf(help[0]) + "\t" + t2 + "\t" + help[help.length - 1]);
                int j = 0;
                while (j < weights[i4].length) {
                    if (weights[i4][j] >= t2 && list.size() < DataSetSize) {
                        list.add(data.getElementAt(j));
                        wList.add(weights[i4][j]);
                    }
                    ++j;
                }
                smallWeights[i4] = wList.toArray();
                dd[i4] = new DataSet("", list.toArray(new Sequence[0]));
                System.out.println("class " + i4 + "\t" + dd[i4].getNumberOfElements() + " sequences");
                ++i4;
            }
            LogGenDisMixFunction initObjective = new LogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, dd, smallWeights, prior, LearningPrinciple.getBeta(initKey), true, false);
            OneDataSetLogGenDisMixFunction objective = new OneDataSetLogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, data, (double[][])weights, (LogPrior)prior, beta, true, false);
            GenDisMixClassifierParameterSet cps = new GenDisMixClassifierParameterSet(data.getAlphabetContainer(), sl, algo, eps, lineps, startD, false, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
            DifferentiableSequenceScore[] bestNSF = null;
            int r = 0;
            while (r < restarts) {
                System.out.println("start " + r + " -------------------------------------------------");
                DifferentiableSequenceScore[] current = (DifferentiableStatisticalModel[])ArrayHandler.clone((Cloneable[])score);
                objective.reset(current);
                initObjective.reset(current);
                ComparableElement<double[], Double>[] pars = MutableMotifDiscovererToolbox.getSortedInitialParameters(current, initMeth, initObjective, anz, stream, 0);
                objective.setParams(pars[pars.length - 1].getElement());
                System.out.println(current[0]);
                System.out.println("_________________________________");
                objective.reset(current);
                double[][] res = MutableMotifDiscovererToolbox.optimize(current, objective, algo, new SmallDifferenceOfFunctionEvaluationsCondition(eps), lineps, new ConstantStartDistance(startD), stream, false, history, OptimizableFunction.KindOfParameter.PLUGIN, true);
                if (best == null || res[0][0] > best[0][0]) {
                    bestNSF = current;
                    best = res;
                }
                ++r;
            }
            GenDisMixClassifier cl = new GenDisMixClassifier(cps, (LogPrior)prior, (double)best[0][0], beta, (DifferentiableStatisticalModel[])bestNSF);
            cl.setClassWeights(false, (double[])best[1]);
            FileManager.writeFile(new File(fName), (CharSequence)cl.toXML());
            System.out.println(cl);
            double[] pred = Evaluation.getPred(cl, data);
            results.clear();
            data = data.getInfixDataSet(0, 35);
            System.out.print("weights  \t");
            Evaluation.fillResults(pred, fgWeights, data, null, results);
            Evaluation.printResults(System.out, results);
            results.clear();
            System.out.print("signal   \t");
            Evaluation.fillResults(pred, signal, data, null, results);
            Evaluation.printResults(System.out, results);
            results.clear();
            System.out.println("alternativ");
            String altArray = array.equals("HK") ? "ME" : "HK";
            String[] stringArray = t = new String[]{"mean", "corrected_mean", "median", "corrected_median"};
            int n = t.length;
            int n2 = 0;
            while (n2 < n) {
                String ty = stringArray[n2];
                pair = Dream.getWeightedData(String.valueOf(home) + "/data/", tf, altArray, ty);
                data = pair.getSecondElement().getInfixDataSet(0, sl);
                signal = pair.getFirstElement();
                pred = Evaluation.getPred(cl, data);
                results.clear();
                data = data.getInfixDataSet(0, 35);
                System.out.print(String.valueOf(ty) + "\t");
                Evaluation.fillResults(pred, signal, data, null, results);
                Evaluation.printResults(System.out, results);
                ++n2;
            }
            System.out.println("optimized: " + best[0][0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pair<double[], DataSet> getWeightedData(String home, String factor, String array, String type) throws Exception {
        DNAAlphabetContainer cont = DNAAlphabetContainer.SINGLETON;
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser("=", ";");
        SparseStringExtractor seqs = new SparseStringExtractor(String.valueOf(home) + factor + "-" + array + ".txt", '>', (SequenceAnnotationParser)parser);
        DoubleList sigVals = new DoubleList();
        LinkedList<Sequence> sequences = new LinkedList<Sequence>();
        while (seqs.hasMoreElements()) {
            SequenceAnnotation[] seqAn = seqs.getCurrentSequenceAnnotations();
            String seq = seqs.nextElement();
            int i = 0;
            while (i < seqAn.length && !seqAn[i].getType().equals(type)) {
                ++i;
            }
            if (i == seqAn.length) {
                throw new Exception();
            }
            double d = Double.parseDouble(seqAn[i].getIdentifier());
            if (Double.isNaN(d)) continue;
            sequences.add(Sequence.create(cont, seq));
            sigVals.add(d);
        }
        return new Pair<double[], DataSet>(sigVals.toArray(), new DataSet(String.valueOf(factor) + " " + array, sequences.toArray(new Sequence[0])));
    }

    private static double[] getCombinedWeight(double[] factor, double[] ... weights) {
        double[] newWeights = new double[weights[0].length];
        int i = 0;
        while (i < newWeights.length) {
            int f = 0;
            while (f < factor.length) {
                int n = i;
                newWeights[n] = newWeights[n] + factor[f] * weights[f][i];
                ++f;
            }
            ++i;
        }
        return newWeights;
    }
}

