/*
 * Decompiled with CFR 0.152.
 */
package challenges.dream5.paper;

import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.naming.OperationNotSupportedException;

public class KMerStatistics {
    private DataSet data;
    public WeightedKMers kmers;
    private boolean rc;
    private int off;
    private int k;
    private boolean useMeanForCC;

    public KMerStatistics(DataSet data, double[] truth, boolean rc, int off, int k, boolean useMeanForCC) throws OperationNotSupportedException {
        this.data = data;
        this.k = k;
        this.useMeanForCC = useMeanForCC;
        this.rc = rc;
        this.off = off;
        this.kmers = new WeightedKMers(data, truth);
    }

    public void fillStatistics(DataSet data, double[] signal, LinkedList<Sequence> positives, DoubleList results) throws Exception {
        WeightedKMers test = new WeightedKMers(data, signal);
        Set<Sequence> keys = this.kmers.list.keySet();
        HashMap<Sequence, Boolean> flags = new HashMap<Sequence, Boolean>();
        if (positives != null) {
            for (Sequence seq : keys) {
                flags.put(seq, false);
            }
            for (Sequence seq : positives) {
                Sequence rc;
                if (this.rc && (rc = seq.reverseComplement()).compareTo(seq) < 0) {
                    seq = rc;
                }
                flags.put(seq, true);
            }
        }
        double[] truth = new double[keys.size()];
        double[] pred = new double[truth.length];
        DoubleList posScores = new DoubleList();
        DoubleList negScores = new DoubleList();
        int i = 0;
        for (Sequence seq : keys) {
            double[] testVal = test.list.get(seq);
            if (positives != null) {
                if (((Boolean)flags.get(seq)).booleanValue()) {
                    posScores.add(testVal[0]);
                } else {
                    negScores.add(testVal[0]);
                }
            }
            truth[i] = this.kmers.list.get(seq)[this.useMeanForCC ? 1 : 0];
            pred[i] = testVal[this.useMeanForCC ? 1 : 0];
            ++i;
        }
        if (positives != null) {
            double[] posScoresAr = posScores.toArray();
            Arrays.sort(posScoresAr);
            double[] negScoresAr = negScores.toArray();
            Arrays.sort(negScoresAr);
            results.add((Double)new AucPR().compute(posScoresAr, negScoresAr).getResultForName("AUC-PR (Integral)").getValue());
            results.add((Double)new AucROC().compute(posScoresAr, negScoresAr).getResultForName("AUC-ROC").getValue());
        } else {
            results.add(Double.NaN);
            results.add(Double.NaN);
        }
        results.add(ToolBox.pearsonCorrelation(truth, pred));
    }

    public class WeightedKMers {
        public HashMap<Sequence, double[]> list;

        private WeightedKMers(DataSet data, double[] truth) throws OperationNotSupportedException {
            DoubleList temp;
            HashMap<Sequence, DoubleList> map = new HashMap<Sequence, DoubleList>();
            int i = 0;
            while (i < data.getNumberOfElements()) {
                Sequence seq = data.getElementAt(i);
                int j = 0;
                while (j < seq.getLength() - KMerStatistics.this.off - KMerStatistics.this.k + 1) {
                    Sequence rc;
                    Sequence sub = seq.getSubSequence(j, KMerStatistics.this.k);
                    if (KMerStatistics.this.rc && (rc = sub.reverseComplement()).compareTo(sub) < 0) {
                        sub = rc;
                    }
                    if (map.get(sub) == null) {
                        map.put(sub, new DoubleList());
                    }
                    temp = (DoubleList)map.get(sub);
                    temp.add(truth[i]);
                    ++j;
                }
                ++i;
            }
            Set keys = map.keySet();
            this.list = new HashMap();
            for (Sequence seq : keys) {
                temp = (DoubleList)map.get(seq);
                this.list.put(seq, new double[]{temp.median(0, temp.length()), temp.mean(0, temp.length())});
            }
        }
    }
}

