/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers.neuralNetworks.neurons;

import de.jstacs.Storable;
import de.jstacs.classifiers.neuralNetworks.neurons.InnerNeuron;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import java.util.ArrayList;

public abstract class Neuron
implements Storable {
    private ArrayList<InnerNeuron> descendants;

    public Neuron() {
        this.descendants = new ArrayList();
    }

    public Neuron(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
        if (this.descendants == null) {
            throw new NonParsableException();
        }
    }

    private void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.extractFurtherInformation(xml);
    }

    protected abstract void extractFurtherInformation(StringBuffer var1) throws NonParsableException;

    protected abstract StringBuffer getFurtherInformation();

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getFurtherInformation());
        XMLParser.addTags(sb, this.getClass().getSimpleName());
        return sb;
    }

    public final int getNumberOfDescendants() {
        return this.descendants.size();
    }

    public final InnerNeuron getDescendant(int i) {
        return this.descendants.get(i);
    }

    protected final void addDescendant(InnerNeuron neuron) {
        this.descendants.add(neuron);
    }

    public abstract int getNumberOfWeights();

    public abstract double getOutput(Sequence var1);

    public abstract void initializeRandomly();

    public abstract void reset();

    public abstract double getError(Sequence var1, double var2, double[] var4);

    public abstract void adaptWeights(double var1);
}

