/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.fitnessFunctions;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.utils.SafeOutputStream;

public class CombinedFitnessFunction<T extends Individual>
implements FitnessFunction<T> {
    private FitnessFunction<T>[] functions;
    private double[] weights;
    private SafeOutputStream out;
    private boolean log;

    public CombinedFitnessFunction(FitnessFunction<T>[] functions, double[] weights, boolean log) {
        this.functions = functions;
        this.weights = (double[])weights.clone();
        this.out = SafeOutputStream.getSafeOutputStream(null);
        this.log = log;
    }

    @Override
    public Double getFitness(T individual) throws Exception {
        double fitness = 0.0;
        int i = 0;
        while (i < this.weights.length) {
            fitness = this.log ? (fitness += this.weights[i] * Math.log(this.functions[i].getFitness(individual))) : (fitness += this.weights[i] * this.functions[i].getFitness(individual));
            ++i;
        }
        if (this.log) {
            fitness = Math.exp(fitness);
        }
        this.out.writeln("fitness: " + fitness);
        return fitness;
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        int i = 0;
        while (i < this.functions.length) {
            this.functions[i].setOutputStream(stream);
            ++i;
        }
        this.out = stream;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.functions.length) {
            this.functions[i].reset();
            ++i;
        }
    }
}

