/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.operations;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.operations.Crossover;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import de.jstacs.optimization.geneticAlgorithms.selection.IndividualSelection;
import java.util.LinkedList;
import java.util.Random;

public class SimpleCrossover<T extends Individual>
implements Crossover<T> {
    protected static Random r = new Random();
    private double percentCrossover;

    public SimpleCrossover(double percentCrossover) {
        this.percentCrossover = percentCrossover;
    }

    @Override
    public Population<T> getCrossoverPopulation(Population<T> original, FitnessFunction<T> fun, IndividualSelection<T> select) throws Exception {
        original = select.selectIndividuals(original, (int)Math.floor(this.percentCrossover * (double)original.getNumberOfIndivuals() / 2.0) * 2);
        LinkedList<T> ind1 = new LinkedList<T>();
        LinkedList<T> ind2 = new LinkedList<T>();
        int[] idxs = new int[original.getNumberOfIndivuals()];
        int i = 0;
        while (i < original.getNumberOfIndivuals()) {
            if (i % 2 == 0) {
                ind1.add(original.getIndividual(i));
            } else {
                T proposal = original.getIndividual(i);
                if (proposal.getHammingDistance((Individual)ind1.getLast()) < 2.0) {
                    int j = 0;
                    while (j < idxs.length) {
                        idxs[j] = j;
                        ++j;
                    }
                    T prop2 = proposal;
                    Individual other = (Individual)ind1.getLast();
                    int last = idxs.length;
                    while (last > 0 && prop2.getHammingDistance(other) < 2.0) {
                        int idx = r.nextInt(last);
                        prop2 = original.getIndividual(idxs[idx]);
                        idxs[idx] = idxs[--last];
                    }
                    proposal = prop2;
                }
                ind2.add(proposal);
            }
            ++i;
        }
        LinkedList<Individual> list = new LinkedList<Individual>();
        int i2 = 0;
        while (i2 < Math.min(ind1.size(), ind2.size())) {
            int lastPoss;
            Individual in2;
            Individual in1 = (Individual)ind1.get(i2);
            int firstPoss = in1.getFirstDifferentDimension(in2 = (Individual)ind2.get(i2));
            if (firstPoss >= (lastPoss = in1.getLastDifferentDimension(in2))) {
                list.add(in1);
                list.add(in2);
            } else {
                int crossdim = r.nextInt(lastPoss - firstPoss) + firstPoss;
                Individual ind = in1.crossover(crossdim, in2);
                ind.setFitness(fun);
                list.add(ind);
                ind = in2.crossover(crossdim, in1);
                ind.setFitness(fun);
                list.add(ind);
            }
            ++i2;
        }
        if (ind1.size() < ind2.size()) {
            list.add((Individual)ind2.get(ind2.size() - 1));
        } else if (ind2.size() < ind1.size()) {
            list.add((Individual)ind1.get(ind1.size() - 1));
        }
        return original.getPopulation(list);
    }

    @Override
    public Population<T> getModifiedPopulation(Population<T> original, FitnessFunction<T> fun, IndividualSelection<T> select) throws Exception {
        return this.getCrossoverPopulation(original, fun, select);
    }
}

