/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.optimization.geneticAlgorithms.populations;

import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public abstract class AbstractPopulation<T extends Individual>
implements Population<T> {
    protected static Random r = new Random();
    protected T[] individuals;

    public AbstractPopulation(T ... individuals) {
        this.individuals = (Individual[])individuals.clone();
    }

    @Override
    public int getNumberOfIndivuals() {
        return this.individuals.length;
    }

    @Override
    public T getIndividual(int index) {
        return this.individuals[index];
    }

    @Override
    public Population<T> join(Population<T> ... populations) {
        LinkedList<T> indiv = new LinkedList<T>();
        int i = 0;
        while (i < this.individuals.length) {
            indiv.add(this.individuals[i]);
            ++i;
        }
        i = 0;
        while (i < populations.length) {
            int j = 0;
            while (j < populations[i].getNumberOfIndivuals()) {
                indiv.add(populations[i].getIndividual(j));
                ++j;
            }
            ++i;
        }
        return this.getPopulation(indiv);
    }

    @Override
    public void sortIndividuals() {
        Arrays.sort(this.individuals);
    }

    @Override
    public Population<T> getBestIndividuals(int n) {
        Object[] ret = (Individual[])this.individuals.clone();
        Arrays.sort(ret);
        LinkedList<Object> list = new LinkedList<Object>();
        while (list.size() < n) {
            int i = 0;
            while (i < n && i < ret.length && list.size() < n) {
                list.add(ret[i]);
                ++i;
            }
        }
        return this.getPopulation(list);
    }

    @Override
    public Population<T> getWorstIndividuals(int n) {
        Object[] ret = (Individual[])this.individuals.clone();
        Arrays.sort(ret);
        LinkedList<Object> list = new LinkedList<Object>();
        while (list.size() < n) {
            int i = Math.max(0, this.individuals.length - n);
            while (i < this.individuals.length) {
                list.add(ret[i]);
                ++i;
            }
        }
        return this.getPopulation(list);
    }

    @Override
    public Population<T> removeDuplicates() {
        Object[] ret = (Individual[])this.individuals.clone();
        Arrays.sort(ret);
        LinkedList<Object> list = new LinkedList<Object>();
        int i = 0;
        if (ret.length > 0) {
            while (i < ret.length) {
                list.add(ret[i]);
                while (++i < ret.length && ((Individual)list.getLast()).equals((Individual)ret[i])) {
                }
            }
        }
        return this.getPopulation(list);
    }
}

