/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import challenges.dream5.Interpolation;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.MultipleIterationsCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.ArbitraryFloatSequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.Time;
import de.jstacs.utils.ToolBox;
import dimont.AbstractSingleMotifChIPper;
import dimont.ChipperParameterSet3;
import dimont.MyLogGenDisMixFunction3;
import dimont.ThresholdedStrandChIPper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class ChIPperMainSingleMotif2 {
    private static double ALPHA = 0.001;

    public static void main(String[] args) throws Exception {
        Time time;
        block60: {
            SignificantMotifOccurrencesFinder smof;
            ParameterSetTagger cParams = new ParameterSetTagger(ChipperParameterSet3.PREFIX, new ChipperParameterSet3());
            cParams.fillParameters("=", args);
            System.out.println("parameters:");
            System.out.println(cParams);
            System.out.println("_________________________________");
            if (!cParams.hasDefaultOrIsSet()) {
                System.out.println("Some of the required parameters are not specified.");
                System.exit(1);
            }
            int sd = 75;
            boolean modifyProfile = false;
            String home = cParams.getValueFromTag("home", String.class);
            String fgData = String.valueOf(home) + cParams.getValueFromTag("fg", String.class);
            String infix = cParams.getValueFromTag("infix", String.class);
            int motifLength = cParams.getValueFromTag("length", Integer.class);
            int motifNumber = cParams.getValueFromTag("motifs", Integer.class);
            int restarts = cParams.getValueFromTag("starts", Integer.class);
            int bgOrder = cParams.getValueFromTag("flankOrder", Integer.class);
            String position = cParams.getValueFromTag("position", String.class);
            String value = cParams.getValueFromTag("value", String.class);
            String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
            int threads = cParams.isSet("threads") ? cParams.getValueFromTag("threads", Integer.class) : AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors();
            DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
            AlphabetContainer ref = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
            double ess = 4.0;
            boolean free = false;
            time = Time.getTimeInstance(System.out);
            SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
            DataSet[] dataSetArray = new DataSet[2];
            dataSetArray[0] = SparseSequence.getDataSet((AlphabetContainer)con, fgData, parser);
            DataSet[] data = dataSetArray;
            System.out.println("data");
            System.out.println(String.valueOf(data[0].getAnnotation()) + "\t" + data[0].getNumberOfElements() + "\t" + "[" + data[0].getMinimalElementLength() + " .. " + data[0].getAverageElementLength() + " .. " + data[0].getMaximalElementLength() + "]");
            Sequence[] annotated = new Sequence[data[0].getNumberOfElements()];
            Sequence[] annotatedBg = new Sequence[data[0].getNumberOfElements()];
            double[][] weights = new double[][]{new double[data[0].getNumberOfElements()], new double[data[0].getNumberOfElements()]};
            double[] raw = (double[])weights[0].clone();
            double[] mean = new double[weights[0].length];
            int j = 0;
            while (j < weights[0].length) {
                annotated[j] = data[0].getElementAt(j);
                SequenceAnnotation[] seqAn = annotated[j].getAnnotation();
                mean[j] = Double.NaN;
                int i = 0;
                while (i < seqAn.length) {
                    if (seqAn[i].getType().equals(value)) {
                        raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                    } else if (seqAn[i].getType().equals(position)) {
                        mean[j] = Double.parseDouble(seqAn[i].getIdentifier());
                    }
                    ++i;
                }
                ++j;
            }
            float[][] histogram = new float[data[0].getNumberOfElements()][];
            float[][] histogramBg = new float[data[0].getNumberOfElements()][];
            int j2 = 0;
            while (j2 < weights[0].length) {
                histogram[j2] = new float[annotated[j2].getLength()];
                histogramBg[j2] = new float[annotated[j2].getLength()];
                float max = 0.0f;
                float sum = 0.0f;
                int i = 0;
                while (i < histogram[j2].length) {
                    histogram[j2][i] = (float)(((double)i - mean[j2]) / (double)sd);
                    histogram[j2][i] = (float)Math.exp(-0.5 * (double)histogram[j2][i] * (double)histogram[j2][i]);
                    sum += histogram[j2][i];
                    ++i;
                }
                i = 0;
                while (i < histogram[j2].length) {
                    float[] fArray = histogram[j2];
                    int n = i;
                    fArray[n] = fArray[n] / sum;
                    if (histogram[j2][i] > max) {
                        max = histogram[j2][i];
                    }
                    ++i;
                }
                i = 0;
                while (i < histogramBg[j2].length) {
                    histogramBg[j2][i] = max - histogram[j2][i];
                    ++i;
                }
                Sequence temp = annotated[j2].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogram[j2]), new Result[0]));
                annotatedBg[j2] = annotated[j2].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogramBg[j2]), new Result[0]));
                annotated[j2] = temp;
                ++j2;
            }
            data[0] = new DataSet("", annotated);
            data[1] = new DataSet("", annotatedBg);
            if (weightingFactor.endsWith("sd")) {
                double h = Double.parseDouble(weightingFactor.substring(0, weightingFactor.length() - 2));
                double meanRaw = ToolBox.sum(raw) / (double)raw.length;
                double sdRaw = 0.0;
                int i = 0;
                while (i < raw.length) {
                    sdRaw += (raw[i] - meanRaw) * (raw[i] - meanRaw);
                    ++i;
                }
                sdRaw = Math.sqrt(sdRaw / (double)raw.length);
                h = meanRaw + h * sdRaw;
                double anz = 0.0;
                int i2 = 0;
                while (i2 < raw.length) {
                    if (raw[i2] >= h) {
                        anz += 1.0;
                    }
                    ++i2;
                }
                System.out.println(anz / (double)raw.length);
                weights[0] = Interpolation.getWeight(data[0], raw, anz / (double)raw.length, Interpolation.RANK_LOG);
            } else {
                System.out.println("hier " + weightingFactor);
                weights[0] = Interpolation.getWeight(data[0], raw, Double.parseDouble(weightingFactor), Interpolation.RANK_LOG);
            }
            weights[1] = Interpolation.getBgWeight(weights[0]);
            System.out.println("weights");
            double[] thresholds = new double[data.length];
            int i = 0;
            while (i < data.length) {
                double sum = ToolBox.sum(weights[i]);
                thresholds[i] = ToolBox.percentile(weights[i], 0.8);
                System.out.println(String.valueOf(i) + "\t" + "[" + ToolBox.min(weights[i]) + " .. " + ToolBox.max(weights[i]) + "]" + "\t" + sum + "\t" + thresholds[i]);
                ++i;
            }
            System.out.println(Arrays.toString(thresholds));
            DataSet completeFgData = data[0];
            double[] completeFgWeight = weights[0];
            DataSet completeBgData = data[1];
            double[] completeBgWeight = weights[1];
            MarkovModelDiffSM motif = new MarkovModelDiffSM((AlphabetContainer)con, motifLength, ess, true, 0, null);
            ThresholdedStrandChIPper fg = new ThresholdedStrandChIPper(1, 0.5, motif);
            fg.initializeFunctionRandomly(false);
            HomogeneousDiffSM bg = ChIPperMainSingleMotif2.getHomSF(con, bgOrder, 2.0 * ess, data[0].getAverageElementLength());
            DifferentiableSequenceScore[] score = new DifferentiableStatisticalModel[]{fg, bg};
            double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MSP);
            SafeOutputStream stream = SafeOutputStream.getSafeOutputStream(System.out);
            LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
            String initMethod = "best-random-plugin=100";
            String v = initMethod.substring(initMethod.indexOf(61) + 1);
            MyLogGenDisMixFunction3 initObjective = new MyLogGenDisMixFunction3(threads, score, data, weights, new CompositeLogPrior(), LearningPrinciple.getBeta(initKey), true, free);
            MyLogGenDisMixFunction3 objective = new MyLogGenDisMixFunction3(threads, score, data, weights, new CompositeLogPrior(), beta, true, free);
            NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(objective);
            double eps = 1.0E-4;
            CombinedCondition stop = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(100));
            ConstantStartDistance start = new ConstantStartDistance(1.0);
            MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
            if (initMethod.startsWith("best-random=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.RANDOMLY;
            } else if (initMethod.startsWith("best-random-plugin=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN;
            } else if (initMethod.startsWith("best-random-motif=")) {
                initMeth[0] = MutableMotifDiscovererToolbox.InitMethodForDiffSM.MOTIF_RANDOMLY;
            }
            if (initMeth[0] == MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING) {
                throw new IllegalArgumentException("Initialization method not correctly set.");
            }
            double[] params = null;
            MutableMotifDiscoverer[] best = new MutableMotifDiscoverer[motifNumber];
            double[][] pwm = null;
            double[] entropy = new double[motifLength];
            double[] kl = new double[motifLength];
            byte algo = 18;
            GenDisMixClassifierParameterSet genDisMixParams = new GenDisMixClassifierParameterSet(con, 0, algo, eps, eps * 0.1, 1.0, free, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
            objective.reset(score);
            DataSet smallFgData = null;
            DataSet smallBgData = null;
            double[] smallFgWeight = null;
            double[] smallBgWeight = null;
            ComparableElement<double[], Double>[] pars = null;
            int m = 0;
            while (m < motifNumber) {
                double[] p;
                if (m == 0 || modifyProfile) {
                    Sequence seq;
                    float[] newHist;
                    int end;
                    int s;
                    ArrayList<Sequence> seqs = new ArrayList<Sequence>();
                    DoubleList wei = new DoubleList();
                    int i3 = 0;
                    while (i3 < completeFgWeight.length) {
                        if (completeFgWeight[i3] >= thresholds[0]) {
                            s = (int)Math.max(mean[i3] - (double)(2 * sd), 0.0);
                            end = (int)Math.min(mean[i3] + (double)(2 * sd), (double)annotated[i3].getLength());
                            newHist = new float[end - s + 1];
                            System.arraycopy(histogram[i3], s, newHist, 0, end - s);
                            seq = annotated[i3].getSubSequence(s, end - s);
                            seq = seq.annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, newHist), new Result[0]));
                            seqs.add(seq);
                            wei.add(completeFgWeight[i3]);
                        }
                        ++i3;
                    }
                    smallFgData = new DataSet("", seqs.toArray(new Sequence[0]));
                    smallFgWeight = wei.toArray();
                    seqs.clear();
                    wei.clear();
                    i3 = 0;
                    while (i3 < completeBgWeight.length) {
                        if (completeBgWeight[i3] >= thresholds[1]) {
                            s = 0;
                            end = (int)Math.min(mean[i3] - (double)(2 * sd), (double)annotatedBg[i3].getLength());
                            if (end - s + 1 > motifLength) {
                                newHist = new float[end - s + 1];
                                System.arraycopy(histogramBg[i3], s, newHist, 0, end - s);
                                seq = annotated[i3].getSubSequence(s, end - s);
                                seq = seq.annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, newHist), new Result[0]));
                                seqs.add(seq);
                                wei.add(completeBgWeight[i3]);
                            }
                            s = (int)Math.min(mean[i3] + (double)(2 * sd), (double)annotatedBg[i3].getLength());
                            end = annotatedBg[i3].getLength();
                            if (end - s + 1 > motifLength) {
                                newHist = new float[end - s + 1];
                                System.arraycopy(histogramBg[i3], s, newHist, 0, end - s);
                                seq = annotated[i3].getSubSequence(s, end - s);
                                seq = seq.annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, newHist), new Result[0]));
                                seqs.add(seq);
                                wei.add(completeBgWeight[i3]);
                            }
                        }
                        ++i3;
                    }
                    smallBgData = new DataSet("", seqs.toArray(new Sequence[0]));
                    smallBgWeight = wei.toArray();
                    System.out.println(String.valueOf(completeFgData.getNumberOfElements()) + " -> " + smallFgData.getNumberOfElements());
                    System.out.println(String.valueOf(completeBgData.getNumberOfElements()) + " -> " + smallBgData.getNumberOfElements());
                    System.out.println(String.valueOf(completeFgData.getAverageElementLength()) + " -> " + smallFgData.getAverageElementLength());
                    System.out.println(String.valueOf(completeBgData.getAverageElementLength()) + " -> " + smallBgData.getAverageElementLength());
                }
                data[0] = smallFgData;
                weights[0] = smallFgWeight;
                data[1] = smallBgData;
                weights[1] = smallBgWeight;
                best[m] = (MutableMotifDiscoverer)((Object)score[0]);
                boolean lengthAdjust = false;
                int j3 = 0;
                while (j3 < best[m].getNumberOfMotifs()) {
                    if (best[m].getMotifLength(j3) != motifLength) {
                        lengthAdjust = true;
                        best[m].modifyMotif(j3, 0, motifLength - best[m].getMotifLength(j3));
                    }
                    System.out.println("motif " + j3 + ": " + best[m].getMotifLength(j3));
                    ++j3;
                }
                ((AbstractSingleMotifChIPper)score[0]).reset();
                initObjective.setDataAndWeights(data, weights);
                initObjective.reset(score);
                objective.reset(score);
                pars = MutableMotifDiscovererToolbox.getSortedInitialParameters(score, initMeth, initObjective, Integer.parseInt(v), stream, 0);
                pars = ChIPperMainSingleMotif2.removeSimilar(pars, (DifferentiableStatisticalModel)score[0], restarts);
                double bestVal = Double.NEGATIVE_INFINITY;
                int r = 0;
                while (r < restarts) {
                    System.out.println("---------------------------------------------------------");
                    System.out.println("start : " + r);
                    objective.setDataAndWeights(data, weights);
                    objective.resetHeuristics();
                    start.reset();
                    p = pars[pars.length - r - 1].getElement();
                    objective.setParams(p);
                    Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                    objective.setParams(p);
                    System.out.println(score[0]);
                    data[0] = completeFgData;
                    weights[0] = completeFgWeight;
                    data[1] = completeBgData;
                    weights[1] = completeBgWeight;
                    objective.setDataAndWeights(data, weights);
                    objective.resetHeuristics();
                    double optVal = objective.evaluateFunction(p);
                    if (r + 1 != restarts) {
                        data[0] = smallFgData;
                        weights[0] = smallFgWeight;
                        data[1] = smallBgData;
                        weights[1] = smallBgWeight;
                    }
                    System.out.println(optVal);
                    if (optVal > bestVal) {
                        bestVal = optVal;
                        params = p;
                        best[m] = (MutableMotifDiscoverer)score[0].clone();
                    }
                    ++r;
                }
                score[0] = (DifferentiableStatisticalModel)((Object)best[m]);
                ((AbstractSingleMotifChIPper)score[0]).reset();
                objective.reset(score);
                objective.setParams(params);
                if (ChIPperMainSingleMotif2.heuristic(best[m], completeFgData, completeFgWeight, completeBgData, objective)) {
                    objective.reset(score);
                }
                p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
                objective.setParams(p);
                Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                if (ChIPperMainSingleMotif2.heuristic((MutableMotifDiscoverer)((Object)score[0]), completeFgData, completeFgWeight, completeBgData, objective)) {
                    ((AbstractSingleMotifChIPper)score[0]).reset();
                    objective.reset(score);
                    p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
                    objective.setParams(p);
                    Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, stream);
                }
                System.out.println("=========================================================");
                GenDisMixClassifier cl = new GenDisMixClassifier(genDisMixParams, (LogPrior)new CompositeLogPrior(), objective.evaluateFunction(p), LearningPrinciple.getBeta(LearningPrinciple.MSP), (DifferentiableStatisticalModel[])score);
                StringBuffer xml = new StringBuffer();
                XMLParser.appendObjectWithTags(xml, cl, "classifier");
                FileManager.writeFile(new File(String.valueOf(home) + "/" + infix + "-motif-" + m + ".xml"), (CharSequence)xml);
                if (modifyProfile && m + 1 < motifNumber) {
                    smof = new SignificantMotifOccurrencesFinder(best[m], completeBgData, null, ALPHA);
                    DataSet an = smof.annotateMotif(completeFgData, 0);
                    int i4 = 0;
                    while (i4 < annotated.length) {
                        SequenceAnnotation[] seqAn = an.getElementAt(i4).getAnnotation();
                        if (seqAn != null) {
                            int k = 0;
                            while (k < seqAn.length) {
                                if (seqAn[k] instanceof MotifAnnotation) {
                                    MotifAnnotation ma = (MotifAnnotation)seqAn[k];
                                    Arrays.fill(histogram[i4], Math.max(0, ma.getPosition() - motifLength / 2), Math.min(histogram[i4].length, ma.getPosition() + motifLength / 2), 0.0f);
                                }
                                ++k;
                            }
                        }
                        annotated[i4] = annotated[i4].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogram[i4]), new Result[0]));
                        ++i4;
                    }
                    completeFgData = new DataSet("", annotated);
                }
                ++m;
            }
            REnvironment re = null;
            try {
                try {
                    re = new REnvironment();
                    re.voidEval("require(seqLogo);");
                    m = 0;
                    while (m < motifNumber) {
                        GenDisMixClassifier cl = (GenDisMixClassifier)XMLParser.extractObjectForTags(FileManager.readFile(String.valueOf(home) + "/" + infix + "-motif-" + m + ".xml"), "classifier");
                        best[m] = (MutableMotifDiscoverer)((Object)cl.getDifferentiableSequenceScore(0));
                        System.out.println("score: " + cl.getLastScore());
                        System.out.println("motif " + m + ":");
                        System.out.println(best[m]);
                        int im = 0;
                        while (im < best[m].getNumberOfMotifs()) {
                            double[][] pwm_pars = ((MarkovModelDiffSM)((AbstractSingleMotifChIPper)best[m]).getFunction(im)).getPWM();
                            re.createMatrix("pwm", pwm_pars);
                            re.plotToPDF("seqLogo(t(pwm))", String.valueOf(home) + "/" + infix + "-motif-" + m + "-as_trained.pdf", true);
                            smof = new SignificantMotifOccurrencesFinder(best[m], data[1], null, ALPHA);
                            pwm = smof.getPWM(im, data[0], weights[0], 0, 0);
                            int i5 = 0;
                            while (i5 < pwm.length) {
                                System.out.println(Arrays.toString(pwm[i5]));
                                ++i5;
                            }
                            re.createMatrix("pwm", pwm);
                            re.plotToPDF("seqLogo(t(pwm))", String.valueOf(home) + "/" + infix + "-motif-" + m + "-as_predicted.pdf", true);
                            ++im;
                        }
                        ++m;
                    }
                    re.createVector("raw", raw);
                    re.createVector("p", weights[0]);
                    re.plotToPDF("plot( raw, p, col=2 );plot( ecdf(raw), add=T );", String.valueOf(home) + "/" + infix + "-signal.pdf", true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (re != null) {
                            re.close();
                        }
                        break block60;
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    break block60;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (re != null) {
                        re.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (re != null) {
                    re.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(time.getElapsedTime());
    }

    private static boolean heuristic(MutableMotifDiscoverer best, DataSet completeFgData, double[] completeFgWeight, DataSet completeBgData, LogGenDisMixFunction objective) throws Exception {
        SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(best, completeBgData, null, ALPHA);
        boolean modified = false;
        int im = 0;
        while (im < best.getNumberOfMotifs()) {
            System.out.println("before:\n" + best);
            double[][] pwm = smof.getPWM(im, completeFgData, completeFgWeight, 0, 0);
            double[] entropy = new double[pwm.length];
            double[] kl = new double[pwm.length];
            double[] bgDistr = PFMComparator.getCounts(completeFgData);
            PFMComparator.normalize(bgDistr);
            System.out.println("fg: " + Arrays.toString(bgDistr));
            int i = 0;
            while (i < pwm.length) {
                kl[i] = 0.0;
                entropy[i] = 0.0;
                int j = 0;
                while (j < pwm[i].length) {
                    if (pwm[i][j] > 0.0) {
                        int n = i;
                        entropy[n] = entropy[n] - pwm[i][j] * Math.log(pwm[i][j]);
                    }
                    int n = i;
                    kl[n] = kl[n] + (pwm[i][j] - bgDistr[j]) * Math.log(pwm[i][j] / bgDistr[j]);
                    ++j;
                }
                System.out.println(String.valueOf(i) + "\t" + Arrays.toString(pwm[i]) + "\t" + entropy[i] + "\t" + kl[i]);
                ++i;
            }
            int left = 0;
            int right = 0;
            double thresh = 0.7;
            while (left < kl.length && kl[left] < thresh) {
                ++left;
            }
            while (right > -kl.length && kl[kl.length - 1 + right] < thresh) {
                --right;
            }
            System.out.println("left: " + left + ", right: " + right);
            if (left == kl.length || right == -kl.length) {
                System.out.println("tried to remove the complete motif: no modifications");
            } else {
                double normOld = ((DifferentiableStatisticalModel)((Object)best)).getLogNormalizationConstant();
                if (left != 0 || right != 0) {
                    if (best.modifyMotif(im, left, right)) {
                        double w = normOld - ((DifferentiableStatisticalModel)((Object)best)).getLogNormalizationConstant();
                        objective.addTermToClassParameter(0, w);
                    }
                    System.out.println("after:\n" + best);
                    modified = true;
                } else {
                    System.out.println("no modifications for the motif");
                }
            }
            ++im;
        }
        return modified;
    }

    private static HomogeneousDiffSM getHomSF(AlphabetContainer con, int order, double ess, double length) throws Exception {
        if (order >= 0) {
            return new HomogeneousMMDiffSM(con, order, ess, (int)Math.round(length));
        }
        return new UniformHomogeneousDiffSM(con, ess);
    }

    private static ComparableElement<double[], Double>[] removeSimilar2(ComparableElement<double[], Double>[] pars, DifferentiableStatisticalModel model, int restarts, int motifs) throws Exception {
        int d;
        int j;
        ComparableElement[] res = new ComparableElement[restarts * motifs];
        Sequence[] seqs = new Sequence[pars.length];
        Sequence[][] usedSeqs = new Sequence[motifs][restarts];
        boolean[] used = new boolean[pars.length];
        boolean[][] localUsed = new boolean[motifs][pars.length];
        int i = 0;
        while (i < pars.length) {
            seqs[i] = ChIPperMainSingleMotif2.getSequence(model, pars[i].getElement());
            ++i;
        }
        int[][] dist = new int[seqs.length][seqs.length];
        int i2 = 0;
        while (i2 < seqs.length) {
            j = 0;
            while (j < seqs.length) {
                dist[i2][j] = ChIPperMainSingleMotif2.getMinimumHammingDistance(seqs[i2], seqs[j]);
                ++j;
            }
            ++i2;
        }
        int k = 0;
        j = 0;
        while (j < motifs) {
            d = ChIPperMainSingleMotif2.getMaximumMeanDistance(dist, used);
            usedSeqs[j][0] = seqs[d];
            res[j * restarts] = pars[d];
            used[d] = true;
            localUsed[j][d] = true;
            ++k;
            ++j;
        }
        int[] curr = new int[motifs];
        Arrays.fill(curr, 1);
        while (k < res.length) {
            d = ChIPperMainSingleMotif2.getMaximumMeanDistance(dist, used);
            int motif = -100;
            double min = Double.POSITIVE_INFINITY;
            int i3 = 0;
            while (i3 < curr.length) {
                double mean;
                if (curr[i3] < restarts && (mean = ChIPperMainSingleMotif2.getMeanDistance(d, dist, localUsed[i3])) < min) {
                    min = mean;
                    motif = i3;
                }
                ++i3;
            }
            res[motif * restarts + curr[motif]] = pars[d];
            usedSeqs[motif][curr[motif]] = seqs[d];
            used[d] = true;
            localUsed[motif][d] = true;
            int n = motif;
            curr[n] = curr[n] + 1;
            ++k;
        }
        ComparableElement[] res2 = new ComparableElement[restarts * motifs];
        int i4 = 0;
        while (i4 < res.length) {
            res2[res2.length - i4 - 1] = res[i4];
            ++i4;
        }
        i4 = 0;
        while (i4 < usedSeqs.length) {
            System.out.println(String.valueOf(i4) + " " + Arrays.toString(usedSeqs[i4]));
            ++i4;
        }
        return res2;
    }

    private static int getMaximumMeanDistance(int[][] dist, boolean[] used) {
        int maxIdx = -1;
        double maxMean = -1.0;
        int i = dist.length - 1;
        while (i >= 0) {
            double temp;
            if (!used[i] && (temp = ChIPperMainSingleMotif2.getMeanDistance(i, dist, used)) > maxMean) {
                maxMean = temp;
                maxIdx = i;
            }
            --i;
        }
        return maxIdx;
    }

    private static double getMeanDistance(int currIdx, int[][] dist, boolean[] used) {
        double mean = 0.0;
        double n = 0.0;
        int i = 0;
        while (i < dist[currIdx].length) {
            if (i != currIdx && used[i]) {
                mean += (double)dist[currIdx][i];
                n += 1.0;
            }
            ++i;
        }
        if (n == 0.0) {
            return 0.0;
        }
        return mean / n;
    }

    private static ComparableElement<double[], Double>[] removeSimilar(ComparableElement<double[], Double>[] pars, DifferentiableStatisticalModel model, int restarts) throws Exception {
        ComparableElement[] res = new ComparableElement[restarts];
        Sequence[] seqs = new Sequence[pars.length];
        boolean[] used = new boolean[pars.length];
        int i = res.length - 1;
        int j = pars.length - 1;
        res[i] = pars[j];
        seqs[j] = ChIPperMainSingleMotif2.getSequence(model, pars[j].getElement());
        used[j] = true;
        System.out.println("best: " + seqs[j]);
        --i;
        --j;
        while (i >= 0 && j >= 0) {
            seqs[j] = ChIPperMainSingleMotif2.getSequence(model, pars[j].getElement());
            System.out.println(String.valueOf(j) + " " + seqs[j]);
            int dist = ChIPperMainSingleMotif2.getMinimumHammingDistance(seqs, used, j);
            System.out.println("dist: " + dist);
            if (dist > 3) {
                System.out.println("accepted");
                res[i] = pars[j];
                used[j] = true;
                --i;
            }
            --j;
        }
        System.out.println("i: " + i);
        if (i >= 0) {
            j = pars.length - 2;
            while (j >= 0 && i >= 0) {
                if (!used[j]) {
                    res[i] = pars[j];
                    --i;
                }
                --j;
            }
        }
        return res;
    }

    private static int getMinimumHammingDistance(Sequence curr, Sequence seq2) throws Exception {
        int d2;
        int d1;
        Sequence sub2;
        Sequence subRc;
        Sequence sub1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i <= curr.getLength() / 2) {
            sub1 = curr.getSubSequence(i);
            subRc = curr.reverseComplement().getSubSequence(i);
            sub2 = seq2.getSubSequence(0, seq2.getLength() - i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        i = 1;
        while (i <= curr.getLength() / 2) {
            sub1 = curr.getSubSequence(0, curr.getLength() - i);
            subRc = curr.reverseComplement().getSubSequence(0, curr.getLength() - i);
            sub2 = seq2.getSubSequence(i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        return min;
    }

    private static int getMinimumHammingDistance(Sequence[] seqs, boolean[] used, int j) throws Exception {
        Sequence curr = seqs[j];
        ++j;
        int min = Integer.MAX_VALUE;
        while (j < seqs.length) {
            int dist;
            if (used[j] && (dist = ChIPperMainSingleMotif2.getMinimumHammingDistance(curr, seqs[j])) < min) {
                min = dist;
            }
            ++j;
        }
        return min;
    }

    private static Sequence getSequence(DifferentiableStatisticalModel model, double[] pars) throws Exception {
        model.setParameters(pars, 2);
        double[][] pwm_pars = ((MarkovModelDiffSM)((AbstractSingleMotifChIPper)model).getFunction(0)).getPWM();
        byte[] cont = new byte[pwm_pars.length];
        int i = 0;
        while (i < pwm_pars.length) {
            cont[i] = (byte)ToolBox.getMaxIndex(pwm_pars[i]);
            ++i;
        }
        return new ByteSequence(model.getAlphabetContainer(), cont);
    }
}

