/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.classifiers.AbstractScoreBasedClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import java.io.File;
import java.util.Arrays;

public class DREAMTrainEvaluation {
    private static AucROC aucROC = new AucROC();
    private static AucPR aucPR = new AucPR();

    public static void main(String[] args) throws Exception {
        String home = "//qlb-fs01/SG/Keilwagen/Profil/Eigene Dateien/data/dream5/training-data/";
        Object[] fNames = new File(home).list();
        File clHome = new File(String.valueOf(home) + "../ChIPper-oneDataSet/");
        Arrays.sort(fNames);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        int i = 0;
        while (i < fNames.length) {
            DNADataSet[] d = new DNADataSet[]{new DNADataSet(String.valueOf(home) + (String)fNames[i], '>', parser), new DNADataSet(String.valueOf(home) + (String)fNames[i + 1], '>', parser)};
            double[][] signal = new double[][]{DREAMTrainEvaluation.getSignal(d[0], "signal"), DREAMTrainEvaluation.getSignal(d[1], "signal")};
            String factor = ((String)fNames[i]).substring(0, ((String)fNames[i]).lastIndexOf(45));
            RegExFilenameFilter filter = new RegExFilenameFilter("classifier", RegExFilenameFilter.Directory.FORBIDDEN, true, String.valueOf(factor) + ".*\\.xml");
            String[] clNames = clHome.list(filter);
            int j = 0;
            while (j < clNames.length) {
                boolean me = clNames[j].startsWith(String.valueOf(factor) + "-ME");
                GenDisMixClassifier cl = (GenDisMixClassifier)XMLParser.extractObjectForTags(FileManager.readFile(String.valueOf(clHome.getAbsolutePath()) + "/" + clNames[j]), "classifier");
                double[][] pred = new double[][]{DREAMTrainEvaluation.getPred(cl, d[0]), DREAMTrainEvaluation.getPred(cl, d[1])};
                System.out.print(String.valueOf(clNames[j]) + "\t" + cl.getLastScore());
                DREAMTrainEvaluation.evaluate(me, signal, pred);
                ++j;
            }
            i += 2;
        }
    }

    private static void evaluate(boolean me, double[][] signal, double[][] pred) throws Exception {
        int add;
        int start;
        if (me) {
            start = 0;
            add = 1;
        } else {
            start = signal.length - 1;
            add = -1;
        }
        boolean[][] clazz = new boolean[2][];
        int i = 0;
        while (i < signal.length) {
            double meanRaw = ToolBox.sum(signal[i]) / (double)signal.length;
            double sdRaw = 0.0;
            int j = 0;
            while (j < signal[i].length) {
                sdRaw += (signal[i][j] - meanRaw) * (signal[i][j] - meanRaw);
                ++j;
            }
            sdRaw = Math.sqrt(sdRaw / (double)signal[i].length);
            double t = meanRaw + 4.0 * sdRaw;
            double[] clone = (double[])signal[i].clone();
            Arrays.sort(clone);
            if (t > clone[clone.length - 50]) {
                t = clone[clone.length - 50];
            }
            clazz[i] = new boolean[signal[i].length];
            int j2 = 0;
            while (j2 < signal[i].length) {
                clazz[i][j2] = signal[i][j2] >= t;
                ++j2;
            }
            ++i;
        }
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        int i2 = 0;
        while (i2 < signal.length) {
            System.out.print("\t" + ToolBox.pearsonCorrelation(signal[start], pred[start]));
            pos.clear();
            neg.clear();
            int j = 0;
            while (j < signal[start].length) {
                if (clazz[start][j]) {
                    pos.add(pred[start][j]);
                } else {
                    neg.add(pred[start][j]);
                }
                ++j;
            }
            double[] posArray = pos.toArray();
            Arrays.sort(posArray);
            double[] negArray = neg.toArray();
            Arrays.sort(negArray);
            NumericalResultSet nr = aucROC.compute(posArray, negArray);
            System.out.print("\t" + nr.getResultAt(0).getValue());
            System.out.print("\t" + ToolBox.spearmanCorrelation(signal[start], pred[start]));
            nr = aucPR.compute(posArray, negArray);
            System.out.print("\t" + nr.getResultAt(0).getValue());
            ++i2;
            start += add;
        }
        System.out.println();
    }

    private static double[] getSignal(DataSet d, String type) {
        double[] signal = new double[d.getNumberOfElements()];
        int i = 0;
        while (i < signal.length) {
            signal[i] = Double.parseDouble(d.getElementAt(i).getSequenceAnnotationByType(type, 0).getIdentifier());
            ++i;
        }
        return signal;
    }

    public static double[] getPred(AbstractScoreBasedClassifier cl, DataSet data) throws Exception {
        return cl.getScores(data);
    }
}

