/*
 * Decompiled with CFR 0.152.
 */
package dimont;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import dimont.AbstractSingleMotifChIPper;
import java.util.Arrays;
import java.util.HashMap;
import javax.naming.OperationNotSupportedException;

public class ThresholdedCombinedChIPper
extends AbstractSingleMotifChIPper {
    private static final double LOG2 = Math.log(2.0);
    private double threshold;
    private HashMap<Sequence, IntList> toBeUsedHash;
    private double[] scoreProfile;
    private double[] normedProfile;
    private double[] noMotif;
    private double[] temp;
    private IntList end;

    public ThresholdedCombinedChIPper(int starts, double t, DifferentiableStatisticalModel motif) throws CloneNotSupportedException {
        super(starts, motif);
        if (t <= 0.0 || t > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = t;
        this.init();
    }

    public ThresholdedCombinedChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    @Override
    protected void init() {
        super.init();
        this.toBeUsedHash = new HashMap();
        this.noMotif = new double[1];
        this.end = new IntList();
    }

    @Override
    public ThresholdedCombinedChIPper clone() throws CloneNotSupportedException {
        ThresholdedCombinedChIPper clone = (ThresholdedCombinedChIPper)super.clone();
        if (this.scoreProfile != null) {
            clone.scoreProfile = (double[])this.scoreProfile.clone();
        }
        if (this.normedProfile != null) {
            clone.normedProfile = (double[])this.normedProfile.clone();
        }
        if (this.temp != null) {
            clone.temp = (double[])this.temp.clone();
        }
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            clone.toBeUsedHash.put(s, this.toBeUsedHash.get(s).clone());
        }
        clone.noMotif = (double[])this.noMotif.clone();
        clone.end = this.end.clone();
        return clone;
    }

    @Override
    protected int fillMotifComponentScoreOf(double[] array, Sequence sequence, int startpos) {
        int end = this.fillComponentScoreOf(array, sequence, startpos, null, false);
        return end;
    }

    protected int fillComponentScoreOf(Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[0].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.scoreProfile == null || this.scoreProfile.length < 2 * end) {
            this.scoreProfile = new double[seq.getLength() * 2];
        }
        return this.fillComponentScoreOf(this.scoreProfile, seq, start, b, usePosition);
    }

    protected int fillComponentScoreOf(double[] array, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[0].getLength();
        int end = seq.getLength() - start - m + 1;
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int curr = -1;
        Arrays.fill(array, Double.NEGATIVE_INFINITY);
        if (b != null) {
            int s;
            int l = s = b.get(0) == Integer.MIN_VALUE ? 1 : 0;
            while (l < b.length()) {
                curr = b.get(l);
                boolean rc = false;
                if (curr < 0) {
                    rc = true;
                    curr = -curr - 1;
                }
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    if (rc) {
                        try {
                            array[j++] = pos - LOG2 - (double)m * this.logP + this.function[0].getLogScoreFor(seq.reverseComplement(), seq.getLength() - curr - m);
                        }
                        catch (OperationNotSupportedException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        array[j++] = pos - LOG2 - (double)m * this.logP + this.function[0].getLogScoreFor(seq, curr);
                    }
                }
                ++l;
            }
        } else {
            int l = 0;
            while (l < end) {
                curr = start + l;
                if (curr >= start && curr <= seq.getLength() - m) {
                    if (position != null) {
                        pos = position[curr];
                    }
                    try {
                        array[j++] = pos - LOG2 - (double)m * this.logP + Normalisation.getLogSum(this.function[0].getLogScoreFor(seq, curr), this.function[0].getLogScoreFor(seq.reverseComplement(), seq.getLength() - curr - m));
                    }
                    catch (OperationNotSupportedException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++l;
            }
        }
        return j;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        IntList b = this.toBeUsedHash.get(seq);
        this.componentScore[this.function.length] = b == null || b.length() >= 1 && b.get(0) == Integer.MIN_VALUE ? h + this.logHiddenPotential[this.function.length] : Double.NEGATIVE_INFINITY;
        int j = this.fillComponentScoreOf(seq, start, b == null ? null : b, true);
        this.componentScore[0] = h + this.logHiddenPotential[0] + Normalisation.getLogSum(0, j, this.scoreProfile);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double logScore;
        int n;
        boolean add;
        double pos = Double.NaN;
        IntList b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add) {
            b = new IntList();
        } else {
            b.clear();
        }
        int m = this.function[0].getLength();
        int stop = seq.getLength() - start - m + 1;
        if (stop > 0) {
            float[] position = this.getPosition(seq, true);
            if (position == null) {
                pos = -Math.log(stop);
            }
            if (this.scoreProfile == null || this.scoreProfile.length < 2 * stop) {
                this.scoreProfile = new double[seq.getLength() * 2];
            }
            if (this.normedProfile == null || this.normedProfile.length < 2 * stop) {
                this.normedProfile = new double[seq.getLength() * 2];
            }
            if (this.temp == null || this.temp.length < 2 * stop + 1) {
                this.temp = new double[seq.getLength() * 2];
            }
            n = 0;
            int l = start;
            while (n < stop) {
                if (position != null) {
                    pos = position[l];
                }
                this.scoreProfile[n] = this.logHiddenPotential[0] + pos - LOG2 - (double)m * this.logP + this.function[0].getLogScoreFor(seq, l);
                try {
                    this.scoreProfile[n + stop] = this.logHiddenPotential[0] + pos - LOG2 - (double)m * this.logP + this.function[0].getLogScoreFor(seq.reverseComplement(), seq.getLength() - l - m);
                }
                catch (OperationNotSupportedException e1) {
                    throw new RuntimeException(e1);
                }
                ++l;
                ++n;
            }
            this.noMotif[0] = this.logHiddenPotential[this.function.length];
            logScore = Normalisation.logSumNormalisation(this.scoreProfile, 0, 2 * stop, this.noMotif, this.normedProfile, 0);
            System.arraycopy(this.normedProfile, 0, this.temp, 0, 2 * stop);
            this.temp[2 * stop] = this.noMotif[0];
            Arrays.sort(this.temp, 0, 2 * stop + 1);
            int e = 2 * stop;
            double s = 0.0;
            while (e > 0 && (s += this.temp[e]) < this.threshold) {
                --e;
            }
            double t = this.temp[e];
            int help = e;
            int k = 0;
            if (this.noMotif[0] >= t) {
                b.add(Integer.MIN_VALUE);
                this.normedProfile[k++] = this.logHiddenPotential[this.function.length];
            }
            this.iList[0].clear();
            this.dList[0].clear();
            this.end.clear();
            e = 0;
            while (e < stop) {
                if (this.normedProfile[e] >= t) {
                    this.normedProfile[k++] = this.scoreProfile[e];
                    this.function[0].getLogScoreAndPartialDerivation(seq, start + e, this.iList[0], this.dList[0]);
                    b.add(e);
                    this.end.add(this.iList[0].length());
                }
                ++e;
            }
            try {
                e = 0;
                while (e < stop) {
                    if (this.normedProfile[stop + e] >= t) {
                        this.normedProfile[k++] = this.scoreProfile[stop + e];
                        this.function[0].getLogScoreAndPartialDerivation(seq.reverseComplement(), seq.getLength() - (start + e) - m, this.iList[0], this.dList[0]);
                        b.add(-e - 1);
                        this.end.add(this.iList[0].length());
                    }
                    ++e;
                }
            }
            catch (OperationNotSupportedException e1) {
                throw new RuntimeException(e1);
            }
            this.componentScore[0] = this.logHiddenPotential[0] + Normalisation.logSumNormalisation(this.normedProfile, 0, k);
            this.componentScore[0] = 1.0 - this.noMotif[0];
            this.componentScore[1] = this.noMotif[0];
            k = b.get(0) == Integer.MIN_VALUE ? 1 : 0;
            int counter = 0;
            while (k < b.length()) {
                e = this.end.get(k);
                while (counter < e) {
                    indices.add(this.iList[0].get(counter) + this.paramRef[0]);
                    partialDer.add(this.dList[0].get(counter++) * this.normedProfile[k]);
                }
                ++k;
            }
            if (add && start == 0) {
                this.toBeUsedHash.put(seq, b);
            }
        } else {
            this.componentScore[0] = 0.0;
            this.componentScore[1] = 1.0;
            logScore = this.logHiddenPotential[this.function.length];
            b.add(Integer.MIN_VALUE);
        }
        n = this.function.length;
        int j = 0;
        while (j < 2) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore + this.logP * (double)(seq.getLength() - start);
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        if (motif > 0 || component > this.function.length) {
            throw new IndexOutOfBoundsException();
        }
        DifferentiableStatisticalModel m = this.function[component];
        while (m instanceof NormalizedDiffSM) {
            m = ((NormalizedDiffSM)m).getFunction();
        }
        Sequence ts = sequence.getSubSequence(startpos, m.getLength());
        double[] temp = new double[]{m.getLogScoreFor(ts), m.getLogScoreFor(ts.reverseComplement())};
        Normalisation.logSumNormalisation(temp);
        return temp;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            int end = this.fillComponentScoreOf(sequence, startpos, null, false);
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l > 0) {
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, this.scoreProfile);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                res = new double[l + 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = this.scoreProfile[i] + d;
                    ++i;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void reset() {
        this.toBeUsedHash.clear();
    }

    @Override
    public /* synthetic */ double[] getStrandProfileOfScoresFor(Sequence sequence, boolean bl) throws OperationNotSupportedException {
        throw new Error("Unresolved compilation problem: \n\tThe type ThresholdedCombinedChIPper must implement the inherited abstract method AbstractSingleMotifChIPper.getStrandProfileOfScoresFor(Sequence, boolean)\n");
    }
}

