/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.results.Result;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.io.IOException;
import java.util.Arrays;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class GlobalTALFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private TALgetterDiffSM talFunction;
    private DataSet positives;
    private MatchFinder pst;
    private Objective objective;
    private SafeOutputStream out;
    private boolean thresholdOnBestScore;

    public GlobalTALFitnessFunction(TALgetterDiffSM talFunction, DataSet positives, MatchFinder pst, Objective objective, int npos, boolean thresholdOnBestScore) throws CloneNotSupportedException {
        this.talFunction = talFunction.clone();
        this.positives = positives;
        this.pst = pst;
        this.objective = objective;
        this.out = SafeOutputStream.getSafeOutputStream(null);
        this.thresholdOnBestScore = thresholdOnBestScore;
    }

    @Override
    public void setOutputStream(SafeOutputStream out) {
        this.out = out;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws IOException {
        double minPos;
        SimpleDiscreteSequence rvds = individual.getSequence();
        ReferenceSequenceAnnotation rvdAnn = new ReferenceSequenceAnnotation("seq", rvds, new Result[0]);
        double[] posScores = new double[this.positives.getNumberOfElements()];
        double bgScore = Math.log(0.25) * (double)(rvds.getLength() + 1);
        int i = 0;
        while (i < this.positives.getNumberOfElements()) {
            Sequence seq = this.positives.getElementAt(i);
            posScores[i] = Double.NEGATIVE_INFINITY;
            int bestPos = -1;
            int j = 0;
            while (j < seq.getLength() - rvds.getLength()) {
                SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{rvdAnn};
                double temp = this.talFunction.getLogScoreFor(seq.getSubSequence(j, rvds.getLength() + 1).annotate(false, sequenceAnnotationArray));
                if (temp > posScores[i]) {
                    posScores[i] = temp;
                    bestPos = j;
                }
                ++j;
            }
            this.out.writeln(String.valueOf(i) + ":");
            this.out.writeln(rvds);
            this.out.writeln(String.valueOf(Arrays.toString(seq.getAnnotation())) + " " + (bestPos - seq.getLength()) + ": " + seq.getSubSequence(bestPos, rvds.getLength() + 1));
            ++i;
        }
        double t = minPos = ToolBox.min(posScores);
        if (this.thresholdOnBestScore) {
            t = this.talFunction.getBestPossibleScore(rvds, null);
        }
        LimitedSortedList<MatchFinder.Match> negScores = this.pst.getScoresAbove(rvds, t - (double)(rvds.getLength() + 1) * Math.log(2.0), 10000, true, false);
        if (this.objective == Objective.MAXMARGIN) {
            double fitness;
            double maxNeg = minPos - (double)(rvds.getLength() + 1) * Math.log(2.0);
            if (negScores.getLength() > 0) {
                maxNeg = negScores.getBestScore();
            }
            fitness = (fitness = minPos - maxNeg) < 0.0 ? Math.exp(fitness) : (fitness += 1.0);
            this.out.writeln(String.valueOf(minPos) + " " + maxNeg + " " + fitness);
            return fitness;
        }
        double temp = 0.0;
        int i2 = 0;
        while (i2 < posScores.length) {
            temp += -Math.log1p(Normalisation.getLogSum(0.0, -(posScores[i2] - bgScore)));
            ++i2;
        }
        ComparableElement<MatchFinder.Match, Double>[] matches = negScores.getSortedList();
        int i3 = 0;
        while (i3 < matches.length) {
            temp += -Math.log1p(Normalisation.getLogSum(0.0, matches[i3].getWeight() - bgScore));
            ++i3;
        }
        temp /= (double)(posScores.length + matches.length);
        temp = Math.exp(temp);
        this.out.writeln(temp);
        return temp;
    }

    @Override
    public void reset() {
        this.pst.reset();
    }

    public static enum Objective {
        MAXMARGIN,
        CL;

    }
}

