/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import javax.naming.OperationNotSupportedException;
import projects.talGA.InfixMatchFinder;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class InfixTALENTargetFinder
implements Cloneable {
    private InfixMatchFinder finder;
    private DataSet ds;
    private TALgetterDiffSM model;

    public InfixTALENTargetFinder(DataSet ds, TALgetterDiffSM model, int maxLength) {
        this.finder = new InfixMatchFinder(ds, maxLength, model);
        this.ds = ds;
        this.model = model;
    }

    public InfixTALENTargetFinder(DataSet ds, TALgetterDiffSM model, InfixMatchFinder finder) {
        this.finder = finder;
        this.ds = ds;
        this.model = model;
    }

    public InfixTALENTargetFinder clone() throws CloneNotSupportedException {
        InfixTALENTargetFinder clone = (InfixTALENTargetFinder)super.clone();
        clone.model = this.model.clone();
        clone.finder = this.finder.clone();
        return clone;
    }

    public void setDataSet(DataSet ds) {
        this.ds = ds;
        this.finder.setDataSet(ds);
    }

    public LimitedSortedList<TALENMatch> getTALENMatches(Sequence tal1, Sequence tal2, double totalThresh, double singleThresh1, double singleThresh2, int minDist, int maxDist, int limit, boolean relativeScores) throws OperationNotSupportedException {
        LimitedSortedList<TALENMatch> list = new LimitedSortedList<TALENMatch>(limit);
        this.fillMatches(tal1, tal2, totalThresh, singleThresh1, singleThresh2, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal2, tal1, totalThresh, singleThresh2, singleThresh1, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal1, tal1, totalThresh, singleThresh1, singleThresh1, minDist, maxDist, list, relativeScores);
        this.fillMatches(tal2, tal2, totalThresh, singleThresh2, singleThresh2, minDist, maxDist, list, relativeScores);
        return list;
    }

    private void fillMatches(Sequence tal1, Sequence tal2, double totalThresh, double singleThresh1, double singleThresh2, int minDist, int maxDist, LimitedSortedList<TALENMatch> list, boolean relativeScores) throws OperationNotSupportedException {
        ComparableElement<MatchFinder.Match, Double>[] list1Fwd = this.finder.getScoresAbove(tal1, singleThresh1 * (double)(relativeScores ? tal1.getLength() + 1 : 1), -100000, true, false).getSortedList();
        Object[] prep = this.finder.getPreps(tal2, singleThresh2 * (double)(relativeScores ? tal2.getLength() + 1 : 1));
        LimitedSortedList<MatchFinder.Match> list2 = new LimitedSortedList<MatchFinder.Match>(maxDist - minDist + tal2.getLength() + 2);
        boolean[] bools = (boolean[])prep[1];
        double[] scores = (double[])prep[0];
        boolean[] bools2 = (boolean[])prep[3];
        double[] scores2 = (double[])prep[2];
        double rest = (Double)prep[4];
        int i = 0;
        while (i < list1Fwd.length) {
            MatchFinder.Match curr = list1Fwd[i].getElement();
            double currScore = list1Fwd[i].getWeight();
            int seq = curr.getSeqIdx();
            int pos = curr.getSeqPos();
            Sequence seq2 = this.ds.getElementAt(seq);
            if (pos + tal1.getLength() + 1 + minDist + tal2.getLength() + 1 < seq2.getLength()) {
                int length = maxDist - minDist + tal2.getLength() + 1;
                if (length > seq2.getLength() - pos - tal1.getLength() - minDist - 1) {
                    length = seq2.getLength() - pos - tal1.getLength() - minDist - 1;
                }
                Sequence rc = seq2.reverseComplement();
                int tl = tal2.getLength();
                list2.clear();
                this.finder.fillMatches(rc, seq, tal2, bools, bools2, scores, scores2, rest, singleThresh2 * (double)(relativeScores ? tal2.getLength() + 1 : 1), true, list2, seq2.getLength() - (pos + tal1.getLength() + 1 + minDist) - length, length - tl + (seq2.getLength() - (pos + tal1.getLength() + 1 + minDist) - length + 1));
                int j = 0;
                while (j < list2.getLength()) {
                    ComparableElement<MatchFinder.Match, Double> m = list2.getElementAt(j);
                    double score2 = m.getWeight();
                    int n = relativeScores ? tal2.getLength() + 1 : 1;
                    if (score2 / (double)n > singleThresh2) {
                        double d = currScore / (double)(relativeScores ? tal1.getLength() + 1 : 1);
                        int n2 = relativeScores ? tal2.getLength() + 1 : 1;
                        if (d + score2 / (double)n2 > totalThresh) {
                            list.insert(currScore / (double)(relativeScores ? tal1.getLength() + 1 : 1) + score2 / (double)(relativeScores ? tal2.getLength() + 1 : 1), new TALENMatch(tal1, tal2, curr, m.getElement()));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void reset() {
        this.finder.reset();
    }

    public static class TALENMatch {
        private Sequence tal1;
        private Sequence tal2;
        private MatchFinder.Match match1;
        private MatchFinder.Match match2;

        public TALENMatch(Sequence tal1, Sequence tal2, MatchFinder.Match match1, MatchFinder.Match match2) {
            this.tal1 = tal1;
            this.tal2 = tal2;
            this.match1 = match1;
            this.match2 = match2;
        }

        public Sequence getTal1() {
            return this.tal1;
        }

        public Sequence getTal2() {
            return this.tal2;
        }

        public MatchFinder.Match getMatch1() {
            return this.match1;
        }

        public MatchFinder.Match getMatch2() {
            return this.match2;
        }

        public String toString() {
            return this.match1 + " " + this.match2;
        }
    }
}

