/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.utils.SafeOutputStream;
import java.io.IOException;

public class RVDDistanceFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private int[] positives;
    private int maxDist;
    private SafeOutputStream out;

    public RVDDistanceFitnessFunction(int[] positives, int maxDist) {
        this.positives = (int[])positives.clone();
        this.maxDist = maxDist;
        this.out = SafeOutputStream.getSafeOutputStream(null);
    }

    @Override
    public void setOutputStream(SafeOutputStream out) {
        this.out = out;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws IOException {
        double fitness = 0.0;
        int last = -1;
        int i = 0;
        block0: while (i < individual.getDimension()) {
            int j = 0;
            while (j < this.positives.length) {
                if (this.positives[j] == individual.getValueAt(i)) {
                    int dist = i - last;
                    if (dist <= this.maxDist) {
                        this.out.writeln("dist: " + dist);
                        fitness += (double)(this.maxDist - dist);
                    } else {
                        fitness = 0.1;
                        break block0;
                    }
                    last = i;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return fitness / (double)((this.maxDist - 1) * individual.getDimension());
    }

    @Override
    public void reset() {
    }
}

