/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.Individual;

public class TALENIndividual
extends DiscreteSequenceIndividual {
    private boolean homo;
    private DiscreteSequenceIndividual first;
    private DiscreteSequenceIndividual second;

    public TALENIndividual(SimpleDiscreteSequence sequence, boolean homo) {
        super(sequence);
        this.homo = homo;
        if (homo) {
            this.first = this;
            this.second = this;
        } else {
            int[] firstPart = new int[sequence.getLength() / 2];
            int i = 0;
            while (i < firstPart.length) {
                firstPart[i] = sequence.discreteVal(i);
                ++i;
            }
            int[] secondPart = new int[sequence.getLength() / 2];
            int j = 0;
            while (j < secondPart.length) {
                secondPart[j] = sequence.discreteVal(i + j);
                ++j;
            }
            try {
                this.first = new DiscreteSequenceIndividual(new IntSequence(sequence.getAlphabetContainer(), firstPart));
                this.second = new DiscreteSequenceIndividual(new IntSequence(sequence.getAlphabetContainer(), secondPart));
            }
            catch (Exception doesnothappen) {
                throw new RuntimeException();
            }
        }
    }

    public int getTALENDimension() {
        if (this.homo) {
            return this.getDimension() * 2;
        }
        return this.getDimension();
    }

    public int getSingleDimension() {
        if (this.homo) {
            return this.getDimension();
        }
        return this.getDimension() / 2;
    }

    public boolean isHomoDimer() {
        return this.homo;
    }

    public DiscreteSequenceIndividual getFirstPart() {
        return this.first;
    }

    public DiscreteSequenceIndividual getSecondPart() {
        return this.second;
    }

    @Override
    public Individual mutate(int dimension, int value) throws WrongAlphabetException, WrongSequenceTypeException {
        if (!this.sequence.getAlphabetContainer().isEncodedSymbol(dimension, value)) {
            throw new RuntimeException();
        }
        int[] original = new int[this.sequence.getLength()];
        int i = 0;
        while (i < original.length) {
            original[i] = i == dimension ? value : this.sequence.discreteVal(i);
            ++i;
        }
        IntSequence seq = new IntSequence(this.sequence.getAlphabetContainer(), original);
        return new TALENIndividual(seq, this.homo);
    }

    @Override
    public Individual crossover(int crossdim, Individual second) throws WrongAlphabetException, WrongSequenceTypeException {
        if (this.sequence.getLength() == second.getDimension() && (this.sequence.getAlphabetContainer() == second.getEncoding() || this.sequence.getAlphabetContainer().checkConsistency(second.getEncoding()))) {
            int[] original = new int[this.sequence.getLength()];
            int i = 0;
            while (i < original.length) {
                original[i] = i > crossdim ? second.getValueAt(i) : this.sequence.discreteVal(i);
                ++i;
            }
            IntSequence seq = new IntSequence(this.sequence.getAlphabetContainer(), original);
            return new TALENIndividual(seq, this.homo);
        }
        throw new RuntimeException();
    }
}

