/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.results.Result;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.io.IOException;
import java.util.Arrays;
import projects.tals.TALgetterDiffSM;

public class TALFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private TALgetterDiffSM talFunction;
    private DataSet positives;
    private DataSet negatives;
    private Objective objective;
    private SafeOutputStream out;
    private int npos;

    public TALFitnessFunction(TALgetterDiffSM talFunction, DataSet positives, DataSet negatives, Objective objective, int npos) throws CloneNotSupportedException {
        this.talFunction = talFunction.clone();
        this.positives = positives;
        this.negatives = negatives;
        this.objective = objective;
        this.out = SafeOutputStream.getSafeOutputStream(null);
        this.npos = npos;
    }

    @Override
    public void setOutputStream(SafeOutputStream out) {
        this.out = out;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws IOException {
        double temp;
        int j;
        Sequence rvds = individual.getSequence();
        if (this.npos < rvds.getLength()) {
            rvds = rvds.getSubSequence(0, this.npos);
        }
        ReferenceSequenceAnnotation rvdAnn = new ReferenceSequenceAnnotation("seq", rvds, new Result[0]);
        double[] posScores = new double[this.positives.getNumberOfElements()];
        double[] negScores = new double[this.negatives.getNumberOfElements()];
        double bgScore = Math.log(0.25) * (double)(rvds.getLength() + 1);
        int i = 0;
        while (i < this.positives.getNumberOfElements()) {
            Sequence seq = this.positives.getElementAt(i);
            posScores[i] = Double.NEGATIVE_INFINITY;
            int bestPos = -1;
            j = 0;
            while (j < seq.getLength() - rvds.getLength()) {
                SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{rvdAnn};
                temp = this.talFunction.getLogScoreFor(seq.getSubSequence(j, rvds.getLength() + 1).annotate(false, sequenceAnnotationArray)) - bgScore;
                if (temp > posScores[i]) {
                    posScores[i] = temp;
                    bestPos = j;
                }
                ++j;
            }
            this.out.writeln(String.valueOf(i) + ":");
            this.out.writeln(rvds);
            this.out.writeln(String.valueOf(Arrays.toString(seq.getAnnotation())) + " " + (bestPos - seq.getLength()) + ": " + seq.getSubSequence(bestPos, rvds.getLength() + 1));
            ++i;
        }
        int[] bestPos = new int[this.negatives.getNumberOfElements()];
        int i2 = 0;
        while (i2 < this.negatives.getNumberOfElements()) {
            Sequence seq = this.negatives.getElementAt(i2);
            negScores[i2] = Double.NEGATIVE_INFINITY;
            j = 0;
            while (j < seq.getLength() - rvds.getLength()) {
                SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{rvdAnn};
                temp = this.talFunction.getLogScoreFor(seq.getSubSequence(j, rvds.getLength() + 1).annotate(false, sequenceAnnotationArray)) - bgScore;
                if (temp > negScores[i2]) {
                    negScores[i2] = temp;
                    bestPos[i2] = j;
                }
                ++j;
            }
            ++i2;
        }
        int bestNegSeq = ToolBox.getMaxIndex(negScores);
        this.out.writeln(String.valueOf(Arrays.toString(this.negatives.getElementAt(bestNegSeq).getAnnotation())) + " " + (bestPos[bestNegSeq] - this.negatives.getElementAt(bestNegSeq).getLength()) + ": " + this.negatives.getElementAt(bestNegSeq).getSubSequence(bestPos[bestNegSeq], rvds.getLength() + 1));
        if (this.objective == Objective.MAXMARGIN) {
            double maxNeg;
            double minPos = ToolBox.min(posScores);
            double fitness = minPos - (maxNeg = ToolBox.max(negScores));
            fitness = fitness < 0.0 ? Math.exp(fitness) : (fitness += 1.0);
            this.out.writeln(String.valueOf(minPos) + " " + maxNeg + " " + fitness);
            return fitness;
        }
        double temp2 = 0.0;
        int i3 = 0;
        while (i3 < posScores.length) {
            temp2 += -Math.log1p(Normalisation.getLogSum(0.0, -posScores[i3]));
            ++i3;
        }
        i3 = 0;
        while (i3 < negScores.length) {
            temp2 += -Math.log1p(Normalisation.getLogSum(0.0, negScores[i3]));
            ++i3;
        }
        temp2 /= (double)(posScores.length + negScores.length);
        temp2 = Math.exp(temp2);
        this.out.writeln(temp2);
        return temp2;
    }

    @Override
    public void reset() {
    }

    public static enum Objective {
        MAXMARGIN,
        CL;

    }
}

