/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScanForTBS {
    public static void main(String[] args) throws Exception {
        AbstractDifferentiableStatisticalModel model = (AbstractDifferentiableStatisticalModel)XMLParser.extractObjectForTags(FileManager.readFile(args[0]), "model");
        DNADataSet ds = new DNADataSet(args[1], '>', new SimpleSequenceAnnotationParser());
        int start = Integer.parseInt(args[2]);
        int length = Integer.parseInt(args[3]);
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence tal = Sequence.create(alphabetsRVD, args[4], "-");
        PrintWriter out = new PrintWriter(args[5]);
        Pattern tata = Pattern.compile("TATA[AT]A", 2);
        out.println("ID\tposition\tscore\ttata");
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i);
            if (seq.getLength() >= start + length) {
                double max = Double.NEGATIVE_INFINITY;
                int maxIdx = -1;
                int j = start;
                while (j < start + length - tal.getLength()) {
                    Sequence sub = seq.getSubSequence(j, tal.getLength());
                    sub = sub.annotate(true, seq.getAnnotation());
                    SequenceAnnotation[] sequenceAnnotationArray = new SequenceAnnotation[]{new ReferenceSequenceAnnotation("seq", tal, new Result[0])};
                    double score = model.getLogScoreFor(sub = sub.annotate(true, sequenceAnnotationArray));
                    if (score > max) {
                        max = score;
                        maxIdx = j;
                    }
                    ++j;
                }
                Matcher match = tata.matcher(seq.toString());
                int off = maxIdx;
                double tataPos = Double.NaN;
                if (match.find(off)) {
                    tataPos = match.start() - off;
                }
                String id = (String)seq.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                id = id.substring(0, id.indexOf(32));
                out.println(String.valueOf(id) + "\t" + (maxIdx - 500) + "\t" + max + "\t" + (Double.isNaN(tataPos) ? "NA" : Double.valueOf(tataPos)));
            }
            ++i;
        }
        out.close();
    }
}

