/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.DifferentiableStatisticalModelWrapperTrainSM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import projects.tals.TALFinder_NSF;

public class TALMain {
    public static void main(String[] args) throws Exception {
        String line;
        String file = "targetsSF.fasta";
        DNAAlphabetContainer alphabets = DNAAlphabetContainer.SINGLETON;
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        double[] priorImp = new double[]{0.3, 0.3, 0.9, 0.7, 0.3, 0.5, 0.3, 0.5, 0.5, 0.5, 0.7, 0.9, 0.5, 0.5, 0.5, 0.5, 0.5, 0.7, 0.5, 0.3, 0.5, 0.5, 0.5, 0.7, 0.7, 0.3};
        double[][] priorPrefs = new double[][]{{0.7, 0.1, 0.1, 0.1}, {0.1, 0.1, 0.1, 0.7}, {0.3, 0.1, 0.5, 0.1}, {0.35, 0.2, 0.35, 0.1}, {0.1, 0.1, 0.1, 0.7}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.7, 0.1}, {0.25, 0.25, 0.25, 0.25}, {0.25, 0.25, 0.25, 0.25}, {0.1, 0.1, 0.7, 0.1}, {0.1, 0.1, 0.7, 0.1}, {0.1, 0.7, 0.1, 0.1}, {0.1, 0.1, 0.1, 0.7}, {0.2, 0.5, 0.2, 0.1}, {0.1, 0.1, 0.1, 0.7}, {0.25, 0.25, 0.25, 0.25}, {0.1, 0.7, 0.1, 0.1}, {0.3, 0.1, 0.5, 0.1}, {0.25, 0.25, 0.25, 0.25}, {0.1, 0.1, 0.7, 0.1}, {0.25, 0.25, 0.25, 0.25}, {0.1, 0.1, 0.1, 0.7}, {0.25, 0.25, 0.25, 0.25}, {0.2, 0.2, 0.1, 0.5}, {0.3, 0.1, 0.5, 0.1}, {0.25, 0.25, 0.25, 0.25}};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        ReferenceSequenceAnnotationParser annoParser = new ReferenceSequenceAnnotationParser("seq", alphabetsRVD, ":", ";", "-");
        DNADataSet data_Train_fg = new DNADataSet(file, '>', annoParser);
        int length = 0;
        int Ess = 8;
        double[] priorFP = new double[]{0.1, 0.2, 0.1, 0.6};
        int order_talU = 0;
        File file_gewichte = new File("targetsGewichte.txt");
        BufferedReader in = new BufferedReader(new FileReader(file_gewichte));
        double[] Gewichte_Daten = new double[data_Train_fg.getNumberOfElements()];
        int z = 0;
        while ((line = in.readLine()) != null) {
            Gewichte_Daten[z] = Double.parseDouble(line);
            ++z;
        }
        if (z < data_Train_fg.getNumberOfElements()) {
            throw new Exception("Es gibt weniger Gewichte als Sequenzen.");
        }
        if (z < data_Train_fg.getNumberOfElements()) {
            throw new Exception("Es gibt mehr Gewichte als Sequenzen.");
        }
        int p_anz = 0;
        boolean p_gesamte_seq = false;
        TALFinder_NSF Model_Tal_Finder_NSF = new TALFinder_NSF(alphabets, alphabetsRVD, length, data_Train_fg.getAverageElementLength(), Ess, order_talU, p_anz, p_gesamte_seq, priorFP, priorImp, priorPrefs);
        DifferentiableStatisticalModelWrapperTrainSM model = new DifferentiableStatisticalModelWrapperTrainSM(Model_Tal_Finder_NSF, 1, 20, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-12), 1.0E-12, 1.0E-4);
        model.train(data_Train_fg, Gewichte_Daten);
        Model_Tal_Finder_NSF = (TALFinder_NSF)model.getFunction();
        Model_Tal_Finder_NSF.setIndependentToStationary();
        StringBuffer sb = new StringBuffer();
        XMLParser.appendObjectWithTags(sb, Model_Tal_Finder_NSF, "model");
        FileManager.writeFile(new File("/Users/dev/Desktop/TAL-Chips/GA/talfinder_obg" + order_talU + "_hyp.xml"), (CharSequence)sb);
        System.out.println(Model_Tal_Finder_NSF);
    }
}

