/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.NonParsableException;
import java.text.NumberFormat;
import java.util.HashSet;
import projects.tals.TALgetterRVDDependentComponent;

public class TAL_A_NSFMap
extends TALgetterRVDDependentComponent {
    private int[] map;

    public TAL_A_NSFMap(AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, int length, double ess, double[] priorImp, double[][] priorPrefs) throws Exception {
        super(alphabets, alphabetsRVD, length, ess, priorImp, priorPrefs);
    }

    @Override
    public TAL_A_NSFMap clone() throws CloneNotSupportedException {
        TAL_A_NSFMap clone = (TAL_A_NSFMap)super.clone();
        if (this.map != null) {
            clone.map = (int[])this.map.clone();
        }
        return clone;
    }

    private static int[] buildMap(AlphabetContainer con) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while ((double)i < con.getAlphabetLengthAt(0)) {
            String sym = con.getSymbol(0, i).toUpperCase();
            String last = sym.substring(1);
            set.add(last);
            ++i;
        }
        try {
            DiscreteAlphabet da = new DiscreteAlphabet(true, set.toArray(new String[0]));
            int[] map = new int[(int)con.getAlphabetLengthAt(0)];
            int i2 = 0;
            while ((double)i2 < con.getAlphabetLengthAt(0)) {
                String sym = con.getSymbol(0, i2).toUpperCase();
                String last = sym.substring(1);
                map[i2] = da.getCode(last);
                ++i2;
            }
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected int getNumberOfSymbols(AlphabetContainer con) {
        if (this.map == null) {
            this.map = TAL_A_NSFMap.buildMap(con);
        }
        int max = -1;
        int i = 0;
        while (i < this.map.length) {
            if (this.map[i] > max) {
                max = this.map[i];
            }
            ++i;
        }
        return max + 1;
    }

    @Override
    protected int getMappedIndex(AlphabetContainer con, int original) {
        if (this.map == null) {
            this.map = TAL_A_NSFMap.buildMap(con);
        }
        return this.map[original];
    }

    public TAL_A_NSFMap(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((double)i < this.alphabetsRVD.getAlphabetLengthAt(0)) {
            sb.append(String.valueOf(this.alphabetsRVD.getSymbol(0, i)) + "\t");
            sb.append(this.hmm_c[this.getMappedIndex(this.alphabetsRVD, i)] + "\n");
            ++i;
        }
        return sb.toString();
    }
}

