/*
 * Decompiled with CFR 0.152.
 */
package seqTools.positions;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.random.RandomNumberGenerator;
import seqTools.positions.DensityPositionDistribution;

public class CenterMeanGaussianPositionDistribution
extends DensityPositionDistribution {
    private double eprc;
    private double lprc;
    private double alpha;
    private double beta;
    private Double initPrc;

    public CenterMeanGaussianPositionDistribution(int maximumExpectedLength, double alpha, double beta) {
        super(maximumExpectedLength);
        this.alpha = alpha;
        this.beta = beta;
    }

    public CenterMeanGaussianPositionDistribution(int maximumExpectedLength, double alpha, double beta, double initPrc) {
        super(maximumExpectedLength);
        this.alpha = alpha;
        this.beta = beta;
        this.initPrc = initPrc;
    }

    @Override
    public CenterMeanGaussianPositionDistribution clone() throws CloneNotSupportedException {
        return (CenterMeanGaussianPositionDistribution)super.clone();
    }

    @Override
    protected double getLogDensity(int length, int position, int motifWidth) {
        return -0.5 * this.eprc * ((double)position - (double)(length + motifWidth) / 2.0) * ((double)position - (double)(length + motifWidth) / 2.0);
    }

    @Override
    protected double[] getLogDensityAndPartialDerivation(int length, int position, int motifWidth) {
        double temp = -0.5 * ((double)position - (double)(length + motifWidth) / 2.0) * ((double)position - (double)(length + motifWidth) / 2.0) * this.eprc;
        return new double[]{temp, temp};
    }

    @Override
    public double[] getCurrentParameters() {
        return new double[]{this.lprc};
    }

    @Override
    public void setParameters(double[] pars, int offset) {
        this.lprc = pars[offset];
        this.eprc = Math.exp(this.lprc);
        this.reset();
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public double getLogPriorTerm() {
        return this.alpha * this.lprc - this.beta * this.eprc;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] gradient, int off) {
        int n = off;
        gradient[n] = gradient[n] + (this.alpha - this.beta * this.eprc);
    }

    @Override
    public void initializeRandomly() {
        if (this.initPrc != null) {
            this.eprc = this.initPrc;
            this.lprc = Math.log(this.initPrc);
        } else {
            RandomNumberGenerator r = new RandomNumberGenerator();
            this.lprc = r.nextGammaLog(this.alpha, this.beta);
            this.eprc = Math.exp(this.lprc);
        }
    }

    public String toString() {
        return "Gauss(center, " + this.eprc + ")";
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.alpha = XMLParser.extractObjectForTags(xml, "alpha", Double.TYPE);
        this.beta = XMLParser.extractObjectForTags(xml, "beta", Double.TYPE);
        this.lprc = XMLParser.extractObjectForTags(xml, "lprc", Double.TYPE);
        this.eprc = Math.exp(this.lprc);
        this.initPrc = (Double)XMLParser.extractObjectForTags(xml, "initPrc");
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        XMLParser.appendObjectWithTags(xml, this.alpha, "alpha");
        XMLParser.appendObjectWithTags(xml, this.beta, "beta");
        XMLParser.appendObjectWithTags(xml, this.lprc, "lprc");
        XMLParser.appendObjectWithTags(xml, this.initPrc, "initPrc");
    }

    @Override
    protected String getTag() {
        return null;
    }
}

