/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import java.util.NoSuchElementException;
import umontreal.iro.lecuyer.hups.PointSetIterator;
import umontreal.iro.lecuyer.hups.PointSetRandomization;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.util.Num;
import umontreal.iro.lecuyer.util.PrintfFormat;

public abstract class PointSet {
    protected static final int MAXBITS = 31;
    protected int dim = 0;
    protected int numPoints = 0;
    protected int dimShift = 0;
    protected int capacityShift = 0;
    protected RandomStream shiftStream;

    public int getDimension() {
        return this.dim;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public abstract double getCoordinate(int var1, int var2);

    public PointSetIterator iterator() {
        return new DefaultPointSetIterator();
    }

    public void setStream(RandomStream stream) {
        this.shiftStream = stream;
    }

    public RandomStream getStream() {
        return this.shiftStream;
    }

    public void randomize(PointSetRandomization rand) {
        rand.randomize(this);
    }

    public void addRandomShift(int d1, int d2, RandomStream stream) {
        System.out.println("******* WARNING:  addRandomShift in PointSet does nothing");
    }

    public void addRandomShift(RandomStream stream) {
        this.addRandomShift(0, this.dimShift, stream);
    }

    @Deprecated
    public void addRandomShift(int d1, int d2) {
        this.addRandomShift(d1, d2, this.shiftStream);
    }

    @Deprecated
    public void addRandomShift() {
        this.addRandomShift(0, this.dimShift, this.shiftStream);
    }

    public void clearRandomShift() {
        this.capacityShift = 0;
        this.dimShift = 0;
    }

    public void randomize(int d1, int d2, RandomStream stream) {
        this.addRandomShift(d1, d2, stream);
    }

    public void randomize(RandomStream stream) {
        this.addRandomShift(stream);
    }

    @Deprecated
    public void randomize(int d1, int d2) {
        this.addRandomShift(d1, d2);
    }

    @Deprecated
    public void randomize() {
        this.addRandomShift();
    }

    public void unrandomize() {
        this.clearRandomShift();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Number of points: ");
        int x = this.getNumPoints();
        if (x == Integer.MAX_VALUE) {
            sb.append("infinite");
        } else {
            sb.append(x);
        }
        sb.append(PrintfFormat.LINE_SEPARATOR + "Point set dimension: ");
        x = this.getDimension();
        if (x == Integer.MAX_VALUE) {
            sb.append("infinite");
        } else {
            sb.append(x);
        }
        return sb.toString();
    }

    public String formatPoints() {
        int n = this.getNumPoints();
        if (n == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Number of points is infinite");
        }
        int d = this.getDimension();
        if (d == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Dimension is infinite");
        }
        return this.formatPoints(n, d);
    }

    public String formatPoints(int n, int d) {
        if (this.getNumPoints() < n) {
            throw new UnsupportedOperationException("n > number of points");
        }
        if (this.getDimension() < d) {
            throw new UnsupportedOperationException("d > dimension");
        }
        StringBuffer sb = new StringBuffer(this.toString());
        PointSetIterator itr = this.iterator();
        sb.append(PrintfFormat.LINE_SEPARATOR + PrintfFormat.LINE_SEPARATOR + "Points of the point set:");
        for (int i = 0; i < n; ++i) {
            sb.append(PrintfFormat.LINE_SEPARATOR + "Point " + itr.getCurPointIndex() + "=(");
            boolean first = true;
            for (int j = 0; j < d; ++j) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(itr.nextCoordinate());
            }
            sb.append(")");
            itr.resetToNextPoint();
        }
        return sb.toString();
    }

    protected class DefaultPointSetIterator
    implements PointSetIterator {
        protected int curPointIndex = 0;
        protected int curCoordIndex = 0;
        protected double EpsilonHalf = 1.0 / Num.TWOEXP[54];

        protected DefaultPointSetIterator() {
        }

        protected void outOfBounds() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints) {
                throw new NoSuchElementException("Not enough points available");
            }
            throw new NoSuchElementException("Not enough coordinates available");
        }

        public void setCurCoordIndex(int j) {
            this.curCoordIndex = j;
        }

        public void resetCurCoordIndex() {
            this.setCurCoordIndex(0);
        }

        public int getCurCoordIndex() {
            return this.curCoordIndex;
        }

        public boolean hasNextCoordinate() {
            return this.getCurCoordIndex() < PointSet.this.getDimension();
        }

        public double nextCoordinate() {
            if (this.getCurPointIndex() >= PointSet.this.numPoints || this.getCurCoordIndex() >= PointSet.this.dim) {
                this.outOfBounds();
            }
            return PointSet.this.getCoordinate(this.curPointIndex, this.curCoordIndex++);
        }

        public void nextCoordinates(double[] p, int d) {
            if (this.getCurCoordIndex() + d > PointSet.this.getDimension()) {
                this.outOfBounds();
            }
            for (int j = 0; j < d; ++j) {
                p[j] = this.nextCoordinate();
            }
        }

        public void setCurPointIndex(int i) {
            this.curPointIndex = i;
            this.resetCurCoordIndex();
        }

        public void resetCurPointIndex() {
            this.setCurPointIndex(0);
        }

        public int resetToNextPoint() {
            this.setCurPointIndex(this.curPointIndex + 1);
            return this.curPointIndex;
        }

        public int getCurPointIndex() {
            return this.curPointIndex;
        }

        public boolean hasNextPoint() {
            return this.getCurPointIndex() < PointSet.this.getNumPoints();
        }

        public int nextPoint(double[] p, int d) {
            this.resetCurCoordIndex();
            this.nextCoordinates(p, d);
            return this.resetToNextPoint();
        }

        public void resetStartStream() {
            this.resetCurPointIndex();
        }

        public void resetStartSubstream() {
            this.resetCurCoordIndex();
        }

        public void resetNextSubstream() {
            this.resetToNextPoint();
        }

        public void setAntithetic(boolean b) {
            throw new UnsupportedOperationException();
        }

        public double nextDouble() {
            return this.nextCoordinate();
        }

        public void nextArrayOfDouble(double[] u, int start, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int i = start; i < start + n; ++i) {
                u[i] = this.nextDouble();
            }
        }

        public int nextInt(int i, int j) {
            return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
        }

        public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
            if (n < 0) {
                throw new IllegalArgumentException("n must be positive.");
            }
            for (int k = start; k < start + n; ++k) {
                u[k] = this.nextInt(i, j);
            }
        }

        public String formatState() {
            return "Current point index: " + this.getCurPointIndex() + PrintfFormat.LINE_SEPARATOR + "Current coordinate index: " + this.getCurCoordIndex();
        }
    }
}

