/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class WELL1024
extends RandomStreamBase {
    private static final long serialVersionUID = 70510L;
    private static final double NORM = 2.3283064365386963E-10;
    private static final int MASK = 31;
    private static final int W = 32;
    private static final int R = 32;
    private static final int P = 0;
    private static final int M1 = 3;
    private static final int M2 = 24;
    private static final int M3 = 10;
    private static final int A1 = -612762831;
    private static final int B1 = 265986753;
    private static final int B2 = 667264397;
    private static final int C1 = 1911133182;
    private int state_i = 0;
    private int[] state;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream;
    private static BitMatrix Apw;
    private static BitMatrix Apz;
    private static boolean initialised;
    private static final int[] pw;
    private static final int[] pz;

    private static void initialisation() {
        curr_stream = new int[]{-566162571, -1873828409, -1949011938, 18785121, 1857128928, 2049641697, -534367798, 1928044850, 1367988751, 1052191276, 1370219795, 1839113596, 1298729969, -2078179382, 1922096666, 1117739592, 1858350835, -1777683691, 1925424963, 1222720497, -1994921272, 675995686, 897315392, -1858383444, 325775765, 907721752, 1931130661, 1674815433, -437048808, -1851203228, 82469301, -953524079};
        try {
            InputStream is = WELL1024.class.getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/rng/WELL1024.dat");
            if (is == null) {
                throw new FileNotFoundException("Couldn't find WELRNG1024.dat");
            }
            ObjectInputStream ois = new ObjectInputStream(is);
            Apw = (BitMatrix)ois.readObject();
            Apz = (BitMatrix)ois.readObject();
            ois.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        initialised = true;
    }

    private void advanceSeed(int[] seed, int[] p) {
        int i;
        int[] x = new int[32];
        for (i = 0; i < 32; ++i) {
            this.state[i] = seed[i];
        }
        this.state_i = 0;
        for (int j = 0; j < 32; ++j) {
            int b = p[j];
            for (int k = 0; k < 32; ++k) {
                if ((b & 1) == 1) {
                    for (int i2 = 0; i2 < 32; ++i2) {
                        int n = i2;
                        x[n] = x[n] ^ this.state[this.state_i + i2 & 0x1F];
                    }
                }
                b >>= 1;
                this.nextValue();
            }
        }
        for (i = 0; i < 32; ++i) {
            seed[i] = x[i];
        }
    }

    private static void verifySeed(int[] seed) {
        if (seed.length != 32) {
            throw new IllegalArgumentException("Seed must contain 32values");
        }
        for (int i = 0; i < 32; ++i) {
            if (seed[i] == 0) continue;
            return;
        }
        throw new IllegalArgumentException("At least one of the element of the seed must not be 0.");
    }

    private WELL1024(int i) {
        this.state = new int[32];
        for (int j = 0; j < 32; ++j) {
            this.state[j] = 0;
        }
        this.state[i / 32] = 1 << i % 32;
        this.state_i = 0;
    }

    public WELL1024() {
        if (!initialised) {
            WELL1024.initialisation();
        }
        this.state = new int[32];
        this.stream = new int[32];
        this.substream = new int[32];
        for (int i = 0; i < 32; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, pz);
        this.resetStartStream();
    }

    public WELL1024(String name) {
        this();
        this.name = name;
    }

    public static void setPackageSeed(int[] seed) {
        WELL1024.verifySeed(seed);
        for (int i = 0; i < 32; ++i) {
            WELL1024.curr_stream[i] = seed[i];
        }
    }

    public void setSeed(int[] seed) {
        WELL1024.verifySeed(seed);
        for (int i = 0; i < 32; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        int[] result = new int[32];
        for (int i = 0; i < 32; ++i) {
            result[i] = this.state[this.state_i + i & 0x1F];
        }
        return result;
    }

    public void resetStartStream() {
        for (int i = 0; i < 32; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 0;
        for (int i = 0; i < 32; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, pw);
        this.resetStartSubstream();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name == null) {
            sb.append("The state of this WELL1024 is : {");
        } else {
            sb.append("The state of " + this.name + " is : {");
        }
        for (int i = 0; i < 31; ++i) {
            sb.append(this.state[this.state_i + i & 0x1F] + ", ");
        }
        sb.append(this.state[this.state_i + 32 - 1 & 0x1F] + "}");
        return sb.toString();
    }

    protected double nextValue() {
        int z0 = this.state[this.state_i + 31 & 0x1F];
        int z1 = this.state[this.state_i] ^ (this.state[this.state_i + 3 & 0x1F] ^ this.state[this.state_i + 3 & 0x1F] >>> 8);
        int z2 = this.state[this.state_i + 24 & 0x1F] ^ this.state[this.state_i + 24 & 0x1F] << 19 ^ (this.state[this.state_i + 10 & 0x1F] ^ this.state[this.state_i + 10 & 0x1F] << 14);
        this.state[this.state_i] = z1 ^ z2;
        this.state[this.state_i + 31 & 0x1F] = z0 ^ z0 << 11 ^ (z1 ^ z1 << 7) ^ (z2 ^ z2 << 13);
        this.state_i = this.state_i + 31 & 0x1F;
        long result = this.state[this.state_i];
        return (double)(result > 0L ? result : result + 0x100000000L) * 2.3283064365386963E-10;
    }

    public WELL1024 clone() {
        WELL1024 retour = null;
        retour = (WELL1024)super.clone();
        retour.state = new int[32];
        retour.substream = new int[32];
        retour.stream = new int[32];
        for (int i = 0; i < 32; ++i) {
            retour.state[i] = this.state[i];
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        return retour;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the WELL1024 state transition matrices.");
        BitVector[] bv = new BitVector[1024];
        int[] vect = new int[32];
        for (int i = 0; i < 1024; ++i) {
            WELL1024 well = new WELL1024(i);
            well.nextValue();
            for (int j = 0; j < 32; ++j) {
                vect[j] = well.state[well.state_i + j & 0x1F];
            }
            bv[i] = new BitVector(vect, 1024);
        }
        BitMatrix STp0 = new BitMatrix(bv).transpose();
        BitMatrix STpw = STp0.power2e(400);
        BitMatrix STpz = STpw.power2e(300);
        try {
            FileOutputStream fos = new FileOutputStream(args[0]);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(STpw);
            oos.writeObject(STpz);
            oos.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Couldn't create " + args[0]);
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        initialised = false;
        pw = new int[]{239348046, -282886401, 1586195451, -1490753926, 1503218941, 1870413281, 1731581197, 1274943898, 969051745, -49851802, -1764987617, 1572972165, -696277948, -859825274, 150963740, -837732571, 1718646275, 950776061, 124264292, 272971205, -833952268, 1357082885, -792332417, 1958865910, 751768837, -772662394, -1704181714, -365649124, 1709260051, -561041659, -1982103473, -1916565518};
        pz = new int[]{2091613604, -282545547, 419407466, 715398738, 364297606, 1443695990, -840065007, -1776085209, -288970766, -1711461402, -1833981818, -861440016, -1758527688, -1566601655, 582269366, 277465240, 1834392357, -2020588350, 1581364515, 871472598, 2080399301, 2140805383, 968859373, 1272474228, 236865507, -1762994260, -936052242, -637580721, 1904149580, -49408538, 113348339, -1076025022};
    }
}

