/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization;

import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;

public abstract class NumericalDifferentiableFunction
extends DifferentiableFunction {
    protected double eps;

    public NumericalDifferentiableFunction(double epsilon) throws IllegalArgumentException {
        if (epsilon == 0.0) {
            throw new IllegalArgumentException("Epsilon can not be 0.");
        }
        this.eps = epsilon;
    }

    @Override
    public double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        int n = this.getDimensionOfScope();
        if (x == null || x.length != this.getDimensionOfScope()) {
            if (x != null) {
                throw new DimensionException(x.length, n);
            }
            throw new DimensionException(0, n);
        }
        double[] gradient = new double[n];
        double current = this.evaluateFunction(x);
        int i = 0;
        while (i < n) {
            double h = x[i];
            int n2 = i;
            x[n2] = x[n2] + this.eps;
            gradient[i] = (this.evaluateFunction(x) - current) / this.eps;
            x[i] = h;
            ++i;
        }
        return gradient;
    }
}

