/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.DifferentiableStatisticalModelWrapperTrainSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import projects.tals.TALgetterMixture;
import projects.tals.TALgetterRVDDependentComponent;

public class TALgetterDiffSM
extends AbstractDifferentiableStatisticalModel {
    private TALgetterRVDDependentComponent tal_A_NSF;
    private HomogeneousMMDiffSM tal_U_NSF;
    private TALgetterMixture tal_M_NSF;
    private HomogeneousMMDiffSM FirstPosHMM;
    private boolean isInitialized = true;
    private int Ordnung_tal_U;
    private double Ess;
    private boolean isFixed;
    private double[][][][] condProbs;
    private double[] firstPosProbs;
    private int[] firstPosMatches;
    private int[][][][] matches;
    private int[] pows;

    public TALgetterDiffSM(AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, double midLength, double ess, int order_talU, double[] priorFP, double[] priorImp, double[][] priorPrefs) throws Exception {
        super(alphabets, 0);
        this.Ess = ess;
        priorFP = (double[])priorFP.clone();
        int i = 0;
        while (i < priorFP.length) {
            int n = i++;
            priorFP[n] = priorFP[n] * ess;
        }
        double part = 0.0;
        int i2 = 0;
        while (i2 < priorImp.length) {
            part += priorImp[i2];
            ++i2;
        }
        this.FirstPosHMM = new HomogeneousMMDiffSM(alphabets, 0, ess, new double[][]{priorFP}, true, true, 1);
        this.tal_A_NSF = this.getTalANsf(alphabets, alphabetsRVD, (int)midLength, ess, part /= (double)priorImp.length, priorImp, priorPrefs);
        this.tal_U_NSF = new HomogeneousMMDiffSM(alphabets, order_talU, ess * (1.0 - part), (int)midLength);
        this.tal_M_NSF = new TALgetterMixture(alphabetsRVD, (int)midLength, ess, priorImp);
        this.Ordnung_tal_U = order_talU;
        this.pows = new int[order_talU];
        i2 = 0;
        while (i2 < this.pows.length) {
            this.pows[i2] = (int)Math.pow((int)alphabets.getAlphabetLengthAt(0), i2);
            ++i2;
        }
    }

    protected TALgetterRVDDependentComponent getTalANsf(AlphabetContainer alphabets, AlphabetContainer alphabetsRVD, int midLength, double ess, double part, double[] priorImp, double[][] priorPrefs) throws Exception {
        return new TALgetterRVDDependentComponent(alphabets, alphabetsRVD, midLength, ess * part, priorImp, priorPrefs);
    }

    public TALgetterDiffSM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public TALgetterDiffSM clone() throws CloneNotSupportedException {
        TALgetterDiffSM clone = (TALgetterDiffSM)super.clone();
        clone.FirstPosHMM = this.FirstPosHMM.clone();
        clone.tal_A_NSF = this.tal_A_NSF.clone();
        clone.tal_M_NSF = this.tal_M_NSF.clone();
        clone.tal_U_NSF = this.tal_U_NSF.clone();
        clone.pows = (int[])this.pows.clone();
        if (this.isFixed) {
            clone.condProbs = (double[][][][])ArrayHandler.clone((Cloneable[])this.condProbs);
            clone.firstPosMatches = (int[])this.firstPosMatches.clone();
            clone.firstPosProbs = (double[])this.firstPosProbs.clone();
            clone.matches = (int[][][][])ArrayHandler.clone((Cloneable[])this.matches);
        }
        return clone;
    }

    public AlphabetContainer getRVDAlphabet() {
        return this.tal_M_NSF.getAlphabetContainer();
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        return 1;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        this.FirstPosHMM.addGradientOfLogPriorTerm(grad, start);
        this.tal_A_NSF.addGradientOfLogPriorTerm(grad, start += this.FirstPosHMM.getNumberOfParameters());
        this.tal_M_NSF.addGradientOfLogPriorTerm(grad, start += this.tal_A_NSF.getNumberOfParameters());
        start += this.tal_M_NSF.getNumberOfParameters();
    }

    @Override
    public double getESS() {
        return this.Ess;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getLogPriorTerm() {
        double logPrior = 0.0;
        logPrior += this.FirstPosHMM.getLogPriorTerm();
        logPrior += this.tal_A_NSF.getLogPriorTerm();
        return logPrior += this.tal_M_NSF.getLogPriorTerm();
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        double[] params = new double[this.getNumberOfParameters()];
        int off = 0;
        System.arraycopy(this.FirstPosHMM.getCurrentParameterValues(), 0, params, off, this.FirstPosHMM.getNumberOfParameters());
        System.arraycopy(this.tal_A_NSF.getCurrentParameterValues(), 0, params, off += this.FirstPosHMM.getNumberOfParameters(), this.tal_A_NSF.getNumberOfParameters());
        System.arraycopy(this.tal_M_NSF.getCurrentParameterValues(), 0, params, off += this.tal_A_NSF.getNumberOfParameters(), this.tal_M_NSF.getNumberOfParameters());
        return params;
    }

    @Override
    public String getInstanceName() {
        return "TAL_Finder_NSF";
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start) {
        return this.getLogScoreFor(seq, start, seq.getLength() - 1);
    }

    public double getBestPossibleScore(Sequence tal, double[] scs) {
        if (this.isFixed) {
            double sum = 0.0;
            double temp = ToolBox.max(this.firstPosProbs);
            sum += temp;
            if (scs != null) {
                scs[0] = temp;
            }
            boolean context = false;
            int i = 1;
            while (i <= tal.getLength()) {
                int rvd = tal.discreteVal(i - 1);
                int order = Math.min(i - 1, this.Ordnung_tal_U);
                double max = Double.NEGATIVE_INFINITY;
                int j = 0;
                while (j < this.condProbs[order][rvd].length) {
                    temp = ToolBox.max(this.condProbs[order][rvd][j]);
                    if (temp > max) {
                        max = temp;
                    }
                    ++j;
                }
                sum += max;
                if (scs != null) {
                    scs[i] = max;
                }
                ++i;
            }
            return sum;
        }
        throw new RuntimeException();
    }

    public double getPartialLogScoreFor(Sequence rvds, int[] seq, int start, int off, int length) {
        if (this.isFixed) {
            int initStart = start;
            int end = start + off + length - 1;
            double logScore = 0.0;
            if (off == 0) {
                logScore += this.firstPosProbs[seq[start]];
                ++start;
            }
            int context = 0;
            int i = start + off;
            while (i <= end) {
                int rvd = rvds.discreteVal(i - 1 - initStart);
                int order = Math.min(i - start + (off == 0 ? 0 : -1), this.Ordnung_tal_U);
                if (order > 0) {
                    context = order == 1 ? seq[i - 1] : (order < this.Ordnung_tal_U || i - (start + off - 1) < order ? TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order) : TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order, context));
                }
                int curr = seq[i];
                logScore += this.condProbs[order][rvd][context][curr];
                ++i;
            }
            return logScore;
        }
        throw new RuntimeException();
    }

    public double getPartialLogScoreFor(Sequence rvds, Sequence seq, int start, int off, int length) {
        if (this.isFixed) {
            int initStart = start;
            int end = start + off + length - 1;
            double logScore = 0.0;
            if (off == 0) {
                logScore += this.firstPosProbs[seq.discreteVal(start)];
                ++start;
            }
            int context = 0;
            int i = start + off;
            while (i <= end) {
                int rvd = rvds.discreteVal(i - 1 - initStart);
                int order = Math.min(i - start + (off == 0 ? 0 : -1), this.Ordnung_tal_U);
                if (order > 0) {
                    context = order == 1 ? seq.discreteVal(i - 1) : (order < this.Ordnung_tal_U || i - (start + off - 1) < order ? TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order) : TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order, context));
                }
                int curr = seq.discreteVal(i);
                logScore += this.condProbs[order][rvd][context][curr];
                ++i;
            }
            return logScore;
        }
        throw new RuntimeException();
    }

    @Override
    public double getLogScoreFor(Sequence seq, int start, int end) {
        double logScore = 0.0;
        if (this.isFixed) {
            logScore += this.firstPosProbs[seq.discreteVal(start)];
            Sequence rvds = ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
            int context = 0;
            int i = ++start;
            while (i <= end) {
                int rvd = rvds.discreteVal(i - 1);
                int order = Math.min(i - start, this.Ordnung_tal_U);
                if (order > 0) {
                    context = order == 1 ? seq.discreteVal(i - 1) : (order < this.Ordnung_tal_U ? TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order) : TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order, context));
                }
                int curr = seq.discreteVal(i);
                logScore += this.condProbs[order][rvd][context][curr];
                ++i;
            }
        } else {
            logScore = this.FirstPosHMM.getLogScoreFor(seq, start, start);
            double[] temp = new double[2];
            int i = ++start;
            while (i <= end) {
                double logScore_tal_M = this.tal_M_NSF.getLogScoreFor(seq, i);
                temp[0] = logScore_tal_M + this.tal_A_NSF.getLogScoreFor(seq, i);
                temp[1] = Math.log(1.0 - Math.exp(logScore_tal_M));
                if (this.Ordnung_tal_U == 0 || i - start == 0) {
                    temp[1] = temp[1] + this.tal_U_NSF.getLogScoreFor(seq, i, i);
                } else {
                    int l = Math.min(i - start, this.Ordnung_tal_U) + 1;
                    temp[1] = temp[1] + (this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i) - this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i - 1));
                }
                logScore += Normalisation.getLogSum(temp);
                ++i;
            }
        }
        return logScore;
    }

    public void fix() throws WrongAlphabetException, WrongSequenceTypeException {
        DiscreteAlphabet rvds = (DiscreteAlphabet)this.tal_M_NSF.getAlphabetContainer().getAlphabetAt(0);
        DiscreteAlphabet nucs = (DiscreteAlphabet)this.alphabets.getAlphabetAt(0);
        this.firstPosProbs = new double[(int)nucs.length()];
        this.firstPosMatches = new int[this.firstPosProbs.length];
        int i = 0;
        while ((double)i < nucs.length()) {
            this.firstPosProbs[i] = this.FirstPosHMM.getLogScoreFor(new IntSequence(this.alphabets, i));
            if (this.firstPosProbs[i] > -Math.log(nucs.length())) {
                this.firstPosMatches[i] = 1;
            }
            ++i;
        }
        SequenceAnnotation[] rvdAnns = new SequenceAnnotation[(int)rvds.length()];
        int i2 = 0;
        while ((double)i2 < rvds.length()) {
            rvdAnns[i2] = new ReferenceSequenceAnnotation("rvds", new IntSequence(this.getRVDAlphabet(), i2), new Result[0]);
            ++i2;
        }
        int order = this.Ordnung_tal_U;
        double[] parts = new double[2];
        this.condProbs = new double[order + 1][][][];
        this.matches = new int[order + 1][][][];
        int i3 = 0;
        while (i3 < order + 1) {
            this.condProbs[i3] = new double[(int)rvds.length()][(int)Math.pow(nucs.length(), i3)][(int)nucs.length()];
            this.matches[i3] = new int[(int)rvds.length()][(int)Math.pow(nucs.length(), i3)][(int)nucs.length()];
            int j = 0;
            while (j < rvdAnns.length) {
                int k = 0;
                while (k < this.condProbs[i3][j].length) {
                    int l = 0;
                    while (l < this.condProbs[i3][j][k].length) {
                        Sequence temp = this.getSequenceFor(k, l, i3);
                        Sequence temp2 = temp = temp.annotate(false, rvdAnns[j]);
                        if (temp.getLength() > 2) {
                            temp2 = temp.getSubSequence(temp.getLength() - 2);
                            temp2 = temp2.annotate(false, temp.getAnnotation());
                        }
                        double logScore_tal_M = this.tal_M_NSF.getLogScoreFor(temp, 1);
                        parts[0] = logScore_tal_M + this.tal_A_NSF.getLogScoreFor(temp2, 1);
                        parts[1] = Math.log(1.0 - Math.exp(logScore_tal_M));
                        parts[1] = i3 == 0 ? parts[1] + this.tal_U_NSF.getLogScoreFor(temp, temp.getLength() - 1, temp.getLength() - 1) : parts[1] + (this.tal_U_NSF.getLogScoreFor(temp, 1, temp.getLength() - 1) - this.tal_U_NSF.getLogScoreFor(temp, 1, temp.getLength() - 2));
                        if (parts[0] > parts[1] && parts[0] - logScore_tal_M > -Math.log(nucs.length())) {
                            this.matches[i3][j][k][l] = 1;
                        }
                        this.condProbs[i3][j][k][l] = Normalisation.getLogSum(parts);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        this.isFixed = true;
    }

    public Sequence getBestRVDsFor(Sequence target, int[] allowed) throws WrongAlphabetException, WrongSequenceTypeException {
        if (allowed == null) {
            allowed = new int[(int)this.getRVDAlphabet().getAlphabetLengthAt(0)];
            int i = 0;
            while (i < allowed.length) {
                allowed[i] = i;
                ++i;
            }
        }
        int[] tal = new int[target.getLength() - 1];
        if (this.isFixed) {
            int start = 1;
            int end = target.getLength() - 1;
            int context = 0;
            int i = start;
            while (i <= end) {
                int order = Math.min(i - start, this.Ordnung_tal_U);
                if (order > 0) {
                    context = order == 1 ? target.discreteVal(i - 1) : (order < this.Ordnung_tal_U ? TALgetterDiffSM.getContextIndexFor(this.pows, target, i - order, order) : TALgetterDiffSM.getContextIndexFor(this.pows, target, i - order, order, context));
                }
                int curr = target.discreteVal(i);
                double max = Double.NEGATIVE_INFINITY;
                int j = 0;
                while (j < allowed.length) {
                    if (this.condProbs[order][allowed[j]][context][curr] > max) {
                        max = this.condProbs[order][allowed[j]][context][curr];
                        tal[i - 1] = allowed[j];
                    }
                    ++j;
                }
                ++i;
            }
            return new IntSequence(this.getRVDAlphabet(), tal);
        }
        throw new RuntimeException();
    }

    private static final int getContextIndexFor(int[] pows, Sequence seq, int start, int order, int context) {
        context = order > 1 ? context % pows[order - 1] * pows[1] + seq.discreteVal(start + order - 1) : seq.discreteVal(start + order - 1);
        return context;
    }

    private static final int getContextIndexFor(int[] pows, int[] seq, int start, int order, int context) {
        context = order > 1 ? context % pows[order - 1] * pows[1] + seq[start + order - 1] : seq[start + order - 1];
        return context;
    }

    private static final int getContextIndexFor(int[] pows, Sequence seq, int start, int order) {
        int index = 0;
        int i = 0;
        while (i < order) {
            index += pows[order - i - 1] * seq.discreteVal(start + i);
            ++i;
        }
        return index;
    }

    private static final int getContextIndexFor(int[] pows, int[] seq, int start, int order) {
        int index = 0;
        int i = 0;
        while (i < order) {
            index += pows[order - i - 1] * seq[start + i];
            ++i;
        }
        return index;
    }

    private Sequence getSequenceFor(int context, int curr, int order) throws WrongAlphabetException, WrongSequenceTypeException {
        int[] cont = new int[order + 2];
        cont[cont.length - 1] = curr;
        int i = 0;
        while (i < order) {
            cont[i + 1] = context / this.pows[order - i - 1];
            context %= this.pows[order - i - 1];
            ++i;
        }
        return new IntSequence(this.alphabets, cont);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        return this.getLogScoreAndPartialDerivation(seq, start, seq.getLength() - 1, indices, partialDer);
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, int end, IntList indices, DoubleList partialDer) {
        if (this.isFixed) {
            throw new RuntimeException("Model is fixed");
        }
        double logScore = 0.0;
        logScore = this.FirstPosHMM.getLogScoreAndPartialDerivation(seq.getSubSequence(start, 1), 0, indices, partialDer);
        ++start;
        double[] temp = new double[2];
        DoubleList partialA = new DoubleList();
        DoubleList partialM = new DoubleList();
        DoubleList partialUPos = new DoubleList();
        DoubleList partialUNeg = new DoubleList();
        IntList tempIndices = new IntList();
        IntList tempIndices2 = new IntList();
        int offA = this.FirstPosHMM.getNumberOfParameters();
        int offM = offA + this.tal_A_NSF.getNumberOfParameters();
        int offU = offM + this.tal_M_NSF.getNumberOfParameters();
        int i = start;
        while (i <= end) {
            partialA.clear();
            partialM.clear();
            partialUPos.clear();
            partialUNeg.clear();
            double logScore_tal_A = this.tal_A_NSF.getLogScoreAndPartialDerivation(seq, i, tempIndices, partialA);
            int j = 0;
            while (j < tempIndices.length()) {
                indices.add(tempIndices.get(j) + offA);
                ++j;
            }
            tempIndices.clear();
            double logScore_tal_M = this.tal_M_NSF.getLogScoreAndPartialDerivation(seq, i, tempIndices, partialM);
            temp[0] = logScore_tal_M + logScore_tal_A;
            j = 0;
            while (j < tempIndices.length()) {
                indices.add(tempIndices.get(j) + offM);
                ++j;
            }
            tempIndices.clear();
            double logScore_tal_U = 0.0;
            if (this.Ordnung_tal_U == 0 || i - start == 0) {
                logScore_tal_U += this.tal_U_NSF.getLogScoreFor(seq, i, i);
            } else {
                int l = Math.min(i - start, this.Ordnung_tal_U) + 1;
                logScore_tal_U += this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i) - this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i - 1);
            }
            temp[1] = Math.log1p(-Math.exp(logScore_tal_M)) + logScore_tal_U;
            double localLogScore = Normalisation.getLogSum(temp);
            logScore += localLogScore;
            j = 0;
            while (j < partialA.length()) {
                partialDer.add(partialA.get(j) * Math.exp(logScore_tal_A + logScore_tal_M - localLogScore));
                ++j;
            }
            j = 0;
            while (j < partialM.length()) {
                partialDer.add(partialM.get(j) * Math.exp(logScore_tal_M - localLogScore) * (Math.exp(logScore_tal_A) - Math.exp(logScore_tal_U)));
                ++j;
            }
            j = 0;
            while (j < partialUPos.length()) {
                partialDer.add(partialUPos.get(j) * Math.exp(logScore_tal_U - localLogScore) * (1.0 - Math.exp(logScore_tal_M)));
                ++j;
            }
            ++i;
        }
        return logScore;
    }

    @Override
    public int getNumberOfParameters() {
        int number = this.FirstPosHMM.getNumberOfParameters();
        number += this.tal_A_NSF.getNumberOfParameters();
        return number += this.tal_M_NSF.getNumberOfParameters();
    }

    @Override
    public void initializeFunction(int index, boolean freeParams, DataSet[] data, double[][] weights) throws Exception {
        this.initializeFunctionRandomly(freeParams);
    }

    public void trainIndependent(DataSet trainDs) throws Exception {
        DifferentiableStatisticalModelWrapperTrainSM temp = new DifferentiableStatisticalModelWrapperTrainSM(this.tal_U_NSF, 1, 20, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-12), 1.0E-12, 1.0E-4);
        temp.setOutputStream(SafeOutputStream.getSafeOutputStream(null));
        temp.train(trainDs);
        this.tal_U_NSF = (HomogeneousMMDiffSM)temp.getFunction();
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        this.FirstPosHMM.initializeFunctionRandomly(freeParams);
        this.tal_A_NSF.initializeFunctionRandomly(freeParams);
        this.tal_M_NSF.initializeFunctionRandomly(freeParams);
        this.isInitialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setParameters(double[] params, int start) {
        if (this.isFixed) {
            throw new RuntimeException("Model is fixed");
        }
        this.FirstPosHMM.setParameters(params, start);
        this.tal_A_NSF.setParameters(params, start += this.FirstPosHMM.getNumberOfParameters());
        this.tal_M_NSF.setParameters(params, start += this.tal_A_NSF.getNumberOfParameters());
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(xml, this.length, "length");
        XMLParser.appendObjectWithTags(xml, this.Ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.FirstPosHMM, "firstPosHMM");
        XMLParser.appendObjectWithTags(xml, this.isInitialized, "isInitialized");
        XMLParser.appendObjectWithTags(xml, this.Ordnung_tal_U, "order");
        XMLParser.appendObjectWithTags(xml, this.tal_A_NSF, "talansf");
        XMLParser.appendObjectWithTags(xml, this.tal_M_NSF, "talmnsf");
        XMLParser.appendObjectWithTags(xml, this.tal_U_NSF, "talunsf");
        XMLParser.appendObjectWithTags(xml, this.isFixed, "isFixed");
        XMLParser.addTags(xml, "TALFinder");
        return xml;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "TALFinder");
        this.alphabets = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabets");
        this.length = XMLParser.extractObjectForTags(xml, "length", Integer.TYPE);
        this.Ess = XMLParser.extractObjectForTags(xml, "ess", Double.TYPE);
        this.FirstPosHMM = (HomogeneousMMDiffSM)XMLParser.extractObjectForTags(xml, "firstPosHMM");
        this.isInitialized = XMLParser.extractObjectForTags(xml, "isInitialized", Boolean.TYPE);
        this.Ordnung_tal_U = XMLParser.extractObjectForTags(xml, "order", Integer.TYPE);
        this.tal_A_NSF = (TALgetterRVDDependentComponent)XMLParser.extractObjectForTags(xml, "talansf");
        this.tal_M_NSF = (TALgetterMixture)XMLParser.extractObjectForTags(xml, "talmnsf");
        this.tal_U_NSF = (HomogeneousMMDiffSM)XMLParser.extractObjectForTags(xml, "talunsf");
        this.isFixed = XMLParser.extractObjectForTags(xml, "isFixed", Boolean.TYPE);
        this.pows = new int[this.Ordnung_tal_U];
        int i = 0;
        while (i < this.pows.length) {
            this.pows[i] = (int)Math.pow((int)this.alphabets.getAlphabetLengthAt(0), i);
            ++i;
        }
        if (this.isFixed) {
            try {
                this.fix();
            }
            catch (Exception e) {
                NonParsableException ex = new NonParsableException(e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
        }
    }

    public Pair<double[][], double[]> getSpecificitiesAndImportances(Sequence rvds) {
        double[][] specs = new double[rvds.getLength() + 1][];
        specs[0] = new double[(int)this.FirstPosHMM.getAlphabetContainer().getAlphabetLengthAt(0)];
        DiscreteSequenceEnumerator dse = new DiscreteSequenceEnumerator(this.FirstPosHMM.getAlphabetContainer(), 1, false);
        int i = 0;
        while (dse.hasMoreElements()) {
            specs[0][i] = this.FirstPosHMM.getLogScoreFor((Sequence)dse.nextElement());
            ++i;
        }
        Normalisation.logSumNormalisation(specs[0]);
        i = 0;
        while (i < rvds.getLength()) {
            specs[i + 1] = this.tal_A_NSF.getSpecificities(rvds, i);
            ++i;
        }
        double[] imp = new double[rvds.getLength()];
        i = 0;
        while (i < rvds.getLength()) {
            imp[i] = this.tal_M_NSF.getImportance(rvds, i);
            ++i;
        }
        return new Pair<double[][], double[]>(specs, imp);
    }

    public void setIndependentToStationary() {
        this.tal_U_NSF.setStartParamsToConditionalStationaryDistributions();
    }

    public void addAndSet(String[] rvds, double[][] specs, double[] fpSpec) throws IllegalArgumentException, WrongAlphabetException, DoubleSymbolException {
        int oldLen = (int)this.getRVDAlphabet().getAlphabetAt(0).length();
        AlphabetContainer con = this.tal_A_NSF.addAndSet(rvds, specs);
        int newLen = (int)con.getAlphabetAt(0).length();
        this.tal_M_NSF.addAndSet(con, rvds);
        if (fpSpec != null) {
            double[] temp = (double[])fpSpec.clone();
            int i = 0;
            while (i < temp.length) {
                temp[i] = Math.log(temp[i]);
                ++i;
            }
            this.FirstPosHMM.setParameters(temp, 0);
        }
    }

    @Override
    public String toString(NumberFormat nf) {
        StringBuffer buf = new StringBuffer();
        buf.append("******************************************************");
        buf.append("\nModel position 0:\n");
        buf.append(this.FirstPosHMM.toString(nf));
        buf.append("******************************************************");
        buf.append("\nModel mixture:\n");
        buf.append(this.tal_M_NSF.toString(nf));
        buf.append("******************************************************");
        buf.append("\nModel dependent:\n");
        buf.append(this.tal_A_NSF.toString(nf));
        buf.append("******************************************************");
        buf.append("\nModel context:");
        buf.append(this.tal_U_NSF.toString(nf));
        buf.append("******************************************************");
        return buf.toString();
    }

    public String getMatchString(Sequence seq) {
        ReferenceSequenceAnnotation data_anno = (ReferenceSequenceAnnotation)seq.getSequenceAnnotationByType("reference", 0);
        Sequence rvds = data_anno.getReferenceSequence();
        return this.getMatchString(rvds, seq);
    }

    public String getMatchString(Sequence rvds, Sequence seq) {
        seq = seq.annotate(true, new ReferenceSequenceAnnotation("seq", rvds, new Result[0]));
        StringBuffer sb = new StringBuffer();
        if (this.FirstPosHMM.getLogProbFor(seq, 0, 0) > -Math.log(seq.getAlphabetContainer().getAlphabetLengthAt(0))) {
            sb.append("M");
        } else {
            sb.append("m");
        }
        double[] temp = new double[2];
        int start = 1;
        int end = rvds.getLength();
        int i = start;
        while (i <= end) {
            double logScore_tal_M = this.tal_M_NSF.getLogScoreFor(seq, i);
            temp[0] = logScore_tal_M + this.tal_A_NSF.getLogScoreFor(seq, i);
            temp[1] = Math.log(1.0 - Math.exp(logScore_tal_M));
            if (this.Ordnung_tal_U == 0 || i - start == 0) {
                temp[1] = temp[1] + this.tal_U_NSF.getLogScoreFor(seq, i, i);
            } else {
                int l = Math.min(i - start, this.Ordnung_tal_U) + 1;
                temp[1] = temp[1] + (this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i) - this.tal_U_NSF.getLogScoreFor(seq, i - l + 1, i - 1));
            }
            if (logScore_tal_M > Math.log(0.7) && temp[0] > temp[1] && temp[0] - logScore_tal_M > Math.log(0.7)) {
                sb.append("|");
            } else if (temp[0] - logScore_tal_M > -Math.log(seq.getAlphabetContainer().getAlphabetLengthAt(i))) {
                sb.append(":");
            } else {
                sb.append("x");
            }
            ++i;
        }
        return sb.toString();
    }

    public int getNumberOfMatches(Sequence seq, Sequence rvds) {
        if (this.firstPosMatches == null) {
            throw new RuntimeException("Only after fix");
        }
        int numMatches = this.firstPosMatches[seq.discreteVal(0)];
        int i = 1;
        while (i < seq.getLength()) {
            int rvd = rvds.discreteVal(i - 1);
            int order = Math.min(i, this.Ordnung_tal_U);
            int context = 0;
            if (order > 0) {
                context = TALgetterDiffSM.getContextIndexFor(this.pows, seq, i - order, order);
            }
            int curr = seq.discreteVal(i);
            numMatches += this.matches[order][rvd][context][curr];
            ++i;
        }
        return numMatches;
    }

    public int getOrder() {
        return this.Ordnung_tal_U;
    }
}

