/*
 * Decompiled with CFR 0.152.
 */
package supplementary.codeExamples;

import de.jstacs.classifiers.performanceMeasures.AbstractPerformanceMeasure;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;

public class AUC {
    private static void getValues(String fName, DoubleList score, DoubleList fg, DoubleList bg, double fgWeight) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(fName));
        while ((line = r.readLine()) != null) {
            score.add(Double.parseDouble(line));
            fg.add(fgWeight);
            bg.add(1.0 - fgWeight);
        }
        r.close();
    }

    private static void getValues(String fName, DoubleList score, DoubleList fg, DoubleList bg) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(fName));
        while ((line = r.readLine()) != null) {
            String[] split = line.split("\t");
            score.add(Double.parseDouble(split[0]));
            fg.add(Double.parseDouble(split[1]));
            bg.add(Double.parseDouble(split[2]));
        }
        r.close();
    }

    public static void main(String[] args) throws Exception {
        AbstractPerformanceMeasure[] m;
        DoubleList score = new DoubleList();
        DoubleList fg = new DoubleList();
        DoubleList bg = new DoubleList();
        switch (args.length) {
            case 1: {
                AUC.getValues(args[0], score, fg, bg);
                break;
            }
            case 2: {
                AUC.getValues(args[0], score, fg, bg, 1.0);
                AUC.getValues(args[1], score, fg, bg, 0.0);
                break;
            }
            default: {
                System.out.println("There are two options to start this program.");
                System.out.println();
                System.out.println("For unweighted data, please use:\njava -jar AUC.jar <fg> <bg>\nwhere <fg> and <bg> are files with one classification score per line.");
                System.out.println();
                System.out.println("For weighted data please use:\njava -jar AUC.jar <weighted>\nwhere <weighted> is a tab-delimited file with one classification score and the weights for fg and bg per line.");
                System.exit(0);
            }
        }
        double[] s = score.toArray();
        double[] fgWeights = fg.toArray();
        double[] bgWeights = bg.toArray();
        ToolBox.sortAlongWith(s, fgWeights, bgWeights);
        AbstractPerformanceMeasure[] abstractPerformanceMeasureArray = m = new AbstractPerformanceMeasure[]{new AucPR(), new AucROC()};
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPerformanceMeasure current = abstractPerformanceMeasureArray[n2];
            ResultSet rs = current.compute(s, fgWeights, s, bgWeights);
            System.out.println(rs);
            ++n2;
        }
    }
}

