/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;

public class MathFunctionUtil {
    public static double H = 1.0E-6;
    public static int NUMINTERVALS = 10000;

    private MathFunctionUtil() {
    }

    public static double derivative(MathFunction func, double x) {
        if (func instanceof MathFunctionWithFirstDerivative) {
            return ((MathFunctionWithFirstDerivative)func).derivative(x);
        }
        if (func instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)func).derivative(x, 1);
        }
        return MathFunctionUtil.finiteCenteredDifferenceDerivative(func, x, H);
    }

    public static double derivative(MathFunction func, double x, int n) {
        if (n == 0) {
            return func.evaluate(x);
        }
        if (n == 1) {
            return MathFunctionUtil.derivative(func, x);
        }
        if (func instanceof MathFunctionWithDerivative) {
            return ((MathFunctionWithDerivative)func).derivative(x, n);
        }
        if (n % 2 == 0) {
            return MathFunctionUtil.finiteCenteredDifferenceDerivative(func, x, n, H);
        }
        return MathFunctionUtil.finiteDifferenceDerivative(func, x, n, H);
    }

    public static double finiteDifferenceDerivative(MathFunction func, double x, int n, double h) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return func.evaluate(x);
        }
        double err = Math.pow(h, 1.0 / (double)n);
        double[] values = new double[n + 1];
        for (int i = 0; i < values.length; ++i) {
            values[i] = func.evaluate(x + (double)i * err);
        }
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < n - j; ++i) {
                values[i] = values[i + 1] - values[i];
            }
        }
        return values[0] / h;
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction func, double x, double h) {
        double fplus = func.evaluate(x + h);
        double fminus = func.evaluate(x - h);
        return (fplus - fminus) / (2.0 * h);
    }

    public static double finiteCenteredDifferenceDerivative(MathFunction func, double x, int n, double h) {
        if (n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }
        if (n == 0) {
            return func.evaluate(x);
        }
        if (n % 2 == 1) {
            throw new IllegalArgumentException("n must be even");
        }
        double err = Math.pow(h, 1.0 / (double)n);
        return MathFunctionUtil.finiteDifferenceDerivative(func, x - (double)n * err / 2.0, n, h);
    }

    public static double[][] removeNaNs(double[] x, double[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException();
        }
        int numNaNs = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!Double.isNaN(x[i]) && !Double.isNaN(y[i])) continue;
            ++numNaNs;
        }
        if (numNaNs == 0) {
            return new double[][]{x, y};
        }
        double[] nx = new double[x.length - numNaNs];
        double[] ny = new double[y.length - numNaNs];
        int j = 0;
        for (int i = 0; i < x.length; ++i) {
            if (Double.isNaN(x[i]) || Double.isNaN(y[i])) continue;
            nx[j] = x[i];
            ny[j++] = y[i];
        }
        return new double[][]{nx, ny};
    }

    public static double integral(MathFunction func, double a, double b) {
        if (func instanceof MathFunctionWithIntegral) {
            return ((MathFunctionWithIntegral)func).integral(a, b);
        }
        return MathFunctionUtil.simpsonIntegral(func, a, b, NUMINTERVALS);
    }

    public static double simpsonIntegral(MathFunction func, double a, double b, int numIntervals) {
        if (numIntervals % 2 != 0) {
            throw new IllegalArgumentException("numIntervals must be an even number");
        }
        if (Double.isInfinite(a) || Double.isInfinite(b) || Double.isNaN(a) || Double.isNaN(b)) {
            throw new IllegalArgumentException("a and b must not be infinite or NaN");
        }
        if (b < a) {
            throw new IllegalArgumentException("b < a");
        }
        if (a == b) {
            return 0.0;
        }
        double h = (b - a) / (double)numIntervals;
        double h2 = 2.0 * h;
        int m = numIntervals / 2;
        double sum = 0.0;
        for (int i = 0; i < m - 1; ++i) {
            double x = a + h + 2.0 * h * (double)i;
            sum += 4.0 * func.evaluate(x) + 2.0 * func.evaluate(x + h);
        }
        return (sum += func.evaluate(a) + func.evaluate(b) + 4.0 * func.evaluate(b - h)) * h / 3.0;
    }
}

