/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.Inversion;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;
import de.jtem.numericalMethods.algebra.polynomial.ComplexPolynomial;

public class BirkhoffFactorization {
    public static final int NEG_POS = 0;
    public static final int POS_NEG = 1;
    public static final int FIRST = 0;
    public static final int SECOND = 1;

    public static void factor(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, int n, int n2, int n3) {
        int n4 = dArray.length;
        int n5 = (dArray[0][0].length - 1) / 2;
        int n6 = n5 + 1;
        int n7 = n6 * n4;
        double[][][] dArray5 = new double[n4][n4][n5 + 1];
        double[][][] dArray6 = new double[n4][n4][n5 + 1];
        double[][] dArray7 = new double[n7][n7];
        double[][] dArray8 = new double[n7][n7];
        double[] dArray9 = new double[n7];
        double[] dArray10 = new double[n7];
        double[] dArray11 = new double[n7];
        double[] dArray12 = new double[n7];
        double[][] dArray13 = new double[n4][n7];
        double[][] dArray14 = new double[n4][n7];
        double[][] dArray15 = new double[n4][n4];
        double[][] dArray16 = new double[n4][n4];
        double[][] dArray17 = new double[n4][n4];
        double[][] dArray18 = new double[n4][n4];
        double[][][] dArray19 = new double[n4][n4][n5 + 1];
        double[][][] dArray20 = new double[n4][n4][n5 + 1];
        double[] dArray21 = new double[2 * n5 + 1];
        double[] dArray22 = new double[2 * n5 + 1];
        BirkhoffFactorization.factor(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11, dArray12, dArray13, dArray14, dArray15, dArray16, dArray17, dArray18, dArray19, dArray20, dArray21, dArray22, n, n2, n3);
    }

    public static void factor(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[][] dArray7, double[][] dArray8, double[] dArray9, double[] dArray10, double[] dArray11, double[] dArray12, double[][] dArray13, double[][] dArray14, double[][] dArray15, double[][] dArray16, double[][] dArray17, double[][] dArray18, double[][][] dArray19, double[][][] dArray20, double[] dArray21, double[] dArray22, int n, int n2, int n3) {
        int n4;
        int n5 = dArray.length;
        int n6 = (dArray[0][0].length - 1) / 2;
        int n7 = n6 + 1;
        if (n7 <= n6) {
            throw new IllegalArgumentException("blockSize must be at least degree+1");
        }
        boolean bl = BirkhoffFactorization.isNegative(n, n2);
        boolean bl2 = n2 == 1;
        for (int i = 0; i < n5; ++i) {
            for (n4 = 0; n4 < n5; ++n4) {
                if (!bl2) {
                    BirkhoffFactorization.setBlock(dArray[i][n4], dArray7, i, n4, n6, n7);
                    BirkhoffFactorization.setBlock(dArray2[i][n4], dArray8, i, n4, n6, n7);
                    continue;
                }
                BirkhoffFactorization.setBlock(dArray[i][n4], dArray7, n4, i, n6, n7);
                BirkhoffFactorization.setBlock(dArray2[i][n4], dArray8, n4, i, n6, n7);
            }
        }
        double[] dArray23 = Householder.decompose(dArray7, dArray8, dArray9, dArray10, dArray11, dArray12);
        if (dArray23[0] == 0.0 && dArray23[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        for (n4 = 0; n4 < n5; ++n4) {
            BirkhoffFactorization.assignZero(dArray13[n4]);
            BirkhoffFactorization.assignZero(dArray14[n4]);
            if (bl) {
                dArray13[n4][n4 * n7] = 1.0;
            } else {
                dArray13[n4][n4 * n7 + n7 - 1] = 1.0;
            }
            Householder.qTimes(dArray7, dArray8, dArray13[n4], dArray14[n4], true);
        }
        for (n4 = 0; n4 < dArray9.length; ++n4) {
            dArray7[n4][n4] = dArray9[n4];
            dArray8[n4][n4] = dArray10[n4];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n8;
            int n9;
            RXB.solve(dArray7, dArray8, dArray11, dArray12, dArray13[n4], dArray14[n4]);
            int n10 = n9 = bl ? 0 : n7 - (n6 + 1);
            if (!bl2) {
                for (n8 = 0; n8 < n5; ++n8) {
                    BirkhoffFactorization.getBlock(dArray5[n8][n4], dArray11, n8 * n7 + n9, n6);
                    BirkhoffFactorization.getBlock(dArray6[n8][n4], dArray12, n8 * n7 + n9, n6);
                }
                continue;
            }
            for (n8 = 0; n8 < n5; ++n8) {
                BirkhoffFactorization.getBlock(dArray5[n4][n8], dArray11, n8 * n7 + n9, n6);
                BirkhoffFactorization.getBlock(dArray6[n4][n8], dArray12, n8 * n7 + n9, n6);
            }
        }
        double[][][] dArray24 = dArray5;
        double[][][] dArray25 = dArray6;
        double[][][] dArray26 = dArray3;
        double[][][] dArray27 = dArray4;
        if (n2 == 0 && n3 == 1 || n2 == 1 && n3 == 0) {
            BirkhoffFactorization.normalize(dArray5, dArray6, dArray19, dArray20, dArray17, dArray18, dArray15, dArray16, dArray9, dArray10, dArray13[0], dArray14[0], n2 == 1, !bl);
            dArray24 = dArray19;
            dArray25 = dArray20;
            dArray26 = dArray3;
            dArray27 = dArray4;
        }
        if (bl) {
            if (!bl2) {
                BirkhoffFactorization.blockMultiplyPosNeg(dArray, dArray2, dArray24, dArray25, dArray26, dArray27, dArray21, dArray22);
            } else {
                BirkhoffFactorization.blockMultiplyPosNegReverse(dArray, dArray2, dArray24, dArray25, dArray26, dArray27, dArray21, dArray22);
            }
        } else if (!bl2) {
            BirkhoffFactorization.blockMultiplyNegPos(dArray, dArray2, dArray24, dArray25, dArray26, dArray27, dArray21, dArray22);
        } else {
            BirkhoffFactorization.blockMultiplyNegPosReverse(dArray, dArray2, dArray24, dArray25, dArray26, dArray27, dArray21, dArray22);
        }
    }

    public static boolean isNegative(int n, int n2) {
        return n == 0 && n2 == 0 || n == 1 && n2 == 1;
    }

    private static void blockMultiplyPosNeg(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray[0][0].length - 1;
        int n3 = dArray3[0][0].length - 1;
        int n4 = dArray5[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ComplexPolynomial.times(dArray[i][0], dArray2[i][0], n2, dArray3[0][j], dArray4[0][j], n3, dArray5[i][j], dArray6[i][j], n4);
                for (int k = 1; k < n; ++k) {
                    ComplexPolynomial.times(dArray[i][k], dArray2[i][k], n2, dArray3[k][j], dArray4[k][j], n3, dArray7, dArray8, n4);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyPosNegReverse(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray[0][0].length - 1;
        int n3 = dArray3[0][0].length - 1;
        int n4 = dArray5[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                ComplexPolynomial.times(dArray[0][j], dArray2[0][j], n2, dArray3[i][0], dArray4[i][0], n3, dArray5[i][j], dArray6[i][j], n4);
                for (int k = 1; k < n; ++k) {
                    ComplexPolynomial.times(dArray[k][j], dArray2[k][j], n2, dArray3[i][k], dArray4[i][k], n3, dArray7, dArray8, n4);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyNegPos(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray3[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                BirkhoffFactorization.polynomialTimes(dArray[i][0], dArray2[i][0], dArray3[0][j], dArray4[0][j], dArray5[i][j], dArray6[i][j], n2);
                for (int k = 1; k < n; ++k) {
                    BirkhoffFactorization.polynomialTimes(dArray[i][k], dArray2[i][k], dArray3[k][j], dArray4[k][j], dArray7, dArray8, n2);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void blockMultiplyNegPosReverse(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray3[0][0].length - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                BirkhoffFactorization.polynomialTimes(dArray[0][j], dArray2[0][j], dArray3[i][0], dArray4[i][0], dArray5[i][j], dArray6[i][j], n2);
                for (int k = 1; k < n; ++k) {
                    BirkhoffFactorization.polynomialTimes(dArray[k][j], dArray2[k][j], dArray3[i][k], dArray4[i][k], dArray7, dArray8, n2);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void polynomialTimes(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, int n) {
        if (dArray == dArray5 || dArray3 == dArray5) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i <= n; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            for (int j = i; j <= n; ++j) {
                d += dArray[n + j] * dArray3[n + i - j] - dArray2[n + j] * dArray4[n + i - j];
                d2 += dArray[n + j] * dArray4[n + i - j] + dArray2[n + j] * dArray3[n + i - j];
            }
            dArray5[i] = d;
            dArray6[i] = d2;
        }
    }

    private static void setBlock(double[] dArray, double[][] dArray2, int n, int n2, int n3, int n4) {
        int n5 = n * n4;
        int n6 = n2 * n4;
        int n7 = n4;
        for (int i = 0; i < n4; ++i) {
            int n8;
            int n9 = Math.max(0, i - n3);
            int n10 = Math.min(n7, n3 + 1 + i);
            for (n8 = 0; n8 < n9; ++n8) {
                dArray2[n8 + n5][i + n6] = 0.0;
            }
            for (n8 = n9; n8 < n10; ++n8) {
                dArray2[n8 + n5][i + n6] = dArray[n3 + n8 - i];
            }
            for (n8 = n10; n8 < n7; ++n8) {
                dArray2[n8 + n5][i + n6] = 0.0;
            }
        }
    }

    private static void getBlock(double[] dArray, double[] dArray2, int n, int n2) {
        System.arraycopy(dArray2, n, dArray, 0, n2 + 1);
    }

    private static void assignZero(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
    }

    public static void normalize(double[][][] dArray, double[][][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][] dArray5, double[][] dArray6, double[][] dArray7, double[][] dArray8, double[] dArray9, double[] dArray10, double[] dArray11, double[] dArray12, boolean bl, boolean bl2) {
        if (dArray == dArray3) {
            throw new IllegalArgumentException();
        }
        int n = dArray.length;
        int n2 = dArray[0][0].length - 1;
        int n3 = !bl2 ? 0 : n2;
        BirkhoffFactorization.extractCoefficient(dArray, dArray2, n3, dArray5, dArray6);
        Inversion.compute(dArray5, dArray6, dArray7, dArray8, dArray9, dArray10, dArray11, dArray12);
        if (!bl) {
            BirkhoffFactorization.times1(dArray, dArray2, dArray7, dArray8, dArray3, dArray4, dArray11, dArray12);
        } else {
            BirkhoffFactorization.times1(dArray7, dArray8, dArray, dArray2, dArray3, dArray4, dArray11, dArray12);
        }
    }

    private static void extractCoefficient(double[][][] dArray, double[][][] dArray2, int n, double[][] dArray3, double[][] dArray4) {
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[i][j] = dArray[i][j][n];
                dArray4[i][j] = dArray2[i][j][n];
            }
        }
    }

    private static void times1(double[][][] dArray, double[][][] dArray2, double[][] dArray3, double[][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray == dArray5) {
            throw new IllegalArgumentException("a==c");
        }
        int n = dArray.length;
        int n2 = dArray[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                VectorOperations.times(dArray[i][0], dArray2[i][0], dArray3[0][j], dArray4[0][j], dArray5[i][j], dArray6[i][j]);
                for (int k = 1; k < n; ++k) {
                    VectorOperations.times(dArray[i][k], dArray2[i][k], dArray3[k][j], dArray4[k][j], dArray7, dArray8);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }

    private static void times1(double[][] dArray, double[][] dArray2, double[][][] dArray3, double[][][] dArray4, double[][][] dArray5, double[][][] dArray6, double[] dArray7, double[] dArray8) {
        if (dArray3 == dArray5) {
            throw new IllegalArgumentException("a==c");
        }
        int n = dArray3.length;
        int n2 = dArray3[0][0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                VectorOperations.times(dArray3[0][j], dArray4[0][j], dArray[i][0], dArray2[i][0], dArray5[i][j], dArray6[i][j]);
                for (int k = 1; k < n; ++k) {
                    VectorOperations.times(dArray3[k][j], dArray4[k][j], dArray[i][k], dArray2[i][k], dArray7, dArray8);
                    VectorOperations.plus(dArray5[i][j], dArray7, dArray5[i][j]);
                    VectorOperations.plus(dArray6[i][j], dArray8, dArray6[i][j]);
                }
            }
        }
    }
}

