/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfOneVariable;
import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.Braket;
import de.jtem.numericalMethods.calculus.minimizing.Brent;
import de.jtem.numericalMethods.calculus.minimizing.Line;
import java.io.Serializable;

class RealFunctionOnLine
implements RealFunctionOfOneVariable,
Serializable {
    private static final long serialVersionUID = 1L;
    final RealFunctionOfSeveralVariables f;
    final Line line;

    RealFunctionOnLine(Line line, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        this.line = line;
        this.f = realFunctionOfSeveralVariables;
    }

    RealFunctionOnLine(double[] dArray, double[] dArray2, RealFunctionOfSeveralVariables realFunctionOfSeveralVariables) {
        this(new Line(dArray, dArray2), realFunctionOfSeveralVariables);
    }

    public final double eval(double d) {
        this.line.getPoint(d, this.line.otherPoint);
        return this.f.eval(this.line.otherPoint);
    }

    final double brent(double d) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[2];
        dArray[0] = -1.0;
        dArray[1] = 0.0;
        dArray[2] = 1.0;
        Braket.search(dArray, dArray2, this);
        Brent.search(dArray, dArray3, this, d);
        double d2 = dArray3[0];
        int n = 0;
        while (n < this.line.n) {
            int n2 = n;
            int n3 = n++;
            double d3 = this.line.direction[n3] * d2;
            this.line.direction[n3] = d3;
            this.line.point[n2] = this.line.point[n2] + d3;
        }
        return dArray3[1];
    }
}

