/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.odeSolving;

import de.jtem.numericalMethods.calculus.odeSolving.ODE;
import de.jtem.numericalMethods.calculus.odeSolving.ODEIntermediateResultListener;
import de.jtem.numericalMethods.calculus.odeSolving.OdeSolver;
import java.io.Serializable;

public class RungeKuttaFehlberg
implements OdeSolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int numOfEquations;
    double eps = 1.0E-7;
    double stepSize = 0.1;
    private double[][] temp;
    private int[] stepInfo = new int[2];
    private double[] h = new double[1];
    static final double SAFETY = 0.9;
    static final double PGROW = -0.2;
    static final double PSHRNK = -0.25;
    static final double ERRCON = 1.89E-4;
    static final double b21 = 0.2;
    static final double b31 = 0.075;
    static final double b32 = 0.225;
    static final double b41 = 0.3;
    static final double b42 = -0.9;
    static final double b43 = 1.2;
    static final double b51 = -0.2037037037037037;
    static final double b52 = 2.5;
    static final double b53 = -2.5925925925925926;
    static final double b54 = 1.2962962962962963;
    static final double b61 = 0.029495804398148147;
    static final double b62 = 0.341796875;
    static final double b63 = 0.041594328703703706;
    static final double b64 = 0.40034541377314814;
    static final double b65 = 0.061767578125;
    static final double a2 = 0.2;
    static final double a3 = 0.3;
    static final double a4 = 0.6;
    static final double a5 = 1.0;
    static final double a6 = 0.875;
    static final double c1 = 0.09788359788359788;
    static final double c3 = 0.4025764895330113;
    static final double c4 = 0.21043771043771045;
    static final double c6 = 0.2891022021456804;
    static final double dc5 = -0.019321986607142856;
    static final double dc1 = -0.004293774801587311;
    static final double dc3 = 0.018668586093857853;
    static final double dc4 = -0.034155026830808066;
    static final double dc6 = 0.03910220214568039;
    static final int MAX_NUM_OF_STEPS = 10000;
    static final double TINY = 1.0E-30;
    static final double EPS = 1.0E-15;

    public RungeKuttaFehlberg(int n) {
        this.setNumOfEquations(n);
    }

    public RungeKuttaFehlberg() {
        this(1);
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double d) {
        if (this.stepSize == d) {
            return;
        }
        this.stepSize = d;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double d) {
        if (this.eps == d) {
            return;
        }
        this.eps = d;
    }

    public int getNumOfEquations() {
        return this.numOfEquations;
    }

    public void setNumOfEquations(int n) {
        if (this.numOfEquations == n) {
            return;
        }
        this.numOfEquations = n;
        this.temp = new double[10][n + 1];
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(oDE, dArray, d, d2, this.eps, this.h, 0.0, this.stepInfo, null, this.temp);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(oDE, dArray, d, d2, this.eps, this.h, 0.0, this.stepInfo, oDEIntermediateResultListener, this.temp);
    }

    public void odex(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        this.h[0] = this.stepSize;
        RungeKuttaFehlberg.odex(oDE, dArray, d, d2, d3, this.h, 0.0, this.stepInfo, oDEIntermediateResultListener, this.temp);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3) {
        RungeKuttaFehlberg.solve(oDE, dArray, d, d2, d3, null);
    }

    public static void solve(ODE oDE, double[] dArray, double d, double d2, double d3, ODEIntermediateResultListener oDEIntermediateResultListener) {
        int n = oDE.getNumberOfEquations();
        new RungeKuttaFehlberg(n).odex(oDE, dArray, d, d2, d3, oDEIntermediateResultListener);
    }

    static double step(ODE oDE, double d, double[] dArray, double[] dArray2, double[] dArray3, double d2, double[] dArray4, double[] dArray5, double[][] dArray6) {
        double d3;
        int n;
        double[] dArray7;
        block2: {
            double d4;
            dArray7 = dArray6[6];
            double[] dArray8 = dArray6[7];
            n = oDE.getNumberOfEquations();
            do {
                RungeKuttaFehlberg.cashKarpErrorExtimate(oDE, d, dArray, dArray2, dArray3[0], dArray7, dArray8, dArray6);
                d3 = 0.0;
                for (int i = 0; i < n; ++i) {
                    d3 = Math.max(d3, Math.abs(dArray8[i] / dArray4[i]));
                }
                if (!((d3 /= d2) > 1.0)) break block2;
                dArray3[0] = 0.9 * dArray3[0] * Math.pow(d3, -0.25);
                if (!(dArray3[0] < 0.1 * dArray3[0])) continue;
                dArray3[0] = dArray3[0] * 0.1;
            } while ((d4 = d + dArray3[0]) != d);
            throw new IllegalArgumentException("stepsize underflow in rkqs");
        }
        System.arraycopy(dArray7, 0, dArray, 0, n);
        dArray5[0] = dArray3[0];
        dArray3[0] = d3 > 1.89E-4 ? 0.9 * dArray3[0] * Math.pow(d3, -0.2) : 5.0 * dArray3[0];
        return d += dArray3[0];
    }

    static void cashKarpErrorExtimate(ODE oDE, double d, double[] dArray, double[] dArray2, double d2, double[] dArray3, double[] dArray4, double[][] dArray5) {
        int n;
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        double[] dArray8 = dArray5[2];
        double[] dArray9 = dArray5[3];
        double[] dArray10 = dArray5[4];
        double[] dArray11 = dArray5[5];
        int n2 = oDE.getNumberOfEquations();
        double d3 = d + 0.2 * d2;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n] + 0.2 * d2 * dArray2[n];
        }
        oDE.eval(d3, dArray6, dArray7);
        d3 = d + 0.3 * d2;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n] + d2 * (0.075 * dArray2[n] + 0.225 * dArray7[n]);
        }
        oDE.eval(d3, dArray6, dArray8);
        d3 = d + 0.6 * d2;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n] + d2 * (0.3 * dArray2[n] + -0.9 * dArray7[n] + 1.2 * dArray8[n]);
        }
        oDE.eval(d3, dArray6, dArray9);
        d3 = d + 1.0 * d2;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n] + d2 * (-0.2037037037037037 * dArray2[n] + 2.5 * dArray7[n] + -2.5925925925925926 * dArray8[n] + 1.2962962962962963 * dArray9[n]);
        }
        oDE.eval(d3, dArray6, dArray10);
        d3 = d + 0.875 * d2;
        for (n = 0; n < n2; ++n) {
            dArray6[n] = dArray[n] + d2 * (0.029495804398148147 * dArray2[n] + 0.341796875 * dArray7[n] + 0.041594328703703706 * dArray8[n] + 0.40034541377314814 * dArray9[n] + 0.061767578125 * dArray10[n]);
        }
        oDE.eval(d3, dArray6, dArray11);
        for (n = 0; n < n2; ++n) {
            dArray3[n] = dArray[n] + d2 * (0.09788359788359788 * dArray2[n] + 0.4025764895330113 * dArray8[n] + 0.21043771043771045 * dArray9[n] + 0.2891022021456804 * dArray11[n]);
            dArray4[n] = d2 * (-0.004293774801587311 * dArray2[n] + 0.018668586093857853 * dArray8[n] + -0.034155026830808066 * dArray9[n] + -0.019321986607142856 * dArray10[n] + 0.03910220214568039 * dArray11[n]);
        }
    }

    static void odex(ODE oDE, double[] dArray, double d, double d2, double d3, double[] dArray2, double d4, int[] nArray, ODEIntermediateResultListener oDEIntermediateResultListener) {
        int n = oDE.getNumberOfEquations();
        RungeKuttaFehlberg.odex(oDE, dArray, d, d2, d3, dArray2, d4, nArray, oDEIntermediateResultListener, new double[10][n]);
    }

    static void odex(ODE oDE, double[] dArray, double d, double d2, double d3, double[] dArray2, double d4, int[] nArray, ODEIntermediateResultListener oDEIntermediateResultListener, double[][] dArray3) {
        int n = oDE.getNumberOfEquations();
        double[] dArray4 = dArray3[8];
        double[] dArray5 = dArray3[9];
        double[] dArray6 = new double[1];
        double d5 = d;
        dArray2[0] = d < d2 ? Math.abs(dArray2[0]) : -Math.abs(dArray2[0]);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 10000; ++i) {
            oDE.eval(d5, dArray, dArray5);
            for (int j = 0; j < n; ++j) {
                dArray4[j] = Math.abs(dArray[j]) + Math.abs(dArray5[j] * dArray2[0]) + 1.0E-30;
            }
            if (Math.abs(d2 - d5) < Math.abs(dArray2[0]) * 1.2) {
                dArray2[0] = d2 - d5;
            }
            double d6 = dArray2[0];
            d5 = RungeKuttaFehlberg.step(oDE, d5, dArray, dArray5, dArray2, d3, dArray4, dArray6, dArray3);
            if (oDEIntermediateResultListener != null) {
                oDEIntermediateResultListener.intermediateResult(d5, dArray, 0);
            }
            if (dArray2[0] == d6) {
                ++n2;
            } else {
                ++n3;
            }
            if (Math.abs((d5 - d2) / d2) < 1.0E-15) {
                nArray[0] = n2;
                nArray[1] = n3;
                return;
            }
            if (!(Math.abs(dArray6[0]) <= d4)) continue;
            throw new RuntimeException("too small step in odex");
        }
        throw new RuntimeException("too many steps in odex");
    }
}

