/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.homologene;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.OperationNotSupportedException;
import org.biojava.bio.program.homologene.DuplicateTaxonException;
import org.biojava.bio.program.homologene.HomologeneBuilder;
import org.biojava.bio.program.homologene.Taxon;

public class HomologeneTools {
    public static Taxon getTaxon(int taxonID) {
        for (Taxon curr : Taxon.taxa) {
            if (curr.getTaxonID() != taxonID) continue;
            return curr;
        }
        return null;
    }

    public static Taxon createTaxon(int taxonID, String description) throws DuplicateTaxonException {
        if (HomologeneTools.getTaxon(taxonID) != null) {
            throw new DuplicateTaxonException();
        }
        Taxon.TaxonStub newTaxon = new Taxon.TaxonStub(taxonID, description);
        return newTaxon;
    }

    public static void instantiateDB(URL url, HomologeneBuilder builder) throws OperationNotSupportedException, FileNotFoundException, IOException {
        String currLine;
        boolean inDB = false;
        boolean inGroup = false;
        if (!url.getProtocol().equals("file")) {
            throw new OperationNotSupportedException();
        }
        BufferedReader rdr = new BufferedReader(new FileReader(url.getPath()));
        Pattern titlePattern = Pattern.compile("TITLE\\s(\\d+)_(\\d+)=(\\S+)\\s(.*)");
        Pattern orthoPattern = Pattern.compile("^(\\d+)\\s*\\|\\s*(\\d+)\\s*\\|([Bbc]{1})\\|(.*)\\|\\s*(\\d+)\\s*\\|(.*)\\|(.*)\\|\\s*(\\d+)\\s*\\|(.*)\\|(.*)");
        while ((currLine = rdr.readLine()) != null) {
            Matcher m;
            if (currLine.startsWith(">")) {
                if (!inDB) {
                    builder.startDB();
                    inDB = true;
                }
                if (inGroup) {
                    builder.endGroup();
                }
                builder.startGroup();
                inGroup = true;
                continue;
            }
            if (currLine.startsWith("TITLE")) {
                try {
                    m = titlePattern.matcher(currLine);
                    if (!m.matches() || m.groupCount() != 4) continue;
                    int taxonID = Integer.parseInt(m.group(1));
                    String homologeneID = m.group(2);
                    String title = m.group(4);
                    builder.addTitle(taxonID, homologeneID.trim(), title.trim());
                }
                catch (NumberFormatException nfe) {}
                continue;
            }
            try {
                m = orthoPattern.matcher(currLine);
                if (!m.matches()) continue;
                if (!inDB) {
                    builder.startDB();
                    inDB = true;
                }
                if (!inGroup) {
                    builder.startGroup();
                    inGroup = true;
                }
                if (m.groupCount() != 10) continue;
                String taxonID0 = m.group(1).trim();
                String taxonID1 = m.group(2).trim();
                String type = m.group(3).trim();
                String locus0 = m.group(4).trim();
                String homoID0 = m.group(5).trim();
                String access0 = m.group(6).trim();
                String locus1 = m.group(7).trim();
                String homoID1 = m.group(8).trim();
                String access1 = m.group(9).trim();
                String finale = m.group(10).trim();
                Integer.parseInt(taxonID0);
                Integer.parseInt(taxonID1);
                if (!type.equals("B") && !type.equals("b") && !type.equals("c")) continue;
                if (type.equals("B")) {
                    Double.parseDouble(finale);
                    builder.startOrthoPair();
                    builder.addOrthoPairProperty("PercentIdentity", finale);
                    builder.addOrthoPairProperty("SimilarityType", "multiple");
                } else if (type.equals("b")) {
                    Integer.parseInt(finale);
                    builder.startOrthoPair();
                    builder.addOrthoPairProperty("PercentIdentity", finale);
                    builder.addOrthoPairProperty("SimilarityType", "twin");
                } else if (type.equals("c")) {
                    builder.startOrthoPair();
                    builder.addOrthoPairProperty("SimilarityType", "curated");
                    builder.addOrthoPairProperty("PercentIdentity", finale);
                }
                builder.startOrthologue();
                builder.addOrthologueProperty("TaxonID", taxonID0);
                builder.addOrthologueProperty("LocusID", locus0);
                builder.addOrthologueProperty("HomologeneID", homoID0);
                builder.addOrthologueProperty("Accession", access0);
                builder.endOrthologue();
                builder.startOrthologue();
                builder.addOrthologueProperty("TaxonID", taxonID1);
                builder.addOrthologueProperty("LocusID", locus1);
                builder.addOrthologueProperty("HomologeneID", homoID1);
                builder.addOrthologueProperty("Accession", access1);
                builder.endOrthologue();
                builder.endOrthoPair();
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                builder.endOrthoPair();
            }
        }
        if (inGroup) {
            builder.endGroup();
        }
        if (inDB) {
            builder.endDB();
        }
    }
}

