/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

public class Misc {
    private Misc() {
    }

    public static double quickSelect(double[] t, int n, int k) {
        double[] U = new double[n];
        double[] V = new double[n];
        double p = t[k - 1];
        int u = 0;
        int v = 0;
        int indV = 0;
        for (int i = 0; i < n; ++i) {
            if (t[i] <= p) {
                ++v;
                if (t[i] == p) continue;
                U[u++] = t[i];
                continue;
            }
            V[indV++] = t[i];
        }
        if (k <= u) {
            return Misc.quickSelect(U, u, k);
        }
        if (k > v) {
            return Misc.quickSelect(V, indV, k - v);
        }
        return p;
    }

    public static int quickSelect(int[] t, int n, int k) {
        int[] U = new int[n];
        int[] V = new int[n];
        int p = t[k - 1];
        int u = 0;
        int v = 0;
        int indV = 0;
        for (int i = 0; i < n; ++i) {
            if (t[i] <= p) {
                ++v;
                if (t[i] == p) continue;
                U[u++] = t[i];
                continue;
            }
            V[indV++] = t[i];
        }
        if (k <= u) {
            return Misc.quickSelect(U, u, k);
        }
        if (k > v) {
            return Misc.quickSelect(V, indV, k - v);
        }
        return p;
    }

    public static int getTimeInterval(double[] times, int start, int end, double t) {
        if (start < 0) {
            throw new IllegalArgumentException("The starting index must not be negative");
        }
        int n = end - start;
        if (n < 0) {
            throw new IllegalArgumentException("The ending index must be greater than or equal to the starting index");
        }
        if (t < times[start]) {
            return -1;
        }
        if (t >= times[end]) {
            return n;
        }
        int start0 = start;
        int mid = (start + end) / 2;
        while (t < times[mid] || t >= times[mid + 1]) {
            if (start == end) {
                throw new IllegalStateException();
            }
            if (t < times[mid]) {
                end = mid - 1;
            } else {
                start = mid + 1;
            }
            mid = (start + end) / 2;
        }
        return mid - start0;
    }

    public static void interpol(int n, double[] X, double[] Y, double[] C) {
        int j;
        for (j = 0; j <= n; ++j) {
            C[j] = Y[j];
        }
        for (int i = 1; i <= n; ++i) {
            for (j = n; j >= i; --j) {
                C[j] = (C[j] - C[j - 1]) / (X[j] - X[j - i]);
            }
        }
    }

    public static double evalPoly(int n, double[] X, double[] C, double z) {
        double v = C[n];
        for (int j = n - 1; j >= 0; --j) {
            v = v * (z - X[j]) + C[j];
        }
        return v;
    }
}

