/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.NonParsableException;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.BayesianNetworkTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhomogeneousDGTrainSM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.StructureLearner;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.parameters.IDGTrainSMParameterSet;

public class BayesianNetworkTrainSMParameterSet
extends IDGTrainSMParameterSet {
    public BayesianNetworkTrainSMParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    public BayesianNetworkTrainSMParameterSet() {
        super((Class<? extends InhomogeneousDGTrainSM>)BayesianNetworkTrainSM.class);
        this.addParameters();
    }

    public BayesianNetworkTrainSMParameterSet(AlphabetContainer alphabet, int length, double ess, String description, StructureLearner.ModelType model, byte order, StructureLearner.LearningType method) throws Exception {
        super((Class<? extends InhomogeneousDGTrainSM>)BayesianNetworkTrainSM.class, alphabet, length, ess, description);
        this.addParameters();
        ((Parameter)this.parameters.get(2)).setValue((Object)model);
        ((Parameter)this.parameters.get(3)).setValue(order);
        ((Parameter)this.parameters.get(4)).setValue((Object)method);
    }

    private void addParameters() {
        try {
            this.parameters.add(new Parameter[]{new EnumParameter(StructureLearner.ModelType.class, "the standard model that should be learned", true)});
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BYTE, "Markov order", "the used markov order is the number of used dependencies for (each) random variable", true, new NumberValidator<Byte>((byte)0, (byte)127))});
            this.parameters.add(new Parameter[]{new EnumParameter(StructureLearner.LearningType.class, "the learning method for the parameters of the model", true)});
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
    }

    public void setModelType(String modelType) throws SimpleParameter.IllegalValueException {
        ((Parameter)this.parameters.get(2)).setValue(modelType);
    }

    @Override
    public String getInstanceComment() {
        return "a Bayesian Network model (i.e. inhomogeneous Markov model (iMM), permuted Markov model (pMM) or Bayesian network (BN)) with user-specified order";
    }

    public String getModelInstanceName() {
        return BayesianNetworkTrainSMParameterSet.getModelInstanceName((StructureLearner.ModelType)((Object)((Parameter)this.parameters.get(2)).getValue()), (Byte)((Parameter)this.parameters.get(3)).getValue(), (StructureLearner.LearningType)((Object)((Parameter)this.parameters.get(4)).getValue()), (Double)((Parameter)this.parameters.get(0)).getValue());
    }
}

