/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.randvar.NormalGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.StochasticProcess;

public class OrnsteinUhlenbeckProcess
extends StochasticProcess {
    protected NormalGen gen;
    protected double alpha;
    protected double beta;
    protected double sigma;
    protected double[] alphadt;
    protected double[] sigmasqrdt;

    public OrnsteinUhlenbeckProcess(double x0, double alpha, double b, double sigma, RandomStream stream) {
        this(x0, alpha, b, sigma, new NormalGen(stream, new NormalDist()));
    }

    public OrnsteinUhlenbeckProcess(double x0, double alpha, double b, double sigma, NormalGen gen) {
        this.alpha = alpha;
        this.beta = b;
        this.sigma = sigma;
        this.x0 = x0;
        this.gen = gen;
    }

    public double nextObservation() {
        double xOld = this.path[this.observationIndex];
        double x = xOld + (this.beta - xOld) * this.alphadt[this.observationIndex] + this.sigmasqrdt[this.observationIndex] * this.gen.nextDouble();
        ++this.observationIndex;
        this.path[this.observationIndex] = x;
        return x;
    }

    public double nextObservation(double nextTime) {
        double x;
        double previousTime = this.t[this.observationIndex];
        double xOld = this.path[this.observationIndex];
        ++this.observationIndex;
        this.t[this.observationIndex] = nextTime;
        double dt = nextTime - previousTime;
        this.path[this.observationIndex] = x = xOld + this.alpha * (this.beta - xOld) * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
        return x;
    }

    public double nextObservation(double x, double dt) {
        x = x + this.alpha * (this.beta - x) * dt + this.sigma * Math.sqrt(dt) * this.gen.nextDouble();
        return x;
    }

    public double[] generatePath() {
        double xOld = this.x0;
        for (int j = 0; j < this.d; ++j) {
            double x;
            this.path[j + 1] = x = xOld + (this.beta - xOld) * this.alphadt[j] + this.sigmasqrdt[j] * this.gen.nextDouble();
            xOld = x;
        }
        this.observationIndex = this.d;
        return this.path;
    }

    public double[] generatePath(RandomStream stream) {
        this.gen.setStream(stream);
        return this.generatePath();
    }

    public void setParams(double x0, double alpha, double b, double sigma) {
        this.alpha = alpha;
        this.beta = b;
        this.sigma = sigma;
        this.x0 = x0;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public void setStream(RandomStream stream) {
        this.gen.setStream(stream);
    }

    public RandomStream getStream() {
        return this.gen.getStream();
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getB() {
        return this.beta;
    }

    public double getSigma() {
        return this.sigma;
    }

    public NormalGen getGen() {
        return this.gen;
    }

    protected void init() {
        super.init();
        this.alphadt = new double[this.d];
        this.sigmasqrdt = new double[this.d];
        for (int j = 0; j < this.d; ++j) {
            double dt = this.t[j + 1] - this.t[j];
            this.alphadt[j] = this.alpha * dt;
            this.sigmasqrdt[j] = this.sigma * Math.sqrt(dt);
        }
    }
}

