/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class ArbitrarySequence
extends Sequence<double[]> {
    private double[] content;

    public ArbitrarySequence(AlphabetContainer alphabetContainer, double ... content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        this.content = new double[content.length];
        int i = 0;
        while (i < content.length) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
            ++i;
        }
    }

    private ArbitrarySequence(AlphabetContainer cont, SequenceAnnotation[] annotation, double ... content) {
        super(cont, annotation);
        this.content = content;
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, new SymbolExtractor(sequence, alphabetContainer.getDelim()));
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException, IllegalArgumentException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, ArbitrarySequence.checkDelim(alphabetContainer, delim)));
    }

    private static String checkDelim(AlphabetContainer alphabetContainer, String delim) throws IllegalArgumentException {
        if (!alphabetContainer.isDiscrete() && delim.length() == 0) {
            throw new IllegalArgumentException("The emtpy delimiter is forbidden for non discrete AlphabetContainers.");
        }
        return delim;
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        this.content = new double[extractor.countElements()];
        int k = 0;
        while (k < this.content.length) {
            this.content[k] = alphabetContainer.getCode(k, extractor.nextElement());
            ++k;
        }
    }

    @Override
    public double continuousVal(int pos) {
        return this.content[pos];
    }

    @Override
    public int discreteVal(int pos) {
        return this.toDiscrete(pos, this.content[pos]);
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    protected ArbitrarySequence flatCloneWithoutAnnotation() {
        try {
            return new ArbitrarySequence(this.alphabetCon, null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }

    @Override
    public boolean isMultiDimensional() {
        return false;
    }

    @Override
    public double[] getEmptyContainer() {
        return new double[1];
    }

    @Override
    public void fillContainer(double[] container, int pos) {
        container[0] = this.continuousVal(pos);
    }

    @Override
    public int compareTo(double[] t1, double[] t2) {
        if (t1.length == 1 && t2.length == 1) {
            return (int)Math.signum(t1[0] - t2[0]);
        }
        return t1.length - t2.length;
    }

    @Override
    protected Object getEmptyRepresentation() {
        return new StringBuffer();
    }

    @Override
    protected void addToRepresentation(Object representation, int pos, String delim) {
        ((StringBuffer)representation).append(String.valueOf(this.alphabetCon.getSymbol(pos, this.continuousVal(pos))) + delim);
    }

    @Override
    protected String getStringRepresentation(Object representation) {
        return representation.toString();
    }

    @Override
    protected int hashCodeForPos(int pos) {
        long bits = Double.doubleToLongBits(this.continuousVal(pos));
        return (int)(bits ^ bits >>> 32);
    }
}

