/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.FileManager;
import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.results.Result;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.NormalizedDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.StrandDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.motif.ExtendedZOOPSDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.REnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import projects.dispom.FileAssigner;
import projects.dispom.FileComparator;

public class DispomEvaluator {
    private static String getConsensus(AlphabetContainer con, double[][] pwm) {
        String c = "";
        int l = 0;
        while (l < pwm.length) {
            int m = 0;
            int p = 1;
            while (p < pwm[l].length) {
                if (pwm[l][m] < pwm[l][p]) {
                    m = p;
                }
                ++p;
            }
            c = String.valueOf(c) + con.getSymbol(l, m);
            ++l;
        }
        return c;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Arrays.toString(args));
        double sign = 0.001;
        if (args.length == 6) {
            sign = Double.parseDouble(args[5]);
        }
        REnvironment r = null;
        try {
            r = new REnvironment("localhost", "", "");
            r.voidEval("require( seqLogo );");
        }
        catch (Exception e) {
            System.out.println("Could not open local Rserve-connection.");
        }
        try {
            ArrayList<AbstractMap.SimpleEntry<String, double[][]>> list = PFMComparator.readPFMsFromEMBL("./transfac.dat", Integer.MAX_VALUE);
            File f = new File(args[0]);
            System.out.println(f.getAbsolutePath());
            File[] all = f.listFiles(new RegExFilenameFilter("xml", RegExFilenameFilter.Directory.FORBIDDEN, true, ".*\\.xml"));
            System.out.println("files: " + all.length);
            Arrays.sort(all, new FileComparator());
            FileAssigner fa = new FileAssigner();
            char ignore = args[3].charAt(0);
            Object[] fNames = new String[2];
            int j = 0;
            while (j < all.length) {
                double current;
                double best = Double.NEGATIVE_INFINITY;
                int idx = -1;
                do {
                    if (!((current = DispomEvaluator.infos(null, args[1], all[j], false, null, null, ignore, sign, null)) > best)) continue;
                    best = current;
                    idx = j;
                } while (++j < all.length && fa.compare(all[j - 1], all[j]) == 0);
                if (idx <= -1) continue;
                System.out.println("---------------------------------------------------------------------------------");
                FileManager.copy(all[idx].getAbsolutePath(), String.valueOf(args[1]) + "/" + all[idx].getName());
                String n = all[idx].getName();
                n = n.substring(n.indexOf("classifier-") + 11, n.indexOf("-" + args[4]));
                System.out.println(n);
                n = DispomEvaluator.replace(n);
                System.out.println(n);
                int x = -1;
                do {
                    if ((x = n.indexOf("-", x + 1)) > 0) {
                        fNames[0] = String.valueOf(args[2]) + "/" + n.substring(0, x);
                        fNames[1] = String.valueOf(args[2]) + "/" + n.substring(x + 1);
                    }
                    System.out.println(String.valueOf(x) + "\t" + fNames[0] + "\t" + fNames[1]);
                } while (x >= 0 && (!new File(fNames[0]).exists() || !new File((String)fNames[1]).exists()));
                if (x < 0) {
                    System.out.println(n);
                    System.out.println("Problem: " + x);
                    System.exit(1);
                } else {
                    System.out.println(Arrays.toString(fNames));
                }
                n = all[idx].getName();
                x = n.indexOf("-" + args[4]);
                String e = "length-";
                int xx = n.indexOf(e, x);
                xx = n.indexOf("-", xx + e.length());
                n = n.substring(x, xx).replaceAll("_", "-");
                current = DispomEvaluator.infos(r, args[1], all[idx], true, list, (String[])fNames, ignore, sign, n);
                System.out.println("=================================================================================");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (r != null) {
            r.close();
        }
    }

    private static String replace(String n) {
        int x = -1;
        do {
            int y;
            if ((x = n.indexOf("[", x + 1)) < 0 || (y = n.indexOf("]", x)) <= -1) continue;
            System.out.println(n.substring(x, y));
            n = String.valueOf(n.substring(0, x)) + n.substring(x, y).replaceAll("-", ",") + n.substring(y);
        } while (x > -1);
        return n;
    }

    private static double infos(REnvironment r, String home, File f, boolean show, ArrayList<AbstractMap.SimpleEntry<String, double[][]>> list, String[] fName, char ignore, double sign, String suffix) throws Exception {
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(f));
        ExtendedZOOPSDiffSM md = (ExtendedZOOPSDiffSM)cl.getDifferentiableSequenceScore(0);
        if (show) {
            System.out.println();
            System.out.println(md);
        }
        double current = cl.getLastScore();
        System.out.print(String.valueOf(f.getName()) + "\t" + current);
        double[][][] pwm = new double[md.getNumberOfMotifs()][][];
        int m = 0;
        while (m < pwm.length) {
            DifferentiableStatisticalModel nsf = md.getFunction(2 * m);
            StrandDiffSM strand = nsf instanceof NormalizedDiffSM ? (StrandDiffSM)((NormalizedDiffSM)nsf).getFunction() : (StrandDiffSM)nsf;
            BayesianNetworkDiffSM motif = (BayesianNetworkDiffSM)strand.getFunction(0);
            pwm[m] = motif.getPWM();
            System.out.print("\t" + md.getMotifLength(m) + "\t" + DispomEvaluator.getConsensus(cl.getAlphabetContainer(), pwm[m]));
            ++m;
        }
        System.out.println();
        if (list != null) {
            int last = fName[0].lastIndexOf("/");
            int m2 = 0;
            while (m2 < pwm.length) {
                DNAAlphabet dna = DNAAlphabet.SINGLETON;
                System.out.println("parameter PWM");
                System.out.println(PFMComparator.matrixToString(pwm[m2]));
                ComparableElement<String, Double>[] ce = PFMComparator.find(dna, pwm[m2], list, new PFMComparator.NormalizedEuclideanDistance(), 7, 2, false, 0.24);
                int i = 0;
                while (i < ce.length) {
                    System.out.println(String.valueOf(i) + "\t" + ce[i].getWeight() + "\t" + ce[i].getElement());
                    ++i;
                }
                System.out.println("-+-+-+-+-+-+-+-+-+-+-");
                File bg = new File(fName[1]);
                SignificantMotifOccurrencesFinder smof = bg.exists() ? new SignificantMotifOccurrencesFinder(md, new DataSet(md.getAlphabetContainer(), new SparseStringExtractor(fName[1], ignore)), null, sign) : new SignificantMotifOccurrencesFinder((MotifDiscoverer)md, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, sign);
                DataSet data = new DataSet(md.getAlphabetContainer(), new SparseStringExtractor(fName[0], ignore));
                DataSet motifs = smof.getBindingSites(data, m2);
                if (motifs != null) {
                    System.out.println("(" + motifs.getNumberOfElements() + " BS vs. " + (bg.exists() ? "bg" : "permuted") + ", " + sign + ")");
                    pwm[m2] = PFMComparator.getPFM(motifs);
                    ce = PFMComparator.find(dna, pwm[m2], list, new PFMComparator.NormalizedEuclideanDistance(), 7, 2, false, 0.24);
                    System.out.println("binding site PFM ");
                    System.out.println(PFMComparator.matrixToString(pwm[m2]));
                    int i2 = 0;
                    while (i2 < ce.length) {
                        System.out.println(String.valueOf(i2) + "\t" + ce[i2].getWeight() + "\t" + ce[i2].getElement());
                        ++i2;
                    }
                    System.out.println("-+-+-+-+-+-+-+-+-+-+-");
                    if (r != null) {
                        r.createMatrix("pwm", pwm[m2]);
                        String name0 = fName[0].substring(last + 1).replaceAll("[,._]", "-");
                        String name1 = fName[1].substring(last + 1).replaceAll("[,._]", "-");
                        String name = String.valueOf(name0) + suffix + "-" + m2;
                        r.voidEval("print(pwm);pwm<-apply(pwm,1,function(x){x/sum(x)});print(pwm);");
                        r.plotToPDF("seqLogo(pwm);", 8.0, 3.0, String.valueOf(home) + "/seqLogo-" + name + ".pdf", true);
                        pwm[m2] = PFMComparator.getReverseComplement(dna, pwm[m2]);
                        r.createMatrix("pwm", pwm[m2]);
                        r.voidEval("print(pwm);pwm<-apply(pwm,1,function(x){x/sum(x)});print(pwm);");
                        r.plotToPDF("seqLogo(pwm);", 8.0, 3.0, String.valueOf(home) + "/seqLogo-" + name + "-rc.pdf", true);
                        int l = md.getLength();
                        String posCmd = String.valueOf(md.getFunction(2 * m2 + 1).toString()) + "\n" + "h=hist(pos,breaks=seq(0," + l + ",by=10),plot=F);\n" + "plot(0,0,col=0,xlim=c(0," + l + "),ylim=c(0,max(p,h$density)),xlab=\"Position\",ylab=\"Density\",main=\"\",axes=F,cex.lab=1.25);\n" + "L=" + l + ";z=seq(0,L-1,by=50);at=c(z,L-1);z=z-L;z[z%%100!=0]=\"\";x=c(z,-1);axis(1,at,x,cex.axis=1.25);axis(2,cex.axis=1.25);" + "plot(h,freq=F,add=T);\n" + "lines(l,p,col=2);";
                        IntList pos = smof.getStartPositions(0, data, m2, Integer.MAX_VALUE);
                        r.createVector("pos", pos.toArray());
                        System.out.println(String.valueOf(home) + "/position-" + name + ".pdf");
                        r.plotToPDF(posCmd, 8.0, 5.0, String.valueOf(home) + "/position-" + name + ".pdf", true);
                    }
                } else {
                    System.out.println("no binding sites predicted");
                }
                ++m2;
            }
        }
        return current;
    }

    private static DataSet addPosition(DataSet data, String posFileName, int length) throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(posFileName));
        Sequence[] seqs = data.getAllElements();
        int i = 0;
        while (i < seqs.length) {
            String line = r.readLine().trim();
            if (!line.equalsIgnoreCase("na")) {
                seqs[i] = seqs[i].annotate(false, new MotifAnnotation("motif 0", Integer.parseInt(line) - 1, length, StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN, new Result[0]));
            }
            ++i;
        }
        r.close();
        return new DataSet("annotated " + data.getAnnotation(), seqs);
    }
}

