/*
 * Decompiled with CFR 0.152.
 */
package supplementary.cookbook.recipes;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.data.DNADataSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.AbstractHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.HMMFactory;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.BaumWelchParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.HMMTrainingParameterSet;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;

public class DeNovoSunflower {
    public static void main(String[] args) throws Exception {
        DNADataSet data = new DNADataSet(args[0]);
        BaumWelchParameterSet pars = new BaumWelchParameterSet(10, new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors());
        AbstractHMM hmm = HMMFactory.createSunflowerHMM((HMMTrainingParameterSet)pars, data.getAlphabetContainer(), 0.0, data.getElementLength(), true, 8, 12);
        hmm.train(data);
        System.out.println(hmm);
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Pair<IntList, Double> p = hmm.getViterbiPathFor(data.getElementAt(i));
            System.out.println(p.getSecondElement() + "\t" + p.getFirstElement());
            ++i;
        }
    }
}

