/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.RootFinder;

public class WatsonGDist
extends ContinuousDistribution {
    protected int n;
    private static double[] YWA = new double[143];
    private static double[] MWA = new double[143];
    private static double[] CoWA = new double[143];

    public WatsonGDist(int n) {
        this.setN(n);
    }

    public double density(double x) {
        return WatsonGDist.density(this.n, x);
    }

    public double cdf(double x) {
        return WatsonGDist.cdf(this.n, x);
    }

    public double barF(double x) {
        return WatsonGDist.barF(this.n, x);
    }

    public double inverseF(double u) {
        return WatsonGDist.inverseF(this.n, u);
    }

    public static double density(int n, double x) {
        double Res;
        double MINARG = 0.15;
        double MAXARG = 1.5;
        if (n < 2) {
            throw new IllegalArgumentException("n < 2");
        }
        if (x <= 0.15 || x >= 1000.0) {
            return 0.0;
        }
        if (x > 1.5) {
            Res = 20.0 * Math.exp(19.0 - 20.0 * x) - 15.26 * Math.exp(13.34 - 15.26 * x) / Math.sqrt(n);
        } else {
            double EPS = 0.05;
            Res = (WatsonGDist.cdf(n, x + 0.05) - WatsonGDist.cdf(n, x - 0.05)) / 0.1;
        }
        if (Res <= 0.0) {
            return 0.0;
        }
        return Res;
    }

    public static double cdf(int n, double x) {
        if (n <= 1) {
            throw new IllegalArgumentException("n < 2");
        }
        double MINARG = 0.15;
        if (x <= 0.15) {
            return 0.0;
        }
        if (x >= 10.0) {
            return 1.0;
        }
        double MAXARG = 1.5;
        if (x > 1.5) {
            double R = Math.exp(19.0 - 20.0 * x);
            double Res = 1.0 - R;
            R = Math.exp(13.34 - 15.26 * x) / Math.sqrt(n);
            if ((Res += R) >= 1.0) {
                return 1.0;
            }
            return Res;
        }
        double MINTAB = 0.1;
        double STEP = 0.01;
        int i = (int)((x - 0.1) / 0.01 + 1.0);
        double Ti = 0.1 + (double)i * 0.01;
        double Tj = Ti - 0.01;
        int j = i - 1;
        double H = x - Tj;
        double R = Ti - x;
        double P = 1.6666666666666667E-5;
        double Res = (MWA[j] * R * R * R + MWA[i] * H * H * H) / 6.0 / 0.01;
        Res += ((YWA[j] - MWA[j] * P) * R + (YWA[i] - MWA[i] * P) * H) / 0.01;
        if ((Res += (CoWA[i] * H + CoWA[j] * R) / (0.01 * Math.sqrt(n))) >= 1.0) {
            return 1.0;
        }
        return Res;
    }

    public static double barF(int n, double x) {
        return 1.0 - WatsonGDist.cdf(n, x);
    }

    public static double inverseF(int n, double u) {
        if (n <= 1) {
            throw new IllegalArgumentException("n < 2");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (u == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u == 0.0) {
            return 0.0;
        }
        Function f = new Function(n, u);
        return RootFinder.brentDekker(0.0, 10.0, f, 1.0E-5);
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 1) {
            throw new IllegalArgumentException("n < 2");
        }
        this.n = n;
        this.supportA = 0.0;
        this.supportB = 10.0;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.n};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : n = " + this.n;
    }

    static {
        WatsonGDist.YWA[0] = 1.8121832847E-39;
        WatsonGDist.YWA[1] = 2.0503176304E-32;
        WatsonGDist.YWA[2] = 4.6139577764E-27;
        WatsonGDist.YWA[3] = 6.5869745929E-23;
        WatsonGDist.YWA[4] = 1.2765816107E-19;
        WatsonGDist.YWA[5] = 5.6251923105E-17;
        WatsonGDist.YWA[6] = 8.0747150511E-15;
        WatsonGDist.YWA[7] = 4.8819994144E-13;
        WatsonGDist.YWA[8] = 1.4996052497E-11;
        WatsonGDist.YWA[9] = 2.6903519441E-10;
        WatsonGDist.YWA[10] = 3.1322929018E-9;
        WatsonGDist.YWA[11] = 2.5659643046E-8;
        WatsonGDist.YWA[12] = 1.5749759318E-7;
        WatsonGDist.YWA[13] = 7.6105096466E-7;
        WatsonGDist.YWA[14] = 3.0113293541E-6;
        WatsonGDist.YWA[15] = 1.0070166837E-5;
        WatsonGDist.YWA[16] = 2.9199826692E-5;
        WatsonGDist.YWA[17] = 7.4970409372E-5;
        WatsonGDist.YWA[18] = 1.7340586581E-4;
        WatsonGDist.YWA[19] = 3.6654236297E-4;
        WatsonGDist.YWA[20] = 7.165864865E-4;
        WatsonGDist.YWA[21] = 0.0013087767385;
        WatsonGDist.YWA[22] = 0.0022522044209;
        WatsonGDist.YWA[23] = 0.0036781862572;
        WatsonGDist.YWA[24] = 0.0057361958631;
        WatsonGDist.YWA[25] = 0.0085877444706;
        WatsonGDist.YWA[26] = 0.0123988738;
        WatsonGDist.YWA[27] = 0.0173320516;
        WatsonGDist.YWA[28] = 0.0235382479;
        WatsonGDist.YWA[29] = 0.0311498548;
        WatsonGDist.YWA[30] = 0.0402749297;
        WatsonGDist.YWA[31] = 0.0509930445;
        WatsonGDist.YWA[32] = 0.0633528333;
        WatsonGDist.YWA[33] = 0.0773711747;
        WatsonGDist.YWA[34] = 0.0930338324;
        WatsonGDist.YWA[35] = 0.110297306;
        WatsonGDist.YWA[36] = 0.1290916098;
        WatsonGDist.YWA[37] = 0.1493236984;
        WatsonGDist.YWA[38] = 0.1708812741;
        WatsonGDist.YWA[39] = 0.1936367476;
        WatsonGDist.YWA[40] = 0.2174511609;
        WatsonGDist.YWA[41] = 0.242177928;
        WatsonGDist.YWA[42] = 0.2676662852;
        WatsonGDist.YWA[43] = 0.2937643828;
        WatsonGDist.YWA[44] = 0.3203219784;
        WatsonGDist.YWA[45] = 0.3471927188;
        WatsonGDist.YWA[46] = 0.3742360163;
        WatsonGDist.YWA[47] = 0.4013185392;
        WatsonGDist.YWA[48] = 0.4283153467;
        WatsonGDist.YWA[49] = 0.4551107027;
        WatsonGDist.YWA[50] = 0.4815986082;
        WatsonGDist.YWA[51] = 0.5076830902;
        WatsonGDist.YWA[52] = 0.5332782852;
        WatsonGDist.YWA[53] = 0.5583083531;
        WatsonGDist.YWA[54] = 0.5827072528;
        WatsonGDist.YWA[55] = 0.6064184099;
        WatsonGDist.YWA[56] = 0.6293943006;
        WatsonGDist.YWA[57] = 0.6515959739;
        WatsonGDist.YWA[58] = 0.6729925313;
        WatsonGDist.YWA[59] = 0.6935605784;
        WatsonGDist.YWA[60] = 0.7132836621;
        WatsonGDist.YWA[61] = 0.7321517033;
        WatsonGDist.YWA[62] = 0.7501604333;
        WatsonGDist.YWA[63] = 0.7673108406;
        WatsonGDist.YWA[64] = 0.7836086337;
        WatsonGDist.YWA[65] = 0.799063723;
        WatsonGDist.YWA[66] = 0.8136897251;
        WatsonGDist.YWA[67] = 0.8275034914;
        WatsonGDist.YWA[68] = 0.8405246632;
        WatsonGDist.YWA[69] = 0.8527752531;
        WatsonGDist.YWA[70] = 0.8642792535;
        WatsonGDist.YWA[71] = 0.8750622738;
        WatsonGDist.YWA[72] = 0.8851512032;
        WatsonGDist.YWA[73] = 0.8945739017;
        WatsonGDist.YWA[74] = 0.9033589176;
        WatsonGDist.YWA[75] = 0.9115352296;
        WatsonGDist.YWA[76] = 0.919132015;
        WatsonGDist.YWA[77] = 0.9261784413;
        WatsonGDist.YWA[78] = 0.9327034806;
        WatsonGDist.YWA[79] = 0.9387357465;
        WatsonGDist.YWA[80] = 0.944303351;
        WatsonGDist.YWA[81] = 0.9494337813;
        WatsonGDist.YWA[82] = 0.9541537951;
        WatsonGDist.YWA[83] = 0.9584893325;
        WatsonGDist.YWA[84] = 0.9624654445;
        WatsonGDist.YWA[85] = 0.9661062352;
        WatsonGDist.YWA[86] = 0.9694348183;
        WatsonGDist.YWA[87] = 0.9724732859;
        WatsonGDist.YWA[88] = 0.9752426872;
        WatsonGDist.YWA[89] = 0.9777630186;
        WatsonGDist.YWA[90] = 0.9800532221;
        WatsonGDist.YWA[91] = 0.9821311912;
        WatsonGDist.YWA[92] = 0.9840137844;
        WatsonGDist.YWA[93] = 0.985716844;
        WatsonGDist.YWA[94] = 0.9872552203;
        WatsonGDist.YWA[95] = 0.9886428002;
        WatsonGDist.YWA[96] = 0.9898925389;
        WatsonGDist.YWA[97] = 0.9910164946;
        WatsonGDist.YWA[98] = 0.9920258656;
        WatsonGDist.YWA[99] = 0.9929310287;
        WatsonGDist.YWA[100] = 0.9937415788;
        WatsonGDist.YWA[101] = 0.9944663692;
        WatsonGDist.YWA[102] = 0.995113552;
        WatsonGDist.YWA[103] = 0.9956906185;
        WatsonGDist.YWA[104] = 0.9962044387;
        WatsonGDist.YWA[105] = 0.9966613009;
        WatsonGDist.YWA[106] = 0.9970669496;
        WatsonGDist.YWA[107] = 0.9974266225;
        WatsonGDist.YWA[108] = 0.9977450862;
        WatsonGDist.YWA[109] = 0.9980266707;
        WatsonGDist.YWA[110] = 0.9982753021;
        WatsonGDist.YWA[111] = 0.9984945338;
        WatsonGDist.YWA[112] = 0.998687576;
        WatsonGDist.YWA[113] = 0.998857324;
        WatsonGDist.YWA[114] = 0.9990063842;
        WatsonGDist.YWA[115] = 0.9991370993;
        WatsonGDist.YWA[116] = 0.9992515708;
        WatsonGDist.YWA[117] = 0.999351681;
        WatsonGDist.YWA[118] = 0.9994391129;
        WatsonGDist.YWA[119] = 0.9995153688;
        WatsonGDist.YWA[120] = 0.9995817875;
        WatsonGDist.YWA[121] = 0.9996395602;
        WatsonGDist.YWA[122] = 0.9996897446;
        WatsonGDist.YWA[123] = 0.9997332791;
        WatsonGDist.YWA[124] = 0.9997709943;
        WatsonGDist.YWA[125] = 0.9998036243;
        WatsonGDist.YWA[126] = 0.9998318172;
        WatsonGDist.YWA[127] = 0.9998561438;
        WatsonGDist.YWA[128] = 0.9998771066;
        WatsonGDist.YWA[129] = 0.9998951466;
        WatsonGDist.YWA[130] = 0.9999106508;
        WatsonGDist.YWA[131] = 0.999923958;
        WatsonGDist.YWA[132] = 0.9999353645;
        WatsonGDist.YWA[133] = 0.9999451288;
        WatsonGDist.YWA[134] = 0.9999534765;
        WatsonGDist.YWA[135] = 0.9999606035;
        WatsonGDist.YWA[136] = 0.9999666805;
        WatsonGDist.YWA[137] = 0.9999718553;
        WatsonGDist.YWA[138] = 0.9999762562;
        WatsonGDist.YWA[139] = 0.9999799939;
        WatsonGDist.YWA[140] = 0.9999831643;
        WatsonGDist.YWA[141] = 0.9999858;
        WatsonGDist.YWA[142] = 0.9999883;
        WatsonGDist.MWA[0] = 0.0;
        WatsonGDist.MWA[1] = 6.909E-15;
        WatsonGDist.MWA[2] = 2.763E-14;
        WatsonGDist.MWA[3] = 1.036E-13;
        WatsonGDist.MWA[4] = 3.792E-13;
        WatsonGDist.MWA[5] = 4.773E-12;
        WatsonGDist.MWA[6] = 4.59E-10;
        WatsonGDist.MWA[7] = 2.649E-8;
        WatsonGDist.MWA[8] = 7.353E-7;
        WatsonGDist.MWA[9] = 1.14E-5;
        WatsonGDist.MWA[10] = 1.102E-4;
        WatsonGDist.MWA[11] = 7.276E-4;
        WatsonGDist.MWA[12] = 0.003538;
        WatsonGDist.MWA[13] = 0.01342;
        WatsonGDist.MWA[14] = 0.04157;
        WatsonGDist.MWA[15] = 0.1088;
        WatsonGDist.MWA[16] = 0.2474;
        WatsonGDist.MWA[17] = 0.4999;
        WatsonGDist.MWA[18] = 0.913;
        WatsonGDist.MWA[19] = 1.53;
        WatsonGDist.MWA[20] = 2.381;
        WatsonGDist.MWA[21] = 3.475;
        WatsonGDist.MWA[22] = 4.795;
        WatsonGDist.MWA[23] = 6.3;
        WatsonGDist.MWA[24] = 7.928;
        WatsonGDist.MWA[25] = 9.602;
        WatsonGDist.MWA[26] = 11.24;
        WatsonGDist.MWA[27] = 12.76;
        WatsonGDist.MWA[28] = 14.1;
        WatsonGDist.MWA[29] = 15.18;
        WatsonGDist.MWA[30] = 15.98;
        WatsonGDist.MWA[31] = 16.47;
        WatsonGDist.MWA[32] = 16.64;
        WatsonGDist.MWA[33] = 16.49;
        WatsonGDist.MWA[34] = 16.05;
        WatsonGDist.MWA[35] = 15.35;
        WatsonGDist.MWA[36] = 14.41;
        WatsonGDist.MWA[37] = 13.28;
        WatsonGDist.MWA[38] = 12.0;
        WatsonGDist.MWA[39] = 10.6;
        WatsonGDist.MWA[40] = 9.13;
        WatsonGDist.MWA[41] = 7.618;
        WatsonGDist.MWA[42] = 6.095;
        WatsonGDist.MWA[43] = 4.588;
        WatsonGDist.MWA[44] = 3.122;
        WatsonGDist.MWA[45] = 1.713;
        WatsonGDist.MWA[46] = 0.3782;
        WatsonGDist.MWA[47] = -0.8726;
        WatsonGDist.MWA[48] = -2.031;
        WatsonGDist.MWA[49] = -3.091;
        WatsonGDist.MWA[50] = -4.051;
        WatsonGDist.MWA[51] = -4.91;
        WatsonGDist.MWA[52] = -5.668;
        WatsonGDist.MWA[53] = -6.327;
        WatsonGDist.MWA[54] = -6.893;
        WatsonGDist.MWA[55] = -7.367;
        WatsonGDist.MWA[56] = -7.756;
        WatsonGDist.MWA[57] = -8.064;
        WatsonGDist.MWA[58] = -8.297;
        WatsonGDist.MWA[59] = -8.46;
        WatsonGDist.MWA[60] = -8.56;
        WatsonGDist.MWA[61] = -8.602;
        WatsonGDist.MWA[62] = -8.591;
        WatsonGDist.MWA[63] = -8.533;
        WatsonGDist.MWA[64] = -8.433;
        WatsonGDist.MWA[65] = -8.296;
        WatsonGDist.MWA[66] = -8.127;
        WatsonGDist.MWA[67] = -7.93;
        WatsonGDist.MWA[68] = -7.709;
        WatsonGDist.MWA[69] = -7.469;
        WatsonGDist.MWA[70] = -7.212;
        WatsonGDist.MWA[71] = -6.943;
        WatsonGDist.MWA[72] = -6.663;
        WatsonGDist.MWA[73] = -6.378;
        WatsonGDist.MWA[74] = -6.087;
        WatsonGDist.MWA[75] = -5.795;
        WatsonGDist.MWA[76] = -5.503;
        WatsonGDist.MWA[77] = -5.213;
        WatsonGDist.MWA[78] = -4.927;
        WatsonGDist.MWA[79] = -4.646;
        WatsonGDist.MWA[80] = -4.371;
        WatsonGDist.MWA[81] = -4.103;
        WatsonGDist.MWA[82] = -3.843;
        WatsonGDist.MWA[83] = -3.593;
        WatsonGDist.MWA[84] = -3.352;
        WatsonGDist.MWA[85] = -3.12;
        WatsonGDist.MWA[86] = -2.899;
        WatsonGDist.MWA[87] = -2.689;
        WatsonGDist.MWA[88] = -2.489;
        WatsonGDist.MWA[89] = -2.3;
        WatsonGDist.MWA[90] = -2.121;
        WatsonGDist.MWA[91] = -1.952;
        WatsonGDist.MWA[92] = -1.794;
        WatsonGDist.MWA[93] = -1.645;
        WatsonGDist.MWA[94] = -1.506;
        WatsonGDist.MWA[95] = -1.377;
        WatsonGDist.MWA[96] = -1.256;
        WatsonGDist.MWA[97] = -1.144;
        WatsonGDist.MWA[98] = -1.041;
        WatsonGDist.MWA[99] = -0.9449;
        WatsonGDist.MWA[100] = -0.8564;
        WatsonGDist.MWA[101] = -0.775;
        WatsonGDist.MWA[102] = -0.7001;
        WatsonGDist.MWA[103] = -0.6315;
        WatsonGDist.MWA[104] = -0.5687;
        WatsonGDist.MWA[105] = -0.5113;
        WatsonGDist.MWA[106] = -0.459;
        WatsonGDist.MWA[107] = -0.4114;
        WatsonGDist.MWA[108] = -0.3681;
        WatsonGDist.MWA[109] = -0.3289;
        WatsonGDist.MWA[110] = -0.2934;
        WatsonGDist.MWA[111] = -0.2614;
        WatsonGDist.MWA[112] = -0.2325;
        WatsonGDist.MWA[113] = -0.2064;
        WatsonGDist.MWA[114] = -0.183;
        WatsonGDist.MWA[115] = -0.1621;
        WatsonGDist.MWA[116] = -0.1433;
        WatsonGDist.MWA[117] = -0.1265;
        WatsonGDist.MWA[118] = -0.1115;
        WatsonGDist.MWA[119] = -0.09813;
        WatsonGDist.MWA[120] = -0.08624;
        WatsonGDist.MWA[121] = -0.07569;
        WatsonGDist.MWA[122] = -0.06632;
        WatsonGDist.MWA[123] = -0.05803;
        WatsonGDist.MWA[124] = -0.05071;
        WatsonGDist.MWA[125] = -0.04424;
        WatsonGDist.MWA[126] = -0.03855;
        WatsonGDist.MWA[127] = -0.03353;
        WatsonGDist.MWA[128] = -0.02914;
        WatsonGDist.MWA[129] = -0.02528;
        WatsonGDist.MWA[130] = -0.0219;
        WatsonGDist.MWA[131] = -0.01894;
        WatsonGDist.MWA[132] = -0.01637;
        WatsonGDist.MWA[133] = -0.01412;
        WatsonGDist.MWA[134] = -0.01217;
        WatsonGDist.MWA[135] = -0.01046;
        WatsonGDist.MWA[136] = -0.008988;
        WatsonGDist.MWA[137] = -0.00772;
        WatsonGDist.MWA[138] = -0.006567;
        WatsonGDist.MWA[139] = -0.005802;
        WatsonGDist.MWA[140] = -0.0053;
        WatsonGDist.MWA[141] = -4.7E-4;
        WatsonGDist.MWA[142] = -4.3E-4;
        for (int j = 5; j <= 11; ++j) {
            WatsonGDist.CoWA[j] = 0.0;
        }
        WatsonGDist.CoWA[12] = 1.25E-5;
        WatsonGDist.CoWA[13] = 3.87E-5;
        WatsonGDist.CoWA[14] = 1.004E-4;
        WatsonGDist.CoWA[15] = 2.703E-4;
        WatsonGDist.CoWA[16] = 6.507E-4;
        WatsonGDist.CoWA[17] = 0.0013985;
        WatsonGDist.CoWA[18] = 0.0028353;
        WatsonGDist.CoWA[19] = 0.0051911;
        WatsonGDist.CoWA[20] = 0.0089486;
        WatsonGDist.CoWA[21] = 0.0141773;
        WatsonGDist.CoWA[22] = 0.0216551;
        WatsonGDist.CoWA[23] = 0.031489;
        WatsonGDist.CoWA[24] = 0.0434123;
        WatsonGDist.CoWA[25] = 0.0578719;
        WatsonGDist.CoWA[26] = 0.0746921;
        WatsonGDist.CoWA[27] = 0.0945265;
        WatsonGDist.CoWA[28] = 0.1165183;
        WatsonGDist.CoWA[29] = 0.1406353;
        WatsonGDist.CoWA[30] = 0.1662849;
        WatsonGDist.CoWA[31] = 0.1929895;
        WatsonGDist.CoWA[32] = 0.2189347;
        WatsonGDist.CoWA[33] = 0.2457772;
        WatsonGDist.CoWA[34] = 0.2704794;
        WatsonGDist.CoWA[35] = 0.2947906;
        WatsonGDist.CoWA[36] = 0.3169854;
        WatsonGDist.CoWA[37] = 0.3377435;
        WatsonGDist.CoWA[38] = 0.3573555;
        WatsonGDist.CoWA[39] = 0.3751205;
        WatsonGDist.CoWA[40] = 0.3906829;
        WatsonGDist.CoWA[41] = 0.4039806;
        WatsonGDist.CoWA[42] = 0.4142483;
        WatsonGDist.CoWA[43] = 0.422779;
        WatsonGDist.CoWA[44] = 0.4288013;
        WatsonGDist.CoWA[45] = 0.4330353;
        WatsonGDist.CoWA[46] = 0.434452;
        WatsonGDist.CoWA[47] = 0.4338138;
        WatsonGDist.CoWA[48] = 0.431504;
        WatsonGDist.CoWA[49] = 0.4272541;
        WatsonGDist.CoWA[50] = 0.4220568;
        WatsonGDist.CoWA[51] = 0.4158229;
        WatsonGDist.CoWA[52] = 0.4083281;
        WatsonGDist.CoWA[53] = 0.3981182;
        WatsonGDist.CoWA[54] = 0.3871678;
        WatsonGDist.CoWA[55] = 0.3755527;
        WatsonGDist.CoWA[56] = 0.3628823;
        WatsonGDist.CoWA[57] = 0.3520135;
        WatsonGDist.CoWA[58] = 0.3400924;
        WatsonGDist.CoWA[59] = 0.3280532;
        WatsonGDist.CoWA[60] = 0.3139477;
        WatsonGDist.CoWA[61] = 0.2997087;
        WatsonGDist.CoWA[62] = 0.2849179;
        WatsonGDist.CoWA[63] = 0.2710475;
        WatsonGDist.CoWA[64] = 0.2576478;
        WatsonGDist.CoWA[65] = 0.2449155;
        WatsonGDist.CoWA[66] = 0.2317447;
        WatsonGDist.CoWA[67] = 0.2193161;
        WatsonGDist.CoWA[68] = 0.2072622;
        WatsonGDist.CoWA[69] = 0.1956955;
        WatsonGDist.CoWA[70] = 0.1846514;
        WatsonGDist.CoWA[71] = 0.1734096;
        WatsonGDist.CoWA[72] = 0.1622678;
        WatsonGDist.CoWA[73] = 0.1520447;
        WatsonGDist.CoWA[74] = 0.1416351;
        WatsonGDist.CoWA[75] = 0.132136;
        WatsonGDist.CoWA[76] = 0.1231861;
        WatsonGDist.CoWA[77] = 0.1150411;
        WatsonGDist.CoWA[78] = 0.1071536;
        WatsonGDist.CoWA[79] = 0.099465;
        WatsonGDist.CoWA[80] = 0.0922347;
        WatsonGDist.CoWA[81] = 0.0854394;
        WatsonGDist.CoWA[82] = 0.0787697;
        WatsonGDist.CoWA[83] = 0.0723848;
        WatsonGDist.CoWA[84] = 0.066587;
        WatsonGDist.CoWA[85] = 0.0615849;
        WatsonGDist.CoWA[86] = 0.056573;
        WatsonGDist.CoWA[87] = 0.0517893;
        WatsonGDist.CoWA[88] = 0.0470011;
        WatsonGDist.CoWA[89] = 0.042886;
        WatsonGDist.CoWA[90] = 0.0391224;
        WatsonGDist.CoWA[91] = 0.0353163;
        WatsonGDist.CoWA[92] = 0.0320884;
        WatsonGDist.CoWA[93] = 0.0292264;
        WatsonGDist.CoWA[94] = 0.0266058;
        WatsonGDist.CoWA[95] = 0.0237352;
        WatsonGDist.CoWA[96] = 0.0214669;
        WatsonGDist.CoWA[97] = 0.0194848;
        WatsonGDist.CoWA[98] = 0.0175591;
        WatsonGDist.CoWA[99] = 0.0158232;
        WatsonGDist.CoWA[100] = 0.0140302;
        WatsonGDist.CoWA[101] = 0.0124349;
        WatsonGDist.CoWA[102] = 0.0111856;
        WatsonGDist.CoWA[103] = 0.0099765;
        WatsonGDist.CoWA[104] = 0.0089492;
        WatsonGDist.CoWA[105] = 0.0080063;
        WatsonGDist.CoWA[106] = 0.0071509;
        WatsonGDist.CoWA[107] = 0.0063196;
        WatsonGDist.CoWA[108] = 0.0056856;
        WatsonGDist.CoWA[109] = 0.0050686;
        WatsonGDist.CoWA[110] = 0.0045085;
        WatsonGDist.CoWA[111] = 0.0039895;
        WatsonGDist.CoWA[112] = 0.0034804;
        WatsonGDist.CoWA[113] = 0.0030447;
        WatsonGDist.CoWA[114] = 0.0027012;
        WatsonGDist.CoWA[115] = 0.0022984;
        WatsonGDist.CoWA[116] = 0.0020283;
        WatsonGDist.CoWA[117] = 0.0017399;
        WatsonGDist.CoWA[118] = 0.0015032;
        WatsonGDist.CoWA[119] = 0.0013267;
        WatsonGDist.CoWA[120] = 0.0011531;
        WatsonGDist.CoWA[121] = 9.92E-4;
        WatsonGDist.CoWA[122] = 9.211E-4;
        WatsonGDist.CoWA[123] = 8.296E-4;
        WatsonGDist.CoWA[124] = 6.991E-4;
        WatsonGDist.CoWA[125] = 5.84E-4;
        WatsonGDist.CoWA[126] = 5.12E-4;
        WatsonGDist.CoWA[127] = 4.314E-4;
        WatsonGDist.CoWA[128] = 3.593E-4;
        WatsonGDist.CoWA[129] = 3.014E-4;
        WatsonGDist.CoWA[130] = 2.401E-4;
        WatsonGDist.CoWA[131] = 2.004E-4;
        WatsonGDist.CoWA[132] = 1.614E-4;
        WatsonGDist.CoWA[133] = 1.257E-4;
        WatsonGDist.CoWA[134] = 1.112E-4;
        WatsonGDist.CoWA[135] = 9.22E-5;
        WatsonGDist.CoWA[136] = 8.77E-5;
        WatsonGDist.CoWA[137] = 6.22E-5;
        WatsonGDist.CoWA[138] = 4.93E-5;
        WatsonGDist.CoWA[139] = 3.92E-5;
        WatsonGDist.CoWA[140] = 3.15E-5;
        WatsonGDist.CoWA[141] = 1.03E-5;
        WatsonGDist.CoWA[142] = 9.6E-6;
    }

    private static class Function
    implements MathFunction {
        protected int n;
        protected double u;

        public Function(int n, double u) {
            this.n = n;
            this.u = u;
        }

        public double evaluate(double x) {
            return this.u - WatsonGDist.cdf(this.n, x);
        }
    }
}

