/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.io.SymbolExtractor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import javax.naming.OperationNotSupportedException;

public final class SparseSequence
extends SimpleDiscreteSequence {
    private static final int MAX_NUMBER_OF_SYMBOLS_IN_ONE_LONG = 32;
    private static final int LOG_MAX_NUMBER = 5;
    private static final int MAX_NUMBER_MINUS_ONE = 31;
    private int length;
    private long[] content;

    public SparseSequence(AlphabetContainer alphCon, String seq) throws WrongSequenceTypeException, WrongAlphabetException {
        this(alphCon, new SymbolExtractor(seq, alphCon.getDelim()));
    }

    public SparseSequence(AlphabetContainer alphCon, SymbolExtractor se) throws WrongSequenceTypeException, WrongAlphabetException {
        this(alphCon, se.countElements(), null);
        if (!alphCon.isSimple() || alphCon.getAlphabetLengthAt(0) != 4.0) {
            throw new WrongSequenceTypeException();
        }
        DiscreteAlphabet abc = (DiscreteAlphabet)alphCon.getAlphabetAt(0);
        int index = 0;
        int l = 0;
        while (l < this.length) {
            this.content[index] = 0L;
            int j = 0;
            while (j < 32 && l < this.length) {
                int n = index;
                this.content[n] = this.content[n] + ((long)abc.getCode(se.nextElement()) << 2 * j);
                ++j;
                ++l;
            }
            ++index;
        }
    }

    private SparseSequence(AlphabetContainer con, int length, SequenceAnnotation[] annotation) throws WrongAlphabetException {
        super(con, annotation);
        this.length = length;
        this.content = new long[length / 32 + (length % 32 > 0 ? 1 : 0)];
    }

    @Override
    public int discreteVal(int pos) {
        if (pos < 0 || pos >= this.length) {
            throw new IndexOutOfBoundsException("The index " + pos + " is out of bounds [0," + this.length + "]");
        }
        return (int)(this.content[pos >> 5] >> ((pos & 0x1F) << 1) & 3L);
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public SparseSequence complement(int start, int end) throws OperationNotSupportedException {
        if (this.alphabetCon.isReverseComplementable()) {
            SparseSequence erg;
            try {
                erg = new SparseSequence(this.alphabetCon, end - start, null);
            }
            catch (WrongAlphabetException e) {
                throw new RuntimeException(e.getMessage());
            }
            ComplementableDiscreteAlphabet compAbc = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            int l = start;
            int index = 0;
            while (l < end) {
                erg.content[index] = 0L;
                int j = 0;
                while (j < 32 && l < end) {
                    int n = index;
                    erg.content[n] = erg.content[n] + ((long)compAbc.getComplementaryCode(this.discreteVal(l)) << 2 * j);
                    ++j;
                    ++l;
                }
                ++index;
            }
            return erg;
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    public SparseSequence reverse(int start, int end) throws OperationNotSupportedException {
        SparseSequence erg;
        try {
            erg = new SparseSequence(this.alphabetCon, end - start, null);
        }
        catch (WrongAlphabetException e) {
            throw new RuntimeException(e.getMessage());
        }
        int l = end - 1;
        int index = 0;
        while (l >= start) {
            erg.content[index] = 0L;
            int j = 0;
            while (j < 32 && l >= start) {
                int n = index;
                erg.content[n] = erg.content[n] + ((long)this.discreteVal(l) << 2 * j);
                ++j;
                --l;
            }
            ++index;
        }
        return erg;
    }

    @Override
    public SparseSequence reverseComplement(int start, int end) throws OperationNotSupportedException {
        if (this.rc != null && start == 0 && end == this.getLength()) {
            return (SparseSequence)this.rc;
        }
        if (this.alphabetCon.isReverseComplementable()) {
            SparseSequence erg;
            try {
                erg = new SparseSequence(this.alphabetCon, end - start, null);
            }
            catch (WrongAlphabetException e) {
                throw new RuntimeException(e.getMessage());
            }
            ComplementableDiscreteAlphabet compAbc = (ComplementableDiscreteAlphabet)this.alphabetCon.getAlphabetAt(0);
            int l = end - 1;
            int index = 0;
            while (l >= start) {
                erg.content[index] = 0L;
                int j = 0;
                while (j < 32 && l >= start) {
                    int n = index;
                    erg.content[n] = erg.content[n] + ((long)compAbc.getComplementaryCode(this.discreteVal(l)) << 2 * j);
                    ++j;
                    --l;
                }
                ++index;
            }
            if (start == 0 && end == this.getLength()) {
                this.rc = erg;
                erg.rc = this;
            }
            return erg;
        }
        throw new OperationNotSupportedException("The alphabet of sequence has to be complementable.");
    }

    @Override
    protected SparseSequence flatCloneWithoutAnnotation() {
        try {
            SparseSequence erg = new SparseSequence(this.alphabetCon, this.length, null);
            erg.content = this.content;
            return erg;
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }

    public static DataSet getDataSet(AlphabetContainer con, String filename, SequenceAnnotationParser parser) throws FileNotFoundException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IOException {
        return SparseSequence.getDataSet(con, new SparseStringExtractor(filename, '>', parser));
    }

    public static DataSet getDataSet(AlphabetContainer con, String filename) throws FileNotFoundException, WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException, IOException {
        return SparseSequence.getDataSet(con, new SparseStringExtractor(filename));
    }

    /*
     * Unable to fully structure code
     */
    public static final DataSet getDataSet(AlphabetContainer con, AbstractStringExtractor ... se) throws WrongSequenceTypeException, WrongAlphabetException, EmptyDataSetException {
        list = new LinkedList<SparseSequence>();
        symEx = new SymbolExtractor(con.getDelim());
        annot = null;
        i = 0;
        ** GOTO lbl17
        {
            seqAn = se[i].getCurrentSequenceAnnotations();
            s = (String)se[i].nextElement();
            symEx.setStringToBeParsed(s);
            x = new SparseSequence(con, symEx);
            x.annotation = seqAn;
            list.add(x);
            do {
                if (se[i].hasMoreElements()) continue block0;
                annot = i == 0 ? se[i].getAnnotation() : String.valueOf(annot) + ", " + se[i].getAnnotation();
                ++i;
lbl17:
                // 2 sources

            } while (i < se.length);
        }
        return new DataSet(annot, list.toArray(new Sequence[0]));
    }
}

