/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.DifferentiableEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.SamplingEmission;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import de.jstacs.utils.random.DiMRGParams;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.naming.OperationNotSupportedException;

public abstract class AbstractConditionalDiscreteEmission
implements SamplingEmission,
DifferentiableEmission {
    private double[] colors;
    protected File[] paramsFile;
    protected int[] counter;
    protected int samplingIndex;
    protected BufferedWriter writer;
    protected BufferedReader reader;
    protected int offset;
    protected AlphabetContainer con;
    protected double[][] params;
    protected double[][] probs;
    protected double[][] hyperParams;
    protected double[][] statistic;
    protected double[][] grad;
    protected double[] logNorm;
    protected double[] ess;
    private double[][] initHyperParams;
    private String shape;
    private boolean linear;
    private static final String XML_TAG = "ConditionalDiscreteEmission";

    protected static double[][] getHyperParams(double ess, int numConditions, int numEmissions) {
        double[] ess2 = new double[numConditions];
        Arrays.fill(ess2, ess / (double)numConditions);
        return AbstractConditionalDiscreteEmission.getHyperParams(ess2, numEmissions);
    }

    private static double[][] getHyperParams(double[] ess, int number) {
        double[][] res = new double[ess.length][number];
        int i = 0;
        while (i < res.length) {
            Arrays.fill(res[i], ess[i] / (double)number);
            ++i;
        }
        return res;
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, int numberOfConditions, double ess) {
        this(con, AbstractConditionalDiscreteEmission.getHyperParams(ess, numberOfConditions, (int)con.getAlphabetLengthAt(0)));
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, double[][] hyperParams) {
        this(con, hyperParams, hyperParams);
    }

    protected AbstractConditionalDiscreteEmission(AlphabetContainer con, double[][] hyperParams, double[][] initHyperParams) {
        this.con = con;
        this.ess = new double[hyperParams.length];
        this.hyperParams = new double[hyperParams.length][hyperParams[0].length];
        this.initHyperParams = hyperParams == initHyperParams ? this.hyperParams : new double[initHyperParams.length][initHyperParams[0].length];
        int i = 0;
        while (i < hyperParams.length) {
            int j = 0;
            while (j < hyperParams[i].length) {
                if (hyperParams[i][j] < 0.0) {
                    throw new IllegalArgumentException("Please check the hyper-parameter (" + i + ", " + j + ").");
                }
                this.hyperParams[i][j] = hyperParams[i][j];
                if (this.hyperParams != this.initHyperParams) {
                    this.initHyperParams[i][j] = initHyperParams[i][j];
                }
                int n = i;
                this.ess[n] = this.ess[n] + hyperParams[i][j];
                ++j;
            }
            ++i;
        }
        this.params = new double[hyperParams.length][hyperParams[0].length];
        this.probs = new double[hyperParams.length][hyperParams[0].length];
        this.statistic = new double[hyperParams.length][hyperParams[0].length];
        this.grad = new double[hyperParams.length][hyperParams[0].length];
        this.logNorm = new double[hyperParams.length];
        this.precompute();
    }

    protected AbstractConditionalDiscreteEmission(StringBuffer xml) throws NonParsableException {
        this.fromXML(xml);
    }

    public AbstractConditionalDiscreteEmission clone() throws CloneNotSupportedException {
        AbstractConditionalDiscreteEmission clone = (AbstractConditionalDiscreteEmission)super.clone();
        double[] dArray = clone.colors = this.colors == null ? null : (double[])this.colors.clone();
        if (this.counter != null) {
            clone.counter = (int[])this.counter.clone();
        }
        if (this.ess != null) {
            clone.ess = (double[])this.ess.clone();
        }
        if (this.grad != null) {
            clone.grad = (double[][])this.grad.clone();
        }
        clone.hyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.hyperParams);
        clone.initHyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.initHyperParams);
        if (this.logNorm != null) {
            clone.logNorm = (double[])this.logNorm.clone();
        }
        clone.params = (double[][])ArrayHandler.clone((Cloneable[])this.params);
        if (this.paramsFile != null) {
            clone.paramsFile = new File[this.paramsFile.length];
            try {
                int i = 0;
                while (i < this.paramsFile.length) {
                    if (this.paramsFile[i] != null) {
                        clone.paramsFile[i] = this.createFile();
                        FileManager.copy(this.paramsFile[i].getAbsolutePath(), clone.paramsFile[i].getAbsolutePath());
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                CloneNotSupportedException c = new CloneNotSupportedException(e.getMessage());
                c.setStackTrace(e.getStackTrace());
                throw c;
            }
        }
        clone.probs = (double[][])ArrayHandler.clone((Cloneable[])this.probs);
        clone.reader = null;
        clone.statistic = (double[][])ArrayHandler.clone((Cloneable[])this.statistic);
        clone.writer = null;
        return clone;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] gradient, int offset) {
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                int n = offset + this.offset;
                gradient[n] = gradient[n] + (this.hyperParams[i][j] - this.ess[i] * this.probs[i][j]);
                ++j;
                ++offset;
            }
            ++i;
        }
    }

    @Override
    public double getLogPriorTerm() {
        double res = 0.0;
        int i = 0;
        while (i < this.params.length) {
            if (this.ess[i] > 0.0) {
                res += -this.ess[i] * this.logNorm[i];
                int j = 0;
                while (j < this.params[i].length) {
                    res += this.hyperParams[i][j] * this.params[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    @Override
    public double getLogProbAndPartialDerivationFor(boolean forward, int startPos, int endPos, IntList indices, DoubleList partDer, Sequence seq) throws OperationNotSupportedException {
        int i;
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        int v = e - s + 1;
        double res = 0.0;
        int i2 = 0;
        while (i2 < this.grad.length) {
            Arrays.fill(this.grad[i2], 0.0);
            ++i2;
        }
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            if (condIdx < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            v = current.discreteVal(s++);
            res -= this.logNorm[condIdx];
            i = 0;
            while (i < this.grad[condIdx].length) {
                double[] dArray = this.grad[condIdx];
                int n = i;
                dArray[n] = dArray[n] - this.probs[condIdx][i];
                ++i;
            }
            res += this.params[condIdx][v];
            double[] dArray = this.grad[condIdx];
            int n = v;
            dArray[n] = dArray[n] + 1.0;
        }
        int myOff = 0;
        i = 0;
        while (i < this.grad.length) {
            int j = 0;
            while (j < this.grad[i].length) {
                indices.add(this.offset + myOff);
                partDer.add(this.grad[i][j]);
                ++j;
                ++myOff;
            }
            ++i;
        }
        return res;
    }

    @Override
    public double getLogProbFor(boolean forward, int startPos, int endPos, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        double res = 0.0;
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            if (condIdx < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            res -= this.logNorm[condIdx];
            res += this.params[condIdx][current.discreteVal(s++)];
        }
        return res;
    }

    @Override
    public void initializeFunctionRandomly() {
        this.drawParameters(this.initHyperParams, true);
    }

    protected void precompute() {
        Arrays.fill(this.logNorm, 0.0);
        int i = 0;
        while (i < this.params.length) {
            this.logNorm[i] = Normalisation.getLogSum(this.params[i]);
            int j = 0;
            while (j < this.params[i].length) {
                this.probs[i][j] = Math.exp(this.params[i][j] - this.logNorm[i]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.params, "params");
        XMLParser.appendObjectWithTags(xml, this.offset, "offset");
        XMLParser.appendObjectWithTags(xml, this.con, "alphabetContainer");
        XMLParser.appendObjectWithTags(xml, this.hyperParams, "hyperParams");
        XMLParser.appendObjectWithTags(xml, this.initHyperParams, "initHyperParams");
        XMLParser.appendObjectWithTags(xml, this.statistic, "statistic");
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        XMLParser.appendObjectWithTags(xml, this.shape, "shape");
        XMLParser.appendObjectWithTags(xml, this.linear, "linear");
        if (this.writer != null) {
            throw new RuntimeException("could not parse SamplingHigherOrderTransition to XML while sampling");
        }
        XMLParser.appendObjectWithTags(xml, this.paramsFile != null, "hasParameters");
        if (this.paramsFile != null) {
            try {
                XMLParser.appendObjectWithTags(xml, this.counter, "counter");
                int i = 0;
                while (i < this.paramsFile.length) {
                    String content = this.paramsFile[i] != null ? FileManager.readFile(this.paramsFile[i]).toString() : "";
                    XMLParser.appendObjectWithTagsAndAttributes(xml, content, "fileContent", "pos=\"" + i + "\"");
                    ++i;
                }
            }
            catch (IOException e) {
                RuntimeException r = new RuntimeException(e.getMessage());
                r.setStackTrace(e.getStackTrace());
                throw r;
            }
        }
        this.appendFurtherInformation(xml);
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    protected void appendFurtherInformation(StringBuffer xml) {
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, XML_TAG);
        this.params = (double[][])XMLParser.extractObjectForTags(xml, "params");
        this.probs = new double[this.params.length][this.params[0].length];
        this.grad = new double[this.params.length][this.params[0].length];
        this.logNorm = new double[this.params.length];
        this.precompute();
        this.offset = (Integer)XMLParser.extractObjectForTags(xml, "offset");
        this.con = (AlphabetContainer)XMLParser.extractObjectForTags(xml, "alphabetContainer");
        this.hyperParams = (double[][])XMLParser.extractObjectForTags(xml, "hyperParams");
        try {
            this.initHyperParams = (double[][])XMLParser.extractObjectForTags(xml, "initHyperParams");
        }
        catch (NonParsableException e) {
            try {
                this.initHyperParams = (double[][])ArrayHandler.clone((Cloneable[])this.hyperParams);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.statistic = (double[][])XMLParser.extractObjectForTags(xml, "statistic");
        this.ess = (double[])XMLParser.extractObjectForTags(xml, "ess");
        try {
            this.shape = XMLParser.extractObjectForTags(xml, "shape", String.class);
            this.linear = XMLParser.extractObjectForTags(xml, "linear", Boolean.TYPE);
        }
        catch (NonParsableException e) {
            this.shape = null;
            this.linear = false;
        }
        if (XMLParser.extractObjectForTags(xml, "hasParameters", Boolean.TYPE).booleanValue()) {
            this.counter = XMLParser.extractObjectForTags(xml, "counter", int[].class);
            this.paramsFile = new File[this.counter.length];
            try {
                TreeMap<String, String> filter = new TreeMap<String, String>();
                int i = 0;
                while (i < this.paramsFile.length) {
                    filter.clear();
                    filter.put("pos", "" + i);
                    String content = XMLParser.extractObjectAndAttributesForTags(xml, "fileContent", null, filter, String.class);
                    if (!content.equalsIgnoreCase("")) {
                        this.paramsFile[i] = this.createFile();
                        FileManager.writeFile(this.paramsFile[i], (CharSequence)new StringBuffer(content));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                NonParsableException n = new NonParsableException(e.getMessage());
                n.setStackTrace(e.getStackTrace());
                throw n;
            }
        } else {
            this.counter = null;
            this.paramsFile = null;
        }
        this.writer = null;
        this.reader = null;
        this.extractFurtherInformation(xml);
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    @Override
    public void joinStatistics(Emission ... emissions) {
        int j;
        int i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                j = 0;
                while (j < this.statistic.length) {
                    int k = 0;
                    while (k < this.statistic[j].length) {
                        double[] dArray = this.statistic[j];
                        int n = k;
                        dArray[n] = dArray[n] + ((AbstractConditionalDiscreteEmission)emissions[i]).statistic[j][k];
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < emissions.length) {
            if (emissions[i] != this) {
                j = 0;
                while (j < this.statistic.length) {
                    System.arraycopy(this.statistic[j], 0, ((AbstractConditionalDiscreteEmission)emissions[i]).statistic[j], 0, this.statistic[j].length);
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void addToStatistic(boolean forward, int startPos, int endPos, double weight, Sequence seq) throws OperationNotSupportedException {
        int e;
        int s;
        Sequence current;
        if (forward) {
            current = seq;
            s = startPos;
            e = endPos;
        } else {
            current = seq.reverseComplement();
            int len = current.getLength();
            s = len - endPos - 1;
            e = len - startPos - 1;
        }
        while (s <= e) {
            int condIdx = this.getConditionIndex(forward, s, seq);
            double[] dArray = this.statistic[condIdx];
            int n = current.discreteVal(s++);
            dArray[n] = dArray[n] + weight;
        }
    }

    protected abstract int getConditionIndex(boolean var1, int var2, Sequence var3);

    @Override
    public void estimateFromStatistic() {
        int j = 0;
        while (j < this.statistic.length) {
            double sum = 0.0;
            int i = 0;
            while (i < this.statistic[j].length) {
                double[] dArray = this.statistic[j];
                int n = i;
                dArray[n] = dArray[n] + this.hyperParams[j][i];
                sum += this.statistic[j][i];
                ++i;
            }
            if (sum == 0.0) {
                Arrays.fill(this.statistic[j], 1.0);
                sum = this.statistic[j].length;
            }
            i = 0;
            while (i < this.statistic[j].length) {
                this.probs[j][i] = this.statistic[j][i] / sum;
                this.params[j][i] = Math.log(this.probs[j][i]);
                ++i;
            }
            ++j;
        }
        Arrays.fill(this.logNorm, 0.0);
    }

    @Override
    public void resetStatistic() {
        int i = 0;
        while (i < this.hyperParams.length) {
            Arrays.fill(this.statistic[i], 0.0);
            ++i;
        }
    }

    @Override
    public void setParameter(double[] params, int offset) {
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                this.params[i][j] = params[this.offset + offset];
                ++j;
                ++offset;
            }
            ++i;
        }
        this.precompute();
    }

    @Override
    public AlphabetContainer getAlphabetContainer() {
        return this.con;
    }

    @Override
    public void fillCurrentParameter(double[] params) {
        int myOffset = this.offset;
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                params[myOffset] = this.params[i][j];
                ++j;
                ++myOffset;
            }
            ++i;
        }
    }

    @Override
    public int setParameterOffset(int offset) {
        this.offset = offset;
        int i = 0;
        while (i < this.params.length) {
            offset += this.params[i].length;
            ++i;
        }
        return offset;
    }

    protected void drawParameters(double[][] hyper, boolean uniformBackup) {
        int j = 0;
        while (j < this.probs.length) {
            double ess = 0.0;
            if (uniformBackup) {
                int i = 0;
                while (i < hyper[j].length) {
                    ess += hyper[j][i];
                    ++i;
                }
            }
            DiMRGParams p = uniformBackup && ess == 0.0 ? new FastDirichletMRGParams(1.0) : new DirichletMRGParams(hyper[j]);
            DirichletMRG.DEFAULT_INSTANCE.generateLog(this.params[j], 0, hyper[j].length, p);
            ++j;
        }
        this.precompute();
    }

    @Override
    public void drawParametersFromStatistic() {
        int j = 0;
        while (j < this.probs.length) {
            int i = 0;
            while (i < this.statistic[j].length) {
                this.params[i][j] = this.statistic[i][j] + this.hyperParams[i][j];
                ++i;
            }
            ++j;
        }
        this.drawParameters(this.params, false);
    }

    @Override
    public double getLogGammaScoreFromStatistic() {
        double[][] hyper = AbstractConditionalDiscreteEmission.getHyperParams(this.ess, (int)this.con.getAlphabetLengthAt(0));
        double res = Double.NEGATIVE_INFINITY;
        int j = 0;
        while (j < this.ess.length) {
            double sum = 0.0;
            double[] dArray = hyper[j];
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double i = dArray[n2];
                sum += i;
                ++n2;
            }
            res = Gamma.logOfGamma(sum);
            int i = 0;
            while (i < hyper.length) {
                res += Gamma.logOfGamma(this.statistic[j][i]) - Gamma.logOfGamma(hyper[j][i]);
                ++i;
            }
            sum = 0.0;
            dArray = this.statistic[j];
            n = dArray.length;
            n2 = 0;
            while (n2 < n) {
                double i2 = dArray[n2];
                sum += i2;
                ++n2;
            }
            res -= Gamma.logOfGamma(sum);
            ++j;
        }
        return res;
    }

    @Override
    public void acceptParameters() throws IOException {
        int n = this.samplingIndex;
        int n2 = this.counter[n];
        this.counter[n] = n2 + 1;
        this.writer.write("" + n2);
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                this.writer.write("\t" + this.params[i][j]);
                ++j;
            }
            ++i;
        }
        this.writer.write("\n");
        this.writer.flush();
    }

    @Override
    public double getLogPosteriorFromStatistic() {
        double logPost = 0.0;
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                logPost += this.statistic[i][j] * (this.params[i][j] - this.logNorm[i]);
                ++j;
            }
            ++i;
        }
        return logPost;
    }

    @Override
    public void extendSampling(int start, boolean append) throws IOException {
        if (this.paramsFile[start] == null) {
            this.paramsFile[start] = this.createFile();
        } else if (append) {
            this.parseParameterSet(start, this.counter[start] - 1);
            this.reader.close();
            this.reader = null;
        } else {
            this.counter[start] = 0;
        }
        this.writer = new BufferedWriter(new FileWriter(this.paramsFile[start], append));
        this.samplingIndex = start;
    }

    @Override
    public void initForSampling(int starts) throws IOException {
        int i = 0;
        while (i < this.hyperParams.length) {
            int j = 0;
            while (j < this.hyperParams[i].length) {
                if (!Double.isNaN(this.hyperParams[i][j]) && this.hyperParams[i][j] <= 0.0) {
                    throw new IllegalArgumentException("All (not NAN) hyper-parameters must have a value > 0. Please check the hyper-parameter " + i + ".");
                }
                ++j;
            }
            ++i;
        }
        if (this.paramsFile != null && this.paramsFile.length == starts) {
            int i2 = 0;
            while (i2 < starts) {
                if (this.paramsFile[i2] != null) {
                    FileOutputStream o = new FileOutputStream(this.paramsFile[i2]);
                    o.close();
                }
                this.counter[i2] = 0;
                ++i2;
            }
        } else {
            this.deleteParameterFiles();
            this.paramsFile = new File[starts];
            this.counter = new int[starts];
        }
    }

    private void deleteParameterFiles() {
        if (this.paramsFile != null) {
            int i = 0;
            while (i < this.paramsFile.length) {
                if (this.paramsFile[i] != null) {
                    this.paramsFile[i].delete();
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isInSamplingMode() {
        return this.writer != null;
    }

    @Override
    public boolean parseNextParameterSet() {
        String str;
        block9: {
            if (this.writer != null) {
                return false;
            }
            str = null;
            try {
                try {
                    str = this.reader.readLine();
                }
                catch (IOException iOException) {
                    if (str == null) {
                        return false;
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (str == null) {
                    return false;
                }
                throw throwable;
            }
            if (str == null) {
                return false;
            }
        }
        this.parse(str);
        return true;
    }

    @Override
    public boolean parseParameterSet(int start, int n) throws IOException {
        String str;
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new BufferedReader(new FileReader(this.paramsFile[start]));
        while ((str = this.reader.readLine()) != null) {
            if (Integer.parseInt(str.substring(0, str.indexOf("\t"))) != n) continue;
            this.parse(str);
            return true;
        }
        return false;
    }

    private void parse(String str) {
        String[] strArray = str.split("\t");
        int offset = 1;
        int i = 0;
        while (i < this.params.length) {
            int j = 0;
            while (j < this.params[i].length) {
                this.params[i][j] = Double.parseDouble(strArray[offset++]);
                this.probs[i][j] = Math.exp(this.params[i][j]);
                ++j;
            }
            this.logNorm[i] = 0.0;
            ++i;
        }
    }

    @Override
    public void samplingStopped() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.deleteParameterFiles();
        super.finalize();
    }

    @Override
    public String getNodeShape(boolean forward) {
        String res;
        if (this.shape == null) {
            res = "";
            if (this.getAlphabetContainer().isReverseComplementable()) {
                res = String.valueOf(res) + "\"house\", orientation=";
                if (forward) {
                    res = String.valueOf(res) + "-";
                }
                res = String.valueOf(res) + "90";
            } else {
                res = String.valueOf(res) + "\"box\"";
            }
        } else {
            res = "\"" + this.shape + "\"";
        }
        return res;
    }

    @Override
    public String getNodeLabel(double weight, String name, NumberFormat nf) {
        if (weight < 0.0) {
            return "\"" + name + "\"";
        }
        StringBuffer buf = new StringBuffer();
        String namelabel = name;
        if (weight < 0.5) {
            namelabel = "<font color=\"white\">" + namelabel + "</font>";
        }
        buf.append("<<table border=\"0\" cellspacing=\"0\"><tr><td colspan=\"" + ((this.probs.length > 1 ? 1 : 0) + this.probs[0].length) + "\">" + namelabel + "</td></tr>");
        DiscreteAlphabet abc = (DiscreteAlphabet)this.con.getAlphabetAt(0);
        buf.append("<tr>");
        if (this.probs.length > 1) {
            buf.append("<td></td>");
        }
        int j = 0;
        while (j < this.probs[0].length) {
            buf.append("<td border=\"0\">");
            if (weight < 0.5) {
                buf.append("<font color=\"white\">" + abc.getSymbolAt(j) + "</font>");
            } else {
                buf.append(abc.getSymbolAt(j));
            }
            buf.append("</td>");
            ++j;
        }
        buf.append("</tr>");
        int i = 0;
        while (i < this.probs.length) {
            buf.append("<tr>");
            if (this.probs.length > 1) {
                buf.append("<td border=\"0\">");
                if (weight < 0.5) {
                    buf.append("<font color=\"white\">" + abc.getSymbolAt(i) + "</font>");
                } else {
                    buf.append(abc.getSymbolAt(i));
                }
                buf.append("</td>");
            }
            double[] trans = this.transformProbs(this.probs[i]);
            double en = (this.getInformationContent(this.probs[i]) + 2.0) / 3.0;
            int j2 = 0;
            while (j2 < this.probs[i].length) {
                buf.append("<td border=\"1\" width=\"25\" height=\"25\" bgcolor=\"" + this.getColor(j2) + " " + trans[j2] + " " + en + "\">");
                if (nf != null) {
                    buf.append(nf.format(this.probs[i][j2]));
                }
                buf.append("</td>");
                ++j2;
            }
            buf.append("</tr>");
            ++i;
        }
        buf.append("</table>>");
        return buf.toString();
    }

    private double getColor(int j) {
        if (this.colors == null) {
            this.colors = ToolBox.getUniqueHueValues((int)this.con.getAlphabetLengthAt(0));
        }
        return this.colors[j];
    }

    public void setLinear(boolean linear) {
        this.linear = linear;
    }

    private double getInformationContent(double[] probs) {
        double max = Math.log(probs.length);
        double en = 0.0;
        int i = 0;
        while (i < probs.length) {
            if (probs[i] > 0.0) {
                en -= probs[i] * Math.log(probs[i]);
            }
            ++i;
        }
        return (max - en) / max;
    }

    private double[] transformProbs(double[] probs) {
        if (this.linear) {
            return (double[])probs.clone();
        }
        double[] trans = new double[probs.length];
        double a = 15.0;
        double b = 4.0;
        int i = 0;
        while (i < probs.length) {
            trans[i] = 1.0 / (1.0 + Math.exp(-a * probs[i] + b));
            ++i;
        }
        return trans;
    }

    @Override
    public void fillSamplingGroups(int parameterOffset, LinkedList<int[]> list) {
        int off = 0;
        int i = 0;
        while (i < this.params.length) {
            int[] idxs = new int[this.params[i].length];
            int j = 0;
            while (j < idxs.length) {
                idxs[j] = j + off + this.offset + parameterOffset;
                ++j;
            }
            list.add(idxs);
            off += idxs.length;
            ++i;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.params.length * this.params[0].length;
    }

    @Override
    public int getSizeOfEventSpace() {
        return this.params.length * this.params[0].length;
    }

    private File createFile() throws IOException {
        return File.createTempFile("samplingDEmission-", ".dat", null);
    }

    @Override
    public void setParameters(Emission t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass()) || ((AbstractConditionalDiscreteEmission)t).params.length != this.params.length) {
            throw new IllegalArgumentException("The transitions are not comparable.");
        }
        AbstractConditionalDiscreteEmission tt = (AbstractConditionalDiscreteEmission)t;
        int i = 0;
        while (i < this.params.length) {
            System.arraycopy(tt.params[i], 0, this.params[i], 0, tt.params[i].length);
            ++i;
        }
        this.precompute();
    }
}

