/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.StringTokenizer;

final class BlastLikeVersionSupport {
    public static final int UNKNOWN = 0;
    public static final int NCBI_BLASTN = 1;
    public static final int NCBI_BLASTP = 2;
    public static final int NCBI_BLASTX = 3;
    public static final int NCBI_TBLASTN = 4;
    public static final int NCBI_TBLASTX = 5;
    public static final int WU_BLASTN = 11;
    public static final int WU_BLASTP = 12;
    public static final int WU_BLASTX = 13;
    public static final int WU_TBLASTN = 14;
    public static final int WU_TBLASTX = 15;
    public static final int HMMER = 21;
    public static final int GCG = 31;
    public static final int GCG_BLASTN = 32;
    public static final int V2_0_11 = 100;
    public static final int V2_2_2 = 101;
    public static final int V2_2_3 = 102;
    public static final int V2_2_15 = 103;
    public static final int V2_0_10 = 150;
    public static final int V2_1_2 = 151;
    public static final int V2_0A19MP_WASHU = 200;
    public static final int V2_0 = 300;
    public static final int V2_1_1 = 301;
    public static final int STRICT = 0;
    public static final int LAZY = 1;
    private static int iMode = 0;
    private static int iProgram = 0;
    private static int iVersion = 0;
    private static String oProgramString = "unknown";
    private static String oVersionString = "unknown";
    private static String oProgramStub;

    public boolean isSupported() {
        if (iProgram == 1 || iProgram == 3 || iProgram == 2 || iProgram == 4 || iProgram == 5) {
            if (iVersion == 100 || iVersion == 101 || iVersion == 102 || iVersion == 103) {
                return true;
            }
            if (this.getMode() == 0) {
                return false;
            }
            if (this.getMode() == 1) {
                return true;
            }
        }
        if ((iProgram == 11 || iProgram == 13 || iProgram == 12 || iProgram == 14 || iProgram == 15) && iVersion == 200) {
            return true;
        }
        if (iProgram == 21 && (iVersion == 300 || iVersion == 301)) {
            return true;
        }
        if (iProgram == 32) {
            if (iVersion == 150 || iVersion == 151) {
                return true;
            }
            if (this.getMode() == 0) {
                return false;
            }
            if (this.getMode() == 1) {
                return true;
            }
        }
        if (this.getMode() == 0) {
            return false;
        }
        return this.getMode() == 1;
    }

    public boolean isStartOfDataSet(String poLine) {
        if (poLine.startsWith("BLAST") || poLine.startsWith("HMMER") || poLine.startsWith("TBLAST") || poLine.startsWith("!!")) {
            if (poLine.startsWith("!!")) {
                iProgram = 31;
            }
            return true;
        }
        return false;
    }

    public int getProgram() {
        return iProgram;
    }

    public int getVersion() {
        return iVersion;
    }

    public String getProgramString() {
        return oProgramString;
    }

    public String getVersionString() {
        return oVersionString;
    }

    public boolean assignProgramAndVersion(String poLine) {
        boolean tFormatFound = false;
        StringTokenizer oSt = new StringTokenizer(poLine);
        oProgramStub = oSt.nextToken().toLowerCase();
        oVersionString = oSt.nextToken().toLowerCase();
        if (oProgramStub.indexOf("blast") != -1) {
            oProgramString = oVersionString.indexOf("washu") == -1 ? (iProgram == 31 ? "gcg-".concat(oProgramStub) : "ncbi-".concat(oProgramStub)) : "wu-".concat(oProgramStub);
        }
        if (oProgramStub.indexOf("hmmer") != -1) {
            oProgramString = oProgramStub;
        }
        if (oProgramString.equals("ncbi-blastn")) {
            iProgram = 1;
            tFormatFound = true;
        }
        if (oProgramString.equals("ncbi-blastx")) {
            iProgram = 3;
            tFormatFound = true;
        }
        if (oProgramString.equals("ncbi-blastp")) {
            iProgram = 2;
            tFormatFound = true;
        }
        if (oProgramString.equals("ncbi-tblastn")) {
            iProgram = 4;
            tFormatFound = true;
        }
        if (oProgramString.equals("ncbi-tblastx")) {
            iProgram = 5;
            tFormatFound = true;
        }
        if (oVersionString.equals("2.0.11")) {
            iVersion = 100;
        }
        if (oVersionString.equals("2.2.2")) {
            iVersion = 101;
        }
        if (oVersionString.equals("2.2.3")) {
            iVersion = 102;
        }
        if (oVersionString.equals("2.2.15")) {
            iVersion = 103;
        }
        if (oProgramString.equals("wu-blastn")) {
            iProgram = 11;
            tFormatFound = true;
        }
        if (oProgramString.equals("wu-blastx")) {
            iProgram = 13;
            tFormatFound = true;
        }
        if (oProgramString.equals("wu-blastp")) {
            iProgram = 12;
            tFormatFound = true;
        }
        if (oProgramString.equals("wu-tblastn")) {
            iProgram = 14;
            tFormatFound = true;
        }
        if (oProgramString.equals("wu-tblastx")) {
            iProgram = 15;
            tFormatFound = true;
        }
        if (oVersionString.equals("2.0a19mp-washu")) {
            iVersion = 200;
            tFormatFound = true;
        }
        if (oProgramString.equals("hmmer")) {
            iProgram = 21;
            tFormatFound = true;
        }
        if (oVersionString.equals("2.0")) {
            iVersion = 300;
            tFormatFound = true;
        }
        if (oVersionString.equals("2.1.1")) {
            iVersion = 300;
            tFormatFound = true;
        }
        if (oProgramString.equals("gcg-blastn")) {
            iProgram = 32;
            tFormatFound = true;
        }
        if (oVersionString.equals("2.0.10")) {
            iVersion = 150;
        }
        if (oVersionString.equals("2.1.2")) {
            iVersion = 151;
        }
        return tFormatFound;
    }

    public void setMode(int piMode) {
        iMode = piMode;
    }

    public int getMode() {
        return iMode;
    }
}

