/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.DataType;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import projects.dispom.PositionDistribution;

class DispomParameterSet
extends ParameterSet {
    public static final String HOME = "home";
    public static final String IGNORE_CHAR = "ignore";
    public static final String FG = "fg";
    public static final String BG = "bg";
    public static final String MEAN = "mean";
    public static final String SD = "sd";
    public static final String LENGTH = "length";
    public static final String FLANKING_ORDER = "flankOrder";
    public static final String MOTIF_ORDER = "motifOrder";
    public static final String FORWARD_STRAND = "forwardStrand";
    public static final String INITIALIZE = "init";
    public static final String XML_PATH = "xml";
    public static final String ADJUST_LENGTH = "adjust";
    public static final String POSITION_DISTR = "position";
    public static final String LEARNING_PRINCIPLE_KEY = "learning";
    public static final String P_VALUE = "p-val";
    public static final String MOTIFS = "motifs";
    public static final String THREADS = "threads";
    public static final String HEURISTIC = "maxPos";
    public static final String STARTS = "starts";

    public DispomParameterSet() throws Exception {
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "home directory", "the path to the data directory", true, "./")});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.CHAR, "the ignore char for the data files", "the char that is used to mask comment lines in data files, e.g., '>' in a FASTA-file", true, Character.valueOf('>'))});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "foreground file", "the file name of the foreground data file (the file containing sequences which are expected to contain binding sites of a common motif)", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "background file", "the file name of the background data file", false)});
        this.parameters.add(new Parameter[]{new EnumParameter(PositionDistribution.class, "a switch whether to use uniform, skew-normal, or mixture position distribution", true, PositionDistribution.MIXTURE.name())});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, MEAN, "the mean of the a priori TFBS distribution", true, 250.0)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, SD, "the sd of the a priori TFBS distribution", true, new NumberValidator<Double>(1.0, Double.POSITIVE_INFINITY), 150.0)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "number of motifs", "the number of motifs to be searched for", true, new NumberValidator<Integer>(1, 5), 1)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "initial motif length", "the motif length that is used at the beginning", true, new NumberValidator<Integer>(1, 50), 15)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Markov order for flanking models", "the Markov order of the model for the flanking sequence and the background sequence", true, new NumberValidator<Integer>(-1, 5), 0)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "Markov order for motif model", "the Markov order of the motif model", true, new NumberValidator<Integer>(0, 3), 0)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "forward strand", "the probability for finding the binding sites on the forward strand, if not set this probability is inferred from the data", false, new NumberValidator<Double>(0.0, 1.0))});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "initialization method", "the method that is used for initialization, one of 'best-random=<number>', 'best-random-plugin=<number>', 'best-random-motif=<number>', 'enum-all=<length>', 'enum-data=<length>', 'heuristic=<number>', and 'specific=<sequence or file of sequences>'", true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "adjust motif length", "a switch whether to adjust the motif length, i.e., either to shrink or expand", true, true)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.BOOLEAN, "max pos heuristic", "a switch whether to use max. pos. in the heuristic or not", true, true)});
        this.parameters.add(new Parameter[]{new EnumParameter(LearningPrinciple.class, "a switch for the learning principle", true, LearningPrinciple.MSP.name())});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "compute threads", "the number of threads that are use to evaluate the objective function and its gradient", true, new NumberValidator<Integer>(1, 128), 4)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "starts of Dispom", "the number of independent starts of Dispom", true, new NumberValidator<Integer>(1, 100), 1)});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.STRING, "classifier xml-file", "the file name of the xml file containing the classifier", true, "./classifier.xml")});
        this.parameters.add(new Parameter[]{new SimpleParameter(DataType.DOUBLE, "p-value", "a p-value for predicting binding sites", false, new NumberValidator<Double>(0.0, 1.0))});
    }
}

