/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.gof;

import umontreal.iro.lecuyer.gof.FBar;
import umontreal.iro.lecuyer.util.Num;

public class FDist {
    protected static final double XINF = Double.MAX_VALUE;
    protected static final double XBIG = 1000.0;
    private static final double[] EPSARRAY = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18, 5.0E-19, 5.0E-20, 5.0E-21, 5.0E-22, 5.0E-23, 5.0E-24, 5.0E-25, 5.0E-26, 5.0E-27, 5.0E-28, 5.0E-29, 5.0E-30, 5.0E-31, 5.0E-32, 5.0E-33, 5.0E-34, 5.0E-35, 5.0E-36};
    private static double[] YWA = new double[143];
    private static double[] MWA = new double[143];
    private static double[] CoWA = new double[143];

    private FDist() {
    }

    private static double lowerTail(double Y) {
        if (Y > 0.571) {
            return 0.1 + (Y - 0.571) * 1.282051282;
        }
        if (Y > 0.52) {
            return 0.05 + (Y - 0.52) * 0.980392156;
        }
        if (Y > 0.481) {
            return 0.025 + (Y - 0.481) * 0.641025641;
        }
        if (Y > 0.441) {
            return 0.01 + (Y - 0.441) * 0.375;
        }
        return Y * 0.022675736;
    }

    @Deprecated
    public static double kolmogorovSmirnovPlus(int N, double x) {
        double EPSILON = 1.0E-290;
        double NXPARAM = 6.5;
        double NPARAM = 100.0;
        double Sum = 0.0;
        if (N <= 0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlus with N < 1");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= 1.0) {
            return 1.0;
        }
        if (N == 1) {
            return x;
        }
        double LogCom = Math.log(N);
        if ((double)N * x <= 6.5) {
            int jmax = (int)((double)N * x);
            int Sign = -1;
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = N - j;
                double q = jreal / (double)N - x;
                if (-q > 1.0E-290) {
                    double term = LogCom + jreal * Math.log(-q) + (Njreal - 1.0) * Math.log(1.0 - q);
                    Sum += (double)Sign * Math.exp(term);
                }
                Sign = -Sign;
                LogCom += Math.log(Njreal / (double)(j + 1));
            }
            return (Sum += Math.exp((double)(N - 1) * Math.log(1.0 + x))) * x;
        }
        if ((double)N < 100.0) {
            int jmax = (int)((double)N * (1.0 - x));
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = N - j;
                double q = jreal / (double)N + x;
                if (1.0 - q > 1.0E-290) {
                    double term = LogCom + (jreal - 1.0) * Math.log(q) + Njreal * Math.log(1.0 - q);
                    Sum += Math.exp(term);
                }
                LogCom += Math.log(Njreal / (jreal + 1.0));
            }
            Sum *= x;
            if (1.0 - x > 1.0E-290) {
                Sum += Math.exp((double)N * Math.log(1.0 - x));
            }
            return 1.0 - Sum;
        }
        double term = 0.6666666666666666;
        double q = x * x * (double)N;
        Sum = 1.0 - Math.exp(-2.0 * q) * (1.0 - term * x * (1.0 - x * (1.0 - term * q) - term / (double)N * (0.2 - 1.2666666666666666 * q + term * q * q)));
        return Sum;
    }

    @Deprecated
    public static double kolmogorovSmirnov(int N, double x) {
        if (x >= 1.0) {
            return 1.0;
        }
        if (x <= 0.5 / (double)N) {
            return 0.0;
        }
        if (N == 1) {
            return 2.0 * x - 1.0;
        }
        if (x <= 1.0 / (double)N) {
            double E2;
            double Res;
            double T = 2.0 * x - 1.0 / (double)N;
            if (N <= 170 && (Res = (E2 = Num.factorial(N)) * Math.pow(T, N)) > 0.0) {
                return Res;
            }
            E2 = Num.lnFactorial(N) + (double)N * Math.log(T);
            return Math.exp(E2);
        }
        if (x >= 1.0 - 1.0 / (double)N) {
            double E2 = 2.0 * Math.pow(1.0 - x, N);
            return 1.0 - E2;
        }
        double T = (double)(2 * N) * x * x;
        double E2 = Math.exp(-T);
        double E8 = Math.exp(-4.0 * T);
        double Res = 1.0 + (x * 4.0 / 3.0 - 2.0) * E2 + (2.0 - x * 8.0 / 3.0) * E8;
        double RacN = Math.sqrt(N);
        if (Res < 0.15 || x <= 0.441 / (RacN + 0.275 - 0.04 / RacN)) {
            Res = FDist.lowerTail(x * (RacN + 0.275 - 0.04 / RacN));
        }
        return Res;
    }

    public static double kolmogorovSmirnovPlusJumpOne(int N, double a, double x) {
        double EPSILONLR = 1.0E-15;
        double EPSILON = 1.0E-290;
        double NXAPARAM = 6.5;
        double Sum = 0.0;
        if (N < 1) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlusJumpOne with N < 1");
        }
        if (a >= 1.0 || a <= 0.0) {
            throw new IllegalArgumentException("Calling kolmogorovSmirnovPlusJumpOne with a outside (0, 1)");
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x + a >= 1.0) {
            return 1.0;
        }
        double LogCom = Math.log(N);
        if ((double)N * (x + a) < 6.5 && a + x < 0.5) {
            int jmax = (int)((double)N * (x + a));
            for (int j = 1; j <= jmax; ++j) {
                double jreal = j;
                double Njreal = N - j;
                double q = jreal / (double)N - x;
                int Sign = q < 0.0 && (j & 1) != 0 || q > 1.0 && (N - j - 1 & 1) != 0 ? -1 : 1;
                double q1 = Math.abs(q);
                double p1 = Math.abs(1.0 - q);
                if (q1 > 1.0E-290 && p1 > 1.0E-290) {
                    double term = LogCom + jreal * Math.log(q1) + (Njreal - 1.0) * Math.log(p1);
                    Sum += (double)Sign * Math.exp(term);
                }
                LogCom += Math.log(Njreal / (jreal + 1.0));
            }
            return (Sum += Math.exp((double)(N - 1) * Math.log(1.0 + x))) * x;
        }
        int jmax = (int)((double)N * (1.0 - a - x - 1.0E-15));
        for (int j = 1; j <= jmax; ++j) {
            double jreal = j;
            double Njreal = (double)N - jreal;
            double q = jreal / (double)N + x;
            if (1.0 - q > 1.0E-290) {
                double term = LogCom + (jreal - 1.0) * Math.log(q) + Njreal * Math.log(1.0 - q);
                Sum += Math.exp(term);
            }
            LogCom += Math.log(Njreal / (jreal + 1.0));
        }
        Sum *= x;
        if (1.0 - x > 1.0E-290) {
            Sum += Math.exp((double)N * Math.log(1.0 - x));
        }
        return 1.0 - Sum;
    }

    @Deprecated
    public static double cramerVonMises(int N, double x) {
        double termS;
        double EPSILON = 2.220446049250313E-16;
        int JMAX = 10;
        double[] A = new double[]{1.0, 1.11803398875, 1.125, 1.12673477358, 1.1274116945, 1.12774323743, 1.1279296875, 1.12804477649, 1.12812074678, 1.12817350091};
        if (N <= 0) {
            throw new IllegalArgumentException("N <= 0");
        }
        if (N == 1) {
            if (x <= 0.08333333333333333) {
                return 0.0;
            }
            if (x >= 0.3333333333333333) {
                return 1.0;
            }
            return 2.0 * Math.sqrt(x - 0.08333333333333333);
        }
        if (x <= 0.002 || x < 1.0 / (12.0 * (double)N)) {
            return 0.0;
        }
        if (x > 3.95) {
            return 1.0;
        }
        double termX = 0.0625 / x;
        double Res = 0.0;
        int j = 0;
        do {
            double termJ = 4 * j + 1;
            double arg = termJ * termJ * termX;
            termS = A[j] * Math.exp(-arg) * Num.besselK025(arg);
            Res += termS;
        } while (!(termS < 2.220446049250313E-16) && ++j <= 10);
        if (j > 10) {
            System.err.println("cramerVonMises: iterations have not converged");
        }
        Res /= Math.PI * Math.sqrt(x);
        double Cor = x < 0.0092 ? 0.0 : (x < 0.03 ? -0.0121763 + x * (2.56672 - 132.571 * x) : (x < 0.06 ? 0.108688 + x * (-7.14677 + 58.0662 * x) : (x < 0.19 ? -0.0539444 + x * (-2.22024 + x * (25.0407 - 64.9233 * x)) : (x < 0.5 ? -0.251455 + x * (2.46087 + x * (-8.92836 + x * (14.0988 - x * (5.5204 + 4.61784 * x)))) : (x <= 1.1 ? 0.0782122 + x * (-0.519924 + x * (1.75148 + x * (-2.72035 + x * (1.94487 - 0.524911 * x)))) : Math.exp(-0.244889 - 4.26506 * x))))));
        if ((Res += Cor / (double)N) < 1.0) {
            return Res;
        }
        return 1.0;
    }

    @Deprecated
    public static double watsonU(int N, double x) {
        double terme;
        double v;
        int JMAX = 10;
        double XSEPARE = 0.15;
        if (x <= 0.0) {
            return 0.0;
        }
        if (N < 2) {
            throw new IllegalArgumentException("N < 2");
        }
        if (x > 0.15) {
            double terme2;
            double v2 = Math.exp(-(x * 2.0 * Math.PI * Math.PI));
            double signe = -1.0;
            double somme = 0.0;
            int j = 1;
            do {
                terme2 = Math.pow(v2, (double)j * (double)j);
                somme += signe * terme2;
                signe = -signe;
            } while (!(terme2 < 2.220446049250313E-16) && ++j <= 10);
            if (j > 10) {
                System.err.println("watsonU:  sum1 has not converged");
            }
            return 2.0 * somme + 1.0;
        }
        double somme = v = Math.exp(-0.125 / x);
        int j = 2;
        do {
            terme = Math.pow(v, (double)(2 * j - 1) * (double)(2 * j - 1));
            somme += terme;
        } while (!(terme < v * 2.220446049250313E-16) && ++j <= 10);
        if (j > 10) {
            System.err.println("watsonU:  sum2 has not converged");
        }
        return 2.0 * somme / Math.sqrt(Math.PI * 2 * x);
    }

    private static double AD_N_1(double x) {
        double term;
        double AD_X0 = 0.38629436111989063;
        double AD_X1 = 37.816242111357;
        if (x <= 0.38629436111989063) {
            return 0.0;
        }
        if (x >= 37.816242111357) {
            return 1.0;
        }
        if (x - 0.38629436111989063 >= 0.001) {
            term = 1.0 - 4.0 * Math.exp(-x - 1.0);
        } else {
            double q = x - 0.38629436111989063;
            term = q * (1.0 - q * (0.5 - q / 6.0));
        }
        return Math.sqrt(term);
    }

    @Deprecated
    public static double watsonG(int N, double x) {
        double MINARG = 0.15;
        double MAXARG = 1.5;
        double MINTAB = 0.1;
        double STEP = 0.01;
        if (N < 2) {
            throw new IllegalArgumentException("N < 2");
        }
        if (x <= 0.15) {
            return 0.0;
        }
        if (x > 1.5) {
            double R = Math.exp(19.0 - 20.0 * x);
            double Res = 1.0 - R;
            R = Math.exp(13.34 - 15.26 * x) / Math.sqrt(N);
            if ((Res += R) > 1.0) {
                return 1.0;
            }
            return Res;
        }
        int i = (int)((x - 0.1) / 0.01 + 1.0);
        double Ti = 0.1 + (double)i * 0.01;
        double Tj = Ti - 0.01;
        int j = i - 1;
        double H = x - Tj;
        double R = Ti - x;
        double P = 1.6666666666666667E-5;
        double Res = (MWA[j] * R * R * R + MWA[i] * H * H * H) / 6.0 / 0.01;
        Res += ((YWA[j] - MWA[j] * P) * R + (YWA[i] - MWA[i] * P) * H) / 0.01;
        return Res += (CoWA[i] * H + CoWA[j] * R) / (0.01 * Math.sqrt(N));
    }

    @Deprecated
    public static double andersonDarling(int N, double x) {
        if (1 == N) {
            return FDist.AD_N_1(x);
        }
        if (x <= 0.0) {
            return 0.0;
        }
        if (x <= 0.2) {
            double q = 1.784 + 0.9936 * x + 0.03287 / x - (2.018 + 0.2029 / x) / Math.sqrt(x);
            if (q < -18.0) {
                return Math.exp(q);
            }
            q = 1.0 + Math.exp(q);
            return 1.0 - 1.0 / q;
        }
        return 1.0 - FBar.andersonDarling(N, x);
    }

    public static double scan(int N, double d, int m) {
        return 1.0 - FBar.scan(N, d, m);
    }

    static {
        FDist.YWA[0] = 1.8121832847E-39;
        FDist.YWA[1] = 2.0503176304E-32;
        FDist.YWA[2] = 4.6139577764E-27;
        FDist.YWA[3] = 6.5869745929E-23;
        FDist.YWA[4] = 1.2765816107E-19;
        FDist.YWA[5] = 5.6251923105E-17;
        FDist.YWA[6] = 8.0747150511E-15;
        FDist.YWA[7] = 4.8819994144E-13;
        FDist.YWA[8] = 1.4996052497E-11;
        FDist.YWA[9] = 2.6903519441E-10;
        FDist.YWA[10] = 3.1322929018E-9;
        FDist.YWA[11] = 2.5659643046E-8;
        FDist.YWA[12] = 1.5749759318E-7;
        FDist.YWA[13] = 7.6105096466E-7;
        FDist.YWA[14] = 3.0113293541E-6;
        FDist.YWA[15] = 1.0070166837E-5;
        FDist.YWA[16] = 2.9199826692E-5;
        FDist.YWA[17] = 7.4970409372E-5;
        FDist.YWA[18] = 1.7340586581E-4;
        FDist.YWA[19] = 3.6654236297E-4;
        FDist.YWA[20] = 7.165864865E-4;
        FDist.YWA[21] = 0.0013087767385;
        FDist.YWA[22] = 0.0022522044209;
        FDist.YWA[23] = 0.0036781862572;
        FDist.YWA[24] = 0.0057361958631;
        FDist.YWA[25] = 0.0085877444706;
        FDist.YWA[26] = 0.0123988738;
        FDist.YWA[27] = 0.0173320516;
        FDist.YWA[28] = 0.0235382479;
        FDist.YWA[29] = 0.0311498548;
        FDist.YWA[30] = 0.0402749297;
        FDist.YWA[31] = 0.0509930445;
        FDist.YWA[32] = 0.0633528333;
        FDist.YWA[33] = 0.0773711747;
        FDist.YWA[34] = 0.0930338324;
        FDist.YWA[35] = 0.110297306;
        FDist.YWA[36] = 0.1290916098;
        FDist.YWA[37] = 0.1493236984;
        FDist.YWA[38] = 0.1708812741;
        FDist.YWA[39] = 0.1936367476;
        FDist.YWA[40] = 0.2174511609;
        FDist.YWA[41] = 0.242177928;
        FDist.YWA[42] = 0.2676662852;
        FDist.YWA[43] = 0.2937643828;
        FDist.YWA[44] = 0.3203219784;
        FDist.YWA[45] = 0.3471927188;
        FDist.YWA[46] = 0.3742360163;
        FDist.YWA[47] = 0.4013185392;
        FDist.YWA[48] = 0.4283153467;
        FDist.YWA[49] = 0.4551107027;
        FDist.YWA[50] = 0.4815986082;
        FDist.YWA[51] = 0.5076830902;
        FDist.YWA[52] = 0.5332782852;
        FDist.YWA[53] = 0.5583083531;
        FDist.YWA[54] = 0.5827072528;
        FDist.YWA[55] = 0.6064184099;
        FDist.YWA[56] = 0.6293943006;
        FDist.YWA[57] = 0.6515959739;
        FDist.YWA[58] = 0.6729925313;
        FDist.YWA[59] = 0.6935605784;
        FDist.YWA[60] = 0.7132836621;
        FDist.YWA[61] = 0.7321517033;
        FDist.YWA[62] = 0.7501604333;
        FDist.YWA[63] = 0.7673108406;
        FDist.YWA[64] = 0.7836086337;
        FDist.YWA[65] = 0.799063723;
        FDist.YWA[66] = 0.8136897251;
        FDist.YWA[67] = 0.8275034914;
        FDist.YWA[68] = 0.8405246632;
        FDist.YWA[69] = 0.8527752531;
        FDist.YWA[70] = 0.8642792535;
        FDist.YWA[71] = 0.8750622738;
        FDist.YWA[72] = 0.8851512032;
        FDist.YWA[73] = 0.8945739017;
        FDist.YWA[74] = 0.9033589176;
        FDist.YWA[75] = 0.9115352296;
        FDist.YWA[76] = 0.919132015;
        FDist.YWA[77] = 0.9261784413;
        FDist.YWA[78] = 0.9327034806;
        FDist.YWA[79] = 0.9387357465;
        FDist.YWA[80] = 0.944303351;
        FDist.YWA[81] = 0.9494337813;
        FDist.YWA[82] = 0.9541537951;
        FDist.YWA[83] = 0.9584893325;
        FDist.YWA[84] = 0.9624654445;
        FDist.YWA[85] = 0.9661062352;
        FDist.YWA[86] = 0.9694348183;
        FDist.YWA[87] = 0.9724732859;
        FDist.YWA[88] = 0.9752426872;
        FDist.YWA[89] = 0.9777630186;
        FDist.YWA[90] = 0.9800532221;
        FDist.YWA[91] = 0.9821311912;
        FDist.YWA[92] = 0.9840137844;
        FDist.YWA[93] = 0.985716844;
        FDist.YWA[94] = 0.9872552203;
        FDist.YWA[95] = 0.9886428002;
        FDist.YWA[96] = 0.9898925389;
        FDist.YWA[97] = 0.9910164946;
        FDist.YWA[98] = 0.9920258656;
        FDist.YWA[99] = 0.9929310287;
        FDist.YWA[100] = 0.9937415788;
        FDist.YWA[101] = 0.9944663692;
        FDist.YWA[102] = 0.995113552;
        FDist.YWA[103] = 0.9956906185;
        FDist.YWA[104] = 0.9962044387;
        FDist.YWA[105] = 0.9966613009;
        FDist.YWA[106] = 0.9970669496;
        FDist.YWA[107] = 0.9974266225;
        FDist.YWA[108] = 0.9977450862;
        FDist.YWA[109] = 0.9980266707;
        FDist.YWA[110] = 0.9982753021;
        FDist.YWA[111] = 0.9984945338;
        FDist.YWA[112] = 0.998687576;
        FDist.YWA[113] = 0.998857324;
        FDist.YWA[114] = 0.9990063842;
        FDist.YWA[115] = 0.9991370993;
        FDist.YWA[116] = 0.9992515708;
        FDist.YWA[117] = 0.999351681;
        FDist.YWA[118] = 0.9994391129;
        FDist.YWA[119] = 0.9995153688;
        FDist.YWA[120] = 0.9995817875;
        FDist.YWA[121] = 0.9996395602;
        FDist.YWA[122] = 0.9996897446;
        FDist.YWA[123] = 0.9997332791;
        FDist.YWA[124] = 0.9997709943;
        FDist.YWA[125] = 0.9998036243;
        FDist.YWA[126] = 0.9998318172;
        FDist.YWA[127] = 0.9998561438;
        FDist.YWA[128] = 0.9998771066;
        FDist.YWA[129] = 0.9998951466;
        FDist.YWA[130] = 0.9999106508;
        FDist.YWA[131] = 0.999923958;
        FDist.YWA[132] = 0.9999353645;
        FDist.YWA[133] = 0.9999451288;
        FDist.YWA[134] = 0.9999534765;
        FDist.YWA[135] = 0.9999606035;
        FDist.YWA[136] = 0.9999666805;
        FDist.YWA[137] = 0.9999718553;
        FDist.YWA[138] = 0.9999762562;
        FDist.YWA[139] = 0.9999799939;
        FDist.YWA[140] = 0.9999831643;
        FDist.YWA[141] = 0.9999858;
        FDist.YWA[142] = 0.9999883;
        FDist.MWA[0] = 0.0;
        FDist.MWA[1] = 6.909E-15;
        FDist.MWA[2] = 2.763E-14;
        FDist.MWA[3] = 1.036E-13;
        FDist.MWA[4] = 3.792E-13;
        FDist.MWA[5] = 4.773E-12;
        FDist.MWA[6] = 4.59E-10;
        FDist.MWA[7] = 2.649E-8;
        FDist.MWA[8] = 7.353E-7;
        FDist.MWA[9] = 1.14E-5;
        FDist.MWA[10] = 1.102E-4;
        FDist.MWA[11] = 7.276E-4;
        FDist.MWA[12] = 0.003538;
        FDist.MWA[13] = 0.01342;
        FDist.MWA[14] = 0.04157;
        FDist.MWA[15] = 0.1088;
        FDist.MWA[16] = 0.2474;
        FDist.MWA[17] = 0.4999;
        FDist.MWA[18] = 0.913;
        FDist.MWA[19] = 1.53;
        FDist.MWA[20] = 2.381;
        FDist.MWA[21] = 3.475;
        FDist.MWA[22] = 4.795;
        FDist.MWA[23] = 6.3;
        FDist.MWA[24] = 7.928;
        FDist.MWA[25] = 9.602;
        FDist.MWA[26] = 11.24;
        FDist.MWA[27] = 12.76;
        FDist.MWA[28] = 14.1;
        FDist.MWA[29] = 15.18;
        FDist.MWA[30] = 15.98;
        FDist.MWA[31] = 16.47;
        FDist.MWA[32] = 16.64;
        FDist.MWA[33] = 16.49;
        FDist.MWA[34] = 16.05;
        FDist.MWA[35] = 15.35;
        FDist.MWA[36] = 14.41;
        FDist.MWA[37] = 13.28;
        FDist.MWA[38] = 12.0;
        FDist.MWA[39] = 10.6;
        FDist.MWA[40] = 9.13;
        FDist.MWA[41] = 7.618;
        FDist.MWA[42] = 6.095;
        FDist.MWA[43] = 4.588;
        FDist.MWA[44] = 3.122;
        FDist.MWA[45] = 1.713;
        FDist.MWA[46] = 0.3782;
        FDist.MWA[47] = -0.8726;
        FDist.MWA[48] = -2.031;
        FDist.MWA[49] = -3.091;
        FDist.MWA[50] = -4.051;
        FDist.MWA[51] = -4.91;
        FDist.MWA[52] = -5.668;
        FDist.MWA[53] = -6.327;
        FDist.MWA[54] = -6.893;
        FDist.MWA[55] = -7.367;
        FDist.MWA[56] = -7.756;
        FDist.MWA[57] = -8.064;
        FDist.MWA[58] = -8.297;
        FDist.MWA[59] = -8.46;
        FDist.MWA[60] = -8.56;
        FDist.MWA[61] = -8.602;
        FDist.MWA[62] = -8.591;
        FDist.MWA[63] = -8.533;
        FDist.MWA[64] = -8.433;
        FDist.MWA[65] = -8.296;
        FDist.MWA[66] = -8.127;
        FDist.MWA[67] = -7.93;
        FDist.MWA[68] = -7.709;
        FDist.MWA[69] = -7.469;
        FDist.MWA[70] = -7.212;
        FDist.MWA[71] = -6.943;
        FDist.MWA[72] = -6.663;
        FDist.MWA[73] = -6.378;
        FDist.MWA[74] = -6.087;
        FDist.MWA[75] = -5.795;
        FDist.MWA[76] = -5.503;
        FDist.MWA[77] = -5.213;
        FDist.MWA[78] = -4.927;
        FDist.MWA[79] = -4.646;
        FDist.MWA[80] = -4.371;
        FDist.MWA[81] = -4.103;
        FDist.MWA[82] = -3.843;
        FDist.MWA[83] = -3.593;
        FDist.MWA[84] = -3.352;
        FDist.MWA[85] = -3.12;
        FDist.MWA[86] = -2.899;
        FDist.MWA[87] = -2.689;
        FDist.MWA[88] = -2.489;
        FDist.MWA[89] = -2.3;
        FDist.MWA[90] = -2.121;
        FDist.MWA[91] = -1.952;
        FDist.MWA[92] = -1.794;
        FDist.MWA[93] = -1.645;
        FDist.MWA[94] = -1.506;
        FDist.MWA[95] = -1.377;
        FDist.MWA[96] = -1.256;
        FDist.MWA[97] = -1.144;
        FDist.MWA[98] = -1.041;
        FDist.MWA[99] = -0.9449;
        FDist.MWA[100] = -0.8564;
        FDist.MWA[101] = -0.775;
        FDist.MWA[102] = -0.7001;
        FDist.MWA[103] = -0.6315;
        FDist.MWA[104] = -0.5687;
        FDist.MWA[105] = -0.5113;
        FDist.MWA[106] = -0.459;
        FDist.MWA[107] = -0.4114;
        FDist.MWA[108] = -0.3681;
        FDist.MWA[109] = -0.3289;
        FDist.MWA[110] = -0.2934;
        FDist.MWA[111] = -0.2614;
        FDist.MWA[112] = -0.2325;
        FDist.MWA[113] = -0.2064;
        FDist.MWA[114] = -0.183;
        FDist.MWA[115] = -0.1621;
        FDist.MWA[116] = -0.1433;
        FDist.MWA[117] = -0.1265;
        FDist.MWA[118] = -0.1115;
        FDist.MWA[119] = -0.09813;
        FDist.MWA[120] = -0.08624;
        FDist.MWA[121] = -0.07569;
        FDist.MWA[122] = -0.06632;
        FDist.MWA[123] = -0.05803;
        FDist.MWA[124] = -0.05071;
        FDist.MWA[125] = -0.04424;
        FDist.MWA[126] = -0.03855;
        FDist.MWA[127] = -0.03353;
        FDist.MWA[128] = -0.02914;
        FDist.MWA[129] = -0.02528;
        FDist.MWA[130] = -0.0219;
        FDist.MWA[131] = -0.01894;
        FDist.MWA[132] = -0.01637;
        FDist.MWA[133] = -0.01412;
        FDist.MWA[134] = -0.01217;
        FDist.MWA[135] = -0.01046;
        FDist.MWA[136] = -0.008988;
        FDist.MWA[137] = -0.00772;
        FDist.MWA[138] = -0.006567;
        FDist.MWA[139] = -0.005802;
        FDist.MWA[140] = -0.0053;
        FDist.MWA[141] = -4.7E-4;
        FDist.MWA[142] = -4.3E-4;
        for (int j = 5; j <= 11; ++j) {
            FDist.CoWA[j] = 0.0;
        }
        FDist.CoWA[12] = 1.25E-5;
        FDist.CoWA[13] = 3.87E-5;
        FDist.CoWA[14] = 1.004E-4;
        FDist.CoWA[15] = 2.703E-4;
        FDist.CoWA[16] = 6.507E-4;
        FDist.CoWA[17] = 0.0013985;
        FDist.CoWA[18] = 0.0028353;
        FDist.CoWA[19] = 0.0051911;
        FDist.CoWA[20] = 0.0089486;
        FDist.CoWA[21] = 0.0141773;
        FDist.CoWA[22] = 0.0216551;
        FDist.CoWA[23] = 0.031489;
        FDist.CoWA[24] = 0.0434123;
        FDist.CoWA[25] = 0.0578719;
        FDist.CoWA[26] = 0.0746921;
        FDist.CoWA[27] = 0.0945265;
        FDist.CoWA[28] = 0.1165183;
        FDist.CoWA[29] = 0.1406353;
        FDist.CoWA[30] = 0.1662849;
        FDist.CoWA[31] = 0.1929895;
        FDist.CoWA[32] = 0.2189347;
        FDist.CoWA[33] = 0.2457772;
        FDist.CoWA[34] = 0.2704794;
        FDist.CoWA[35] = 0.2947906;
        FDist.CoWA[36] = 0.3169854;
        FDist.CoWA[37] = 0.3377435;
        FDist.CoWA[38] = 0.3573555;
        FDist.CoWA[39] = 0.3751205;
        FDist.CoWA[40] = 0.3906829;
        FDist.CoWA[41] = 0.4039806;
        FDist.CoWA[42] = 0.4142483;
        FDist.CoWA[43] = 0.422779;
        FDist.CoWA[44] = 0.4288013;
        FDist.CoWA[45] = 0.4330353;
        FDist.CoWA[46] = 0.434452;
        FDist.CoWA[47] = 0.4338138;
        FDist.CoWA[48] = 0.431504;
        FDist.CoWA[49] = 0.4272541;
        FDist.CoWA[50] = 0.4220568;
        FDist.CoWA[51] = 0.4158229;
        FDist.CoWA[52] = 0.4083281;
        FDist.CoWA[53] = 0.3981182;
        FDist.CoWA[54] = 0.3871678;
        FDist.CoWA[55] = 0.3755527;
        FDist.CoWA[56] = 0.3628823;
        FDist.CoWA[57] = 0.3520135;
        FDist.CoWA[58] = 0.3400924;
        FDist.CoWA[59] = 0.3280532;
        FDist.CoWA[60] = 0.3139477;
        FDist.CoWA[61] = 0.2997087;
        FDist.CoWA[62] = 0.2849179;
        FDist.CoWA[63] = 0.2710475;
        FDist.CoWA[64] = 0.2576478;
        FDist.CoWA[65] = 0.2449155;
        FDist.CoWA[66] = 0.2317447;
        FDist.CoWA[67] = 0.2193161;
        FDist.CoWA[68] = 0.2072622;
        FDist.CoWA[69] = 0.1956955;
        FDist.CoWA[70] = 0.1846514;
        FDist.CoWA[71] = 0.1734096;
        FDist.CoWA[72] = 0.1622678;
        FDist.CoWA[73] = 0.1520447;
        FDist.CoWA[74] = 0.1416351;
        FDist.CoWA[75] = 0.132136;
        FDist.CoWA[76] = 0.1231861;
        FDist.CoWA[77] = 0.1150411;
        FDist.CoWA[78] = 0.1071536;
        FDist.CoWA[79] = 0.099465;
        FDist.CoWA[80] = 0.0922347;
        FDist.CoWA[81] = 0.0854394;
        FDist.CoWA[82] = 0.0787697;
        FDist.CoWA[83] = 0.0723848;
        FDist.CoWA[84] = 0.066587;
        FDist.CoWA[85] = 0.0615849;
        FDist.CoWA[86] = 0.056573;
        FDist.CoWA[87] = 0.0517893;
        FDist.CoWA[88] = 0.0470011;
        FDist.CoWA[89] = 0.042886;
        FDist.CoWA[90] = 0.0391224;
        FDist.CoWA[91] = 0.0353163;
        FDist.CoWA[92] = 0.0320884;
        FDist.CoWA[93] = 0.0292264;
        FDist.CoWA[94] = 0.0266058;
        FDist.CoWA[95] = 0.0237352;
        FDist.CoWA[96] = 0.0214669;
        FDist.CoWA[97] = 0.0194848;
        FDist.CoWA[98] = 0.0175591;
        FDist.CoWA[99] = 0.0158232;
        FDist.CoWA[100] = 0.0140302;
        FDist.CoWA[101] = 0.0124349;
        FDist.CoWA[102] = 0.0111856;
        FDist.CoWA[103] = 0.0099765;
        FDist.CoWA[104] = 0.0089492;
        FDist.CoWA[105] = 0.0080063;
        FDist.CoWA[106] = 0.0071509;
        FDist.CoWA[107] = 0.0063196;
        FDist.CoWA[108] = 0.0056856;
        FDist.CoWA[109] = 0.0050686;
        FDist.CoWA[110] = 0.0045085;
        FDist.CoWA[111] = 0.0039895;
        FDist.CoWA[112] = 0.0034804;
        FDist.CoWA[113] = 0.0030447;
        FDist.CoWA[114] = 0.0027012;
        FDist.CoWA[115] = 0.0022984;
        FDist.CoWA[116] = 0.0020283;
        FDist.CoWA[117] = 0.0017399;
        FDist.CoWA[118] = 0.0015032;
        FDist.CoWA[119] = 0.0013267;
        FDist.CoWA[120] = 0.0011531;
        FDist.CoWA[121] = 9.92E-4;
        FDist.CoWA[122] = 9.211E-4;
        FDist.CoWA[123] = 8.296E-4;
        FDist.CoWA[124] = 6.991E-4;
        FDist.CoWA[125] = 5.84E-4;
        FDist.CoWA[126] = 5.12E-4;
        FDist.CoWA[127] = 4.314E-4;
        FDist.CoWA[128] = 3.593E-4;
        FDist.CoWA[129] = 3.014E-4;
        FDist.CoWA[130] = 2.401E-4;
        FDist.CoWA[131] = 2.004E-4;
        FDist.CoWA[132] = 1.614E-4;
        FDist.CoWA[133] = 1.257E-4;
        FDist.CoWA[134] = 1.112E-4;
        FDist.CoWA[135] = 9.22E-5;
        FDist.CoWA[136] = 8.77E-5;
        FDist.CoWA[137] = 6.22E-5;
        FDist.CoWA[138] = 4.93E-5;
        FDist.CoWA[139] = 3.92E-5;
        FDist.CoWA[140] = 3.15E-5;
        FDist.CoWA[141] = 1.03E-5;
        FDist.CoWA[142] = 9.6E-6;
    }
}

