/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Lmder_fcn;
import optimization.Minpack_f77;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class LogisticDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;

    public LogisticDist() {
        this.setParams(0.0, 1.0);
    }

    public LogisticDist(double alpha, double lambda) {
        this.setParams(alpha, lambda);
    }

    public double density(double x) {
        return LogisticDist.density(this.alpha, this.lambda, x);
    }

    public double cdf(double x) {
        return LogisticDist.cdf(this.alpha, this.lambda, x);
    }

    public double barF(double x) {
        return LogisticDist.barF(this.alpha, this.lambda, x);
    }

    public double inverseF(double u) {
        return LogisticDist.inverseF(this.alpha, this.lambda, u);
    }

    public double getMean() {
        return LogisticDist.getMean(this.alpha, this.lambda);
    }

    public double getVariance() {
        return LogisticDist.getVariance(this.alpha, this.lambda);
    }

    public double getStandardDeviation() {
        return LogisticDist.getStandardDeviation(this.alpha, this.lambda);
    }

    public static double density(double alpha, double lambda, double x) {
        if (x <= alpha - 100.0 / lambda) {
            return lambda * Math.exp(lambda * (x - alpha));
        }
        double denominateur = 1.0 + Math.exp(-lambda * (x - alpha));
        return lambda * Math.exp(-lambda * (x - alpha)) / (denominateur * denominateur);
    }

    public static double cdf(double alpha, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= alpha - 100.0 / lambda) {
            return Math.exp(lambda * (x - alpha));
        }
        if (x >= alpha + 100.0 / lambda) {
            return 1.0;
        }
        return 1.0 / (1.0 + Math.exp(-lambda * (x - alpha)));
    }

    public static double barF(double alpha, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (x <= alpha - 100.0 / lambda) {
            return 1.0;
        }
        if (x >= alpha + 100.0 / lambda) {
            return Math.exp(-lambda * (x - alpha));
        }
        return 1.0 / (1.0 + Math.exp(lambda * (x - alpha)));
    }

    public static double inverseF(double alpha, double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(u / (1.0 - u)) / lambda + alpha;
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += x[i];
        }
        double[] param = new double[3];
        param[1] = sum / (double)n;
        sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += (x[i] - param[1]) * (x[i] - param[1]);
        }
        param[2] = Math.sqrt(Math.PI * Math.PI * (double)n / (3.0 * sum));
        double[] fvec = new double[3];
        double[][] fjac = new double[3][3];
        int[] iflag = new int[2];
        int[] info = new int[2];
        int[] ipvt = new int[3];
        Optim system = new Optim(x, n);
        Minpack_f77.lmder1_f77((Lmder_fcn)system, (int)2, (int)2, (double[])param, (double[])fvec, (double[][])fjac, (double)1.0E-5, (int[])info, (int[])ipvt);
        double[] parameters = new double[]{param[1], param[2]};
        return parameters;
    }

    @Deprecated
    public static double[] getMaximumLikelihoodEstimate(double[] x, int n) {
        return LogisticDist.getMLE(x, n);
    }

    public static LogisticDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = LogisticDist.getMaximumLikelihoodEstimate(x, n);
        return new LogisticDist(parameters[0], parameters[1]);
    }

    public static double getMean(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return alpha;
    }

    public static double getVariance(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return 3.289868133696453 * (1.0 / (lambda * lambda));
    }

    public static double getStandardDeviation(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return Math.sqrt(0.3333333333333333) * Math.PI / lambda;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = alpha;
        this.lambda = lambda;
    }

    public double[] getParams() {
        double[] retour = new double[]{this.alpha, this.lambda};
        return retour;
    }

    public String toString() {
        return this.getClass().getName() + " : alpha = " + this.alpha + ", lambda = " + this.lambda;
    }

    private static class Optim
    implements Lmder_fcn {
        protected double[] xi;
        protected int n;

        public Optim(double[] x, int n) {
            this.n = n;
            this.xi = new double[n];
            System.arraycopy(x, 0, this.xi, 0, n);
        }

        public void fcn(int m, int n, double[] x, double[] fvec, double[][] fjac, int[] iflag) {
            if (x[2] <= 0.0) {
                double BIG = 1.0E100;
                fvec[1] = 1.0E100;
                fvec[2] = 1.0E100;
                fjac[1][1] = 1.0E100;
                fjac[1][2] = 0.0;
                fjac[2][1] = 0.0;
                fjac[2][2] = 1.0E100;
                return;
            }
            if (iflag[1] == 1) {
                int i;
                double sum = 0.0;
                for (i = 0; i < n; ++i) {
                    sum += 1.0 / (1.0 + Math.exp(x[2] * (this.xi[i] - x[1])));
                }
                fvec[1] = sum - (double)n / 2.0;
                sum = 0.0;
                for (i = 0; i < n; ++i) {
                    double prod = x[2] * (this.xi[i] - x[1]);
                    sum -= prod * Math.tanh(prod / 2.0);
                }
                fvec[2] = sum - (double)n;
            } else if (iflag[1] == 2) {
                double prod;
                int i;
                double sum = 0.0;
                for (i = 0; i < n; ++i) {
                    prod = Math.exp(x[2] * (this.xi[i] - x[1]));
                    sum -= x[2] * prod / ((1.0 + prod) * (1.0 + prod));
                }
                fjac[1][1] = sum;
                sum = 0.0;
                for (i = 0; i < n; ++i) {
                    prod = Math.exp(x[2] * (this.xi[i] - x[1]));
                    sum -= (this.xi[i] - x[1]) * prod / ((1.0 + prod) * (1.0 + prod));
                }
                fjac[1][2] = sum;
                sum = 0.0;
                for (i = 0; i < n; ++i) {
                    prod = Math.exp(x[2] * (this.xi[i] - x[1]));
                    sum -= x[2] * ((-1.0 + prod) * (1.0 + prod) - 2.0 * (x[2] * (this.xi[i] - x[1])) * prod) / ((1.0 + prod) * (1.0 + prod));
                }
                fjac[2][1] = sum;
                sum = 0.0;
                for (i = 0; i < n; ++i) {
                    prod = Math.exp(x[2] * (this.xi[i] - x[1]));
                    sum -= (x[1] - this.xi[1]) * ((-1.0 + prod) * (1.0 + prod) - 2.0 * (x[2] * (this.xi[i] - x[1])) * prod) / ((1.0 + prod) * (1.0 + prod));
                }
                fjac[2][2] = sum;
            }
        }
    }
}

