/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaGen;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.StochasticProcess;

public class GammaProcess
extends StochasticProcess {
    protected boolean usesAnti = false;
    protected RandomStream stream;
    protected GammaGen Ggen;
    protected double mu;
    protected double nu;
    protected double muOverNu;
    protected double mu2OverNu;
    protected double[] mu2dtOverNu;

    public GammaProcess(double s0, double mu, double nu, RandomStream stream) {
        this(s0, mu, nu, new GammaGen(stream, new GammaDist(1.0)));
    }

    public GammaProcess(double s0, double mu, double nu, GammaGen Ggen) {
        this.mu = mu;
        this.nu = nu;
        this.x0 = s0;
        this.Ggen = Ggen;
        this.stream = Ggen.getStream();
    }

    public double nextObservation() {
        double s = this.path[this.observationIndex];
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.path[this.observationIndex] = s += GammaGen.nextDouble(this.stream, this.mu2dtOverNu[this.observationIndex], this.muOverNu);
        return s;
    }

    public double nextObservation(double nextT) {
        double s = this.path[this.observationIndex];
        double previousT = this.t[this.observationIndex];
        ++this.observationIndex;
        this.observationCounter = this.observationIndex;
        this.t[this.observationIndex] = nextT;
        double dt = nextT - previousT;
        this.path[this.observationIndex] = s += GammaGen.nextDouble(this.stream, this.mu2OverNu * dt, this.muOverNu);
        return s;
    }

    public double[] generatePath() {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += GammaGen.nextDouble(this.stream, this.mu2dtOverNu[i], this.muOverNu);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public double[] generatePath(double[] uniform01) {
        double s = this.x0;
        for (int i = 0; i < this.d; ++i) {
            this.path[i + 1] = s += GammaDist.inverseF(this.mu2dtOverNu[i], this.muOverNu, 15, uniform01[i]);
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    public void setParams(double s0, double mu, double nu) {
        this.x0 = s0;
        this.mu = mu;
        this.nu = nu;
        if (this.observationTimesSet) {
            this.init();
        }
    }

    public double getMu() {
        return this.mu;
    }

    public double getNu() {
        return this.nu;
    }

    public void setStream(RandomStream stream) {
        this.stream = stream;
        this.Ggen.setStream(stream);
    }

    public RandomStream getStream() {
        return this.stream;
    }

    protected void init() {
        super.init();
        this.muOverNu = this.mu / this.nu;
        this.mu2OverNu = this.mu * this.mu / this.nu;
        this.mu2dtOverNu = new double[this.d];
        if (this.observationTimesSet) {
            for (int i = 0; i < this.d; ++i) {
                this.mu2dtOverNu[i] = this.mu2OverNu * (this.t[i + 1] - this.t[i]);
            }
        }
    }
}

