/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.ToolBox;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class EnrichmentScore {
    public static void main(String[] args) throws Exception {
        String line;
        int seqcol = 1;
        int valcol = 2;
        int start = 3;
        int length = 30;
        BufferedReader reader = new BufferedReader(new FileReader(args[0]));
        LinkedList<Sequence> probes = new LinkedList<Sequence>();
        DoubleList values = new DoubleList();
        reader.readLine();
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts[seqcol].trim().length() <= 0) continue;
            probes.add(Sequence.create(DNAAlphabetContainer.SINGLETON, parts[seqcol]));
            values.add(Double.parseDouble(parts[valcol]));
        }
        double[] vals = values.toArray();
        int[] ranks = ToolBox.rank(vals, ToolBox.TiedRanks.IN_ORDER);
        Sequence[][] exp = EnrichmentScore.explode(probes, 8, start, length);
        HashMap<Sequence, DoubleList> list = EnrichmentScore.precompute(exp, ranks);
        PrintWriter out = new PrintWriter(String.valueOf(args[0]) + "_enrich_start" + start + "_length" + length + ".txt");
        DiscreteSequenceEnumerator en = new DiscreteSequenceEnumerator(DNAAlphabetContainer.SINGLETON, 8, true);
        while (en.hasMoreElements()) {
            Object curr = en.nextElement();
            double[] stat = EnrichmentScore.getStatistics3((Sequence)curr, list, exp.length);
            double area = 1.0 / (stat[0] + stat[1]) * (stat[3] / stat[1] - stat[2] / stat[0]);
            out.println(curr + "\t" + ((Sequence)curr).reverseComplement() + "\t" + area);
            System.out.println(curr + "\t" + ((Sequence)curr).reverseComplement() + "\t" + area);
        }
        out.close();
    }

    private static double[] getStatistics(Sequence curr, Sequence[][] seqs, int[] ranks) {
        DoubleList ranksPos = new DoubleList();
        DoubleList ranksNeg = new DoubleList();
        int i = 0;
        while (i < seqs.length) {
            block7: {
                int k = 0;
                while (k < seqs[i].length) {
                    if (curr.equals(seqs[i][k])) {
                        ranksPos.add(ranks[i] + 1);
                        break block7;
                    }
                    ++k;
                }
                ranksNeg.add(ranks[i] + 1);
            }
            ++i;
        }
        double[] rp = ranksPos.toArray();
        double[] rn = ranksNeg.toArray();
        double tp = ToolBox.median(rp);
        double tn = ToolBox.median(rn);
        double[] stats = new double[4];
        stats[0] = rp.length / 2;
        stats[1] = rn.length / 2;
        int i2 = 0;
        while (i2 < rp.length) {
            if (rp[i2] >= tp) {
                stats[2] = stats[2] + rp[i2];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < rn.length) {
            if (rn[i2] >= tn) {
                stats[3] = stats[3] + rn[i2];
            }
            ++i2;
        }
        return stats;
    }

    private static HashMap<Sequence, DoubleList> precompute(Sequence[][] seqs, int[] ranks) {
        HashMap<Sequence, DoubleList> list = new HashMap<Sequence, DoubleList>();
        HashSet<Sequence> set = new HashSet<Sequence>();
        DoubleList ranksPos = new DoubleList();
        int i = 0;
        while (i < seqs.length) {
            set.clear();
            int k = 0;
            while (k < seqs[i].length) {
                set.add(seqs[i][k]);
                ++k;
            }
            for (Sequence temp : set) {
                if (!list.containsKey(temp)) {
                    list.put(temp, new DoubleList());
                }
                list.get(temp).add(ranks[i] + 1);
            }
            ++i;
        }
        return list;
    }

    private static double[] getStatistics3(Sequence curr, HashMap<Sequence, DoubleList> list, int num) {
        DoubleList ranksPos = list.get(curr);
        double[] rp = null;
        rp = ranksPos != null ? ranksPos.toArray() : new double[]{};
        Arrays.sort(rp);
        int fgsize = rp.length / 2;
        int bgsize = (num - rp.length) / 2;
        double ranksum = 0.0;
        int lastrank = bgsize;
        int i = 0;
        while (i < fgsize) {
            if (rp[i] - (double)i > (double)bgsize) {
                ranksum += (double)(lastrank + 1);
                ++lastrank;
            } else {
                ranksum += rp[i];
                ++lastrank;
            }
            ++i;
        }
        double totalRankSum = ((double)fgsize + (double)bgsize) * ((double)fgsize + (double)bgsize + 1.0) / 2.0;
        return new double[]{rp.length / 2, bgsize, ranksum, totalRankSum - ranksum};
    }

    private static double[] getStatistics3(Sequence curr, Sequence[][] seqs, int[] ranks) {
        DoubleList ranksPos = new DoubleList();
        int i = 0;
        while (i < seqs.length) {
            int k = 0;
            while (k < seqs[i].length) {
                if (curr.equals(seqs[i][k])) {
                    ranksPos.add(ranks[i] + 1);
                    break;
                }
                ++k;
            }
            ++i;
        }
        double[] rp = ranksPos.toArray();
        Arrays.sort(rp);
        int fgsize = rp.length / 2;
        int bgsize = (seqs.length - rp.length) / 2;
        double ranksum = 0.0;
        int lastrank = bgsize;
        int i2 = 0;
        while (i2 < fgsize) {
            if (rp[i2] - (double)i2 > (double)bgsize) {
                ranksum += (double)(lastrank + 1);
                ++lastrank;
            } else {
                ranksum += rp[i2];
                ++lastrank;
            }
            ++i2;
        }
        double totalRankSum = ((double)fgsize + (double)bgsize) * ((double)fgsize + (double)bgsize + 1.0) / 2.0;
        return new double[]{rp.length / 2, bgsize, ranksum, totalRankSum - ranksum};
    }

    private static double getStatistics2(Sequence curr, Sequence[][] seqs, int[] ranks) {
        DoubleList ranksPos = new DoubleList();
        int i = 0;
        while (i < seqs.length) {
            int k = 0;
            while (k < seqs[i].length) {
                if (curr.equals(seqs[i][k])) {
                    ranksPos.add(ranks[i] + 1);
                    break;
                }
                ++k;
            }
            ++i;
        }
        double[] rp = ranksPos.toArray();
        Arrays.sort(rp);
        int fgsize = rp.length / 2;
        int bgsize = (seqs.length - rp.length) / 2;
        double ranksum = 0.0;
        int lastrank = bgsize;
        int i2 = 0;
        while (i2 < fgsize) {
            if (rp[i2] - (double)i2 > (double)bgsize) {
                ranksum += (double)(lastrank + 1);
                ++lastrank;
            } else {
                ranksum += rp[i2];
                ++lastrank;
            }
            ++i2;
        }
        if (fgsize > 0) {
            return ((double)(fgsize * (fgsize + 1) / 2 + fgsize * bgsize / 2) - ranksum) / (double)(fgsize * bgsize);
        }
        return 0.0;
    }

    private static Sequence[][] explode(LinkedList<Sequence> probes, int length, int start, int totalLength) throws Exception {
        Sequence[][] seqs = new Sequence[probes.size()][];
        Iterator it = probes.iterator();
        int k = 0;
        while (it.hasNext()) {
            Sequence curr = (Sequence)it.next();
            seqs[k] = new Sequence[totalLength - length + 1];
            int i = 0;
            while (i < totalLength - length + 1) {
                Sequence sub = curr.getSubSequence(i + start, length);
                Sequence rc = sub.reverseComplement();
                if (rc.compareTo(sub) < 0) {
                    sub = rc;
                }
                seqs[k][i] = sub;
                ++i;
            }
            ++k;
        }
        return seqs;
    }
}

