/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifiers;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassDimensionException;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.msp.MSPClassifier;
import de.jstacs.classifiers.trainSMBased.TrainSMBasedClassifier;
import de.jstacs.sequenceScores.SequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;

public class ClassifierFactory {
    public static AbstractClassifier createGenerativeClassifier(TrainableStatisticalModel ... models) throws IllegalArgumentException, CloneNotSupportedException, ClassDimensionException {
        return new TrainSMBasedClassifier(models);
    }

    private static int getLength(SequenceScore ... models) {
        int length = models[0].getLength();
        int i = 1;
        while (i < models.length) {
            int l = models[i].getLength();
            if (l != length) {
                if (length == 0) {
                    length = l;
                } else if (l != 0) {
                    throw new IllegalArgumentException("Model " + i + " has different but fixed length than a previous model.");
                }
            }
            ++i;
        }
        return length;
    }

    public static AbstractClassifier createClassifier(LearningPrinciple principle, DifferentiableStatisticalModel ... models) throws IllegalArgumentException, Exception {
        return ClassifierFactory.createClassifier(LearningPrinciple.getBeta(principle), models);
    }

    public static AbstractClassifier createClassifier(double[] beta, DifferentiableStatisticalModel ... models) throws IllegalArgumentException, Exception {
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(models[0].getAlphabetContainer(), ClassifierFactory.getLength(models), 20, 1.0E-6, 1.0E-6, 1.0E-4, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 4);
        return new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), beta, models);
    }

    public static AbstractClassifier createClassifier(DifferentiableSequenceScore ... models) throws IllegalArgumentException, Exception {
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(models[0].getAlphabetContainer(), ClassifierFactory.getLength(models), 20, 1.0E-6, 1.0E-6, 1.0E-4, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 1);
        return new MSPClassifier(params, models);
    }
}

