/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class FileManager {
    private static byte[] buffer = new byte[100000];

    private FileManager() {
    }

    public static int copy(File source, File target, FileFilter filter, boolean newer) throws IllegalArgumentException, IOException {
        if (!source.isDirectory() || target.exists() && !target.isDirectory()) {
            throw new IllegalArgumentException("The source and the target have to be directories. (" + source.getAbsolutePath() + ", " + target.getAbsolutePath());
        }
        File[] files = filter == null ? source.listFiles() : source.listFiles(filter);
        int anz = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                anz += FileManager.copy(f, new File(String.valueOf(target.getAbsolutePath()) + "/" + f.getName()), filter, newer);
            } else {
                String current = String.valueOf(target.getAbsolutePath()) + "/" + f.getName();
                File h = new File(current);
                if (!h.exists() || !newer || f.lastModified() > h.lastModified()) {
                    if (!target.exists()) {
                        target.mkdirs();
                    }
                    FileManager.copy(f.getAbsolutePath(), current);
                    ++anz;
                }
            }
            ++n2;
        }
        return anz;
    }

    public static void copy(String from, String to) throws IOException {
        FileManager.copy(from, to, buffer);
    }

    public static synchronized void copy(String from, String to, byte[] buffer) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int amountRead;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            while ((amountRead = in.read(buffer)) > -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        new File(to).setLastModified(new File(from).lastModified());
    }

    public static StringBuffer readFile(String fName) throws IOException {
        return FileManager.read(new FileReader(fName));
    }

    public static StringBuffer readFile(File file) throws IOException {
        return FileManager.read(new FileReader(file));
    }

    public static StringBuffer readInputStream(InputStream inputStream) throws IOException {
        return FileManager.read(new InputStreamReader(inputStream));
    }

    public static StringBuffer read(Reader reader) throws IOException {
        String help;
        BufferedReader r = new BufferedReader(reader, 100000);
        StringBuffer res = new StringBuffer(1000000);
        while ((help = r.readLine()) != null) {
            res.append(String.valueOf(help) + "\n");
        }
        r.close();
        return res;
    }

    public static void writeFile(File outputFile, CharSequence buffer) throws IOException {
        FileManager.write(new FileWriter(outputFile), buffer);
    }

    public static void writeFile(String fName, CharSequence buffer) throws IOException {
        FileManager.writeFile(new File(fName), buffer);
    }

    public static void writeOutputStream(OutputStream outStream, CharSequence buffer) throws IOException {
        FileManager.write(new OutputStreamWriter(outStream), buffer);
    }

    public static void write(Writer writer, CharSequence buffer) throws IOException {
        BufferedWriter w = new BufferedWriter(writer);
        w.write(buffer.toString());
        w.close();
    }
}

