/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.distributed.DistDataSource;

class DASDistDataSource
implements DistDataSource {
    private DASSequenceDB db;

    public URL getURL() {
        return this.db.getURL();
    }

    public DASDistDataSource(URL url) throws BioException {
        this.db = new DASSequenceDB(url);
    }

    public boolean hasSequence(String id) throws BioException {
        try {
            Sequence seq = this.db.allEntryPointsDB().getSequence(id);
            int size = seq.length();
            int n = size + 1 - 1;
        }
        catch (IllegalIDException ex) {
            return false;
        }
        return true;
    }

    public boolean hasFeatures(String id) throws BioException {
        return this.hasSequence(id);
    }

    public FeatureHolder getFeatures(FeatureFilter ff) throws BioException {
        throw new BioException();
    }

    public FeatureHolder getFeatures(String id, FeatureFilter ff, boolean recurse) throws BioException {
        Sequence fh;
        try {
            fh = this.db.allEntryPointsDB().getSequence(id);
        }
        catch (IllegalIDException ex) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        if (!recurse && FilterUtils.areProperSubset(FeatureFilter.all, ff)) {
            return fh;
        }
        return fh.filter(ff, recurse);
    }

    public Sequence getSequence(String id) throws BioException {
        return this.db.allEntryPointsDB().getSequence(id);
    }

    public Set ids(boolean topLevel) throws BioException {
        return this.db.ids();
    }
}

