/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.SubclassFinder;
import de.jstacs.utils.Time;

public class CombinedCondition
extends AbstractTerminationCondition {
    private TerminationCondition[] condition;
    private int threshold;

    public CombinedCondition(int threshold, AbstractTerminationCondition ... condition) throws Exception {
        this(new CombinedConditionParameterSet(threshold, condition));
    }

    public CombinedCondition(CombinedConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.threshold = (Integer)this.parameter.getParameterAt(0).getValue();
        ExpandableParameterSet eps = (ExpandableParameterSet)this.parameter.getParameterAt(1).getValue();
        this.condition = new AbstractTerminationCondition[eps.getNumberOfParameters()];
        int i = 0;
        while (i < this.condition.length) {
            Parameter p = ((ParameterSet)eps.getParameterAt(i).getValue()).getParameterAt(0);
            try {
                this.condition[i] = (AbstractTerminationCondition)((AbstractTerminationCondition.AbstractTerminationConditionParameterSet)p.getValue()).getInstance();
            }
            catch (ParameterSetParser.NotInstantiableException e) {
                RuntimeException ex = new RuntimeException(e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            ++i;
        }
    }

    @Override
    protected String getXmlTag() {
        return "CombinedCondition";
    }

    public CombinedCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        int positive = 0;
        int i = 0;
        while (i < this.condition.length && positive < this.threshold) {
            if (this.condition[i].doNextIteration(iteration, f_last, f_current, gradient, direction, alpha, t)) {
                ++positive;
            }
            ++i;
        }
        return positive >= this.threshold;
    }

    @Override
    public boolean isSimple() {
        int i = 0;
        while (i < this.condition.length && this.condition[i].isSimple()) {
            ++i;
        }
        return i == this.condition.length;
    }

    public static class CombinedConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public CombinedConditionParameterSet() throws Exception {
            super((Class<? extends AbstractTerminationCondition>)CombinedCondition.class);
            this.parameters.add(new Parameter[]{new SimpleParameter(DataType.INT, "threshold", "the number of conditions that has to be fulfilled for stopping the algorithm", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE))});
            this.parameters.add(new Parameter[]{new ParameterSetContainer("Termination conditions", "The set of termination conditions that shall be combined.", new ExpandableParameterSet(new SimpleParameterSet(SubclassFinder.getSelectionParameter(AbstractTerminationCondition.AbstractTerminationConditionParameterSet.class, AbstractTerminationCondition.AbstractTerminationConditionParameterSet.class.getPackage().getName(), "Termination condition", "Select a termination condition.", true)), "Termination conditions", "Add termination conditions to the set of conditions."))});
        }

        public CombinedConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public CombinedConditionParameterSet(int threshold, AbstractTerminationCondition[] condition) throws Exception {
            this();
            this.getParameterAt(0).setValue(threshold);
            ExpandableParameterSet eps = (ExpandableParameterSet)this.getParameterAt(1).getValue();
            int i = 0;
            while (i < condition.length) {
                if (i != 0) {
                    eps.addParameterToSet();
                }
                ((ParameterSet)eps.getParameterAt(i).getValue()).getParameterAt(0).setValue(condition[i].parameter);
                ++i;
            }
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the CombinedCondition";
        }

        @Override
        public String getInstanceName() {
            return "CombinedConditionParameterSet";
        }
    }
}

