/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.WrongLengthException;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.ShortSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.NullSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SymbolExtractor;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.OperationNotSupportedException;

public class DataSet
implements Iterable<Sequence> {
    private String annotation;
    private AlphabetContainer alphabetContainer;
    private Sequence[] seqs;
    private int length;
    private int[] indexOfFirstSubseq;

    public static final String getAnnotation(DataSet ... s) {
        if (s == null || s.length == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(s.length * 100);
        sb.append(s[0].getAnnotation());
        int i = 1;
        while (i < s.length) {
            sb.append(", ");
            sb.append(s[i].getAnnotation());
            ++i;
        }
        return "[" + sb.toString() + "]";
    }

    public static final DataSet diff(DataSet data, DataSet ... samples) throws EmptyDataSetException, WrongAlphabetException {
        int[] occurrence;
        Sequence seq;
        Hashtable<Sequence, int[]> hash = new Hashtable<Sequence, int[]>(data.getNumberOfElements() * 2);
        AlphabetContainer abc = data.getAlphabetContainer();
        int n = 0;
        int i = 0;
        int anz = data.getNumberOfElements();
        while (n < anz) {
            seq = data.getElementAt(n);
            occurrence = (int[])hash.get(seq);
            if (occurrence != null) {
                occurrence[0] = occurrence[0] + 1;
            } else {
                hash.put(seq, new int[]{1});
            }
            ++n;
        }
        while (i < samples.length && hash.size() > 0) {
            if (!abc.checkConsistency(samples[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("The data sets do not have the same AlphabetContainer.");
            }
            n = 0;
            while (n < samples[i].getNumberOfElements()) {
                seq = samples[i].getElementAt(n);
                occurrence = (int[])hash.get(seq);
                if (occurrence != null) {
                    if (occurrence[0] == 1) {
                        hash.remove(seq);
                    } else {
                        occurrence[0] = occurrence[0] - 1;
                    }
                    --anz;
                }
                ++n;
            }
            ++i;
        }
        Sequence[] seqs = new Sequence[anz];
        Iterator it = hash.entrySet().iterator();
        anz = 0;
        while (it.hasNext()) {
            Map.Entry current = it.next();
            seq = (Sequence)current.getKey();
            occurrence = (int[])current.getValue();
            i = 0;
            while (i < occurrence[0]) {
                seqs[anz++] = seq;
                ++i;
            }
        }
        return new DataSet("diff of " + data.getAnnotation() + " and " + DataSet.getAnnotation(samples), seqs);
    }

    public static final DataSet intersection(DataSet ... samples) throws IllegalArgumentException, EmptyDataSetException {
        WeightedDataSetFactory[] wsf = new WeightedDataSetFactory[samples.length];
        int[] index = new int[samples.length];
        int i = 0;
        int len = -1;
        AlphabetContainer abc = samples[i].getAlphabetContainer();
        while (i < wsf.length) {
            if (!abc.checkConsistency(samples[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("The data sets do not have the same AlphabetContainer.");
            }
            try {
                wsf[i] = new WeightedDataSetFactory(WeightedDataSetFactory.SortOperation.SORT_BY_SEQUENCE, samples[i++]);
            }
            catch (WrongAlphabetException doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
            catch (WrongLengthException doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
        }
        boolean goOn = true;
        ArrayList<Sequence> list = new ArrayList<Sequence>(100);
        do {
            String help;
            String current = wsf[0].getElementAt(index[0]).toString();
            i = 1;
            while (i < samples.length) {
                help = wsf[i].getElementAt(index[i]).toString();
                if (current.compareTo(help) < 0) {
                    current = help;
                }
                ++i;
            }
            boolean same = true;
            i = 0;
            while (i < samples.length) {
                help = "";
                while (index[i] < wsf[i].getNumberOfElements() && current.compareTo(help = wsf[i].getElementAt(index[i]).toString()) > 0) {
                    int n = i;
                    index[n] = index[n] + 1;
                }
                same &= current.equals(help);
                ++i;
            }
            if (same) {
                double anz = wsf[0].getWeight(index[0]);
                i = 1;
                while (i < samples.length) {
                    if (anz > wsf[i].getWeight(index[i])) {
                        anz = wsf[i].getWeight(index[i]);
                    }
                    int n = i++;
                    index[n] = index[n] + 1;
                }
                if (list.size() == 0) {
                    len = wsf[0].getElementAt(index[0]).getLength();
                } else if (len != wsf[0].getElementAt(index[0]).getLength()) {
                    len = 0;
                }
                i = 0;
                while ((double)i < anz) {
                    list.add(wsf[0].getElementAt(index[0]));
                    ++i;
                }
                index[0] = index[0] + 1;
            }
            i = 0;
            while (i < samples.length) {
                if (index[i] == wsf[i].getNumberOfElements()) {
                    goOn = false;
                }
                ++i;
            }
        } while (goOn);
        return new DataSet(abc, list.toArray(new Sequence[0]), len, "intersection of " + DataSet.getAnnotation(samples));
    }

    public static final DataSet union(DataSet[] s, boolean[] in) throws IllegalArgumentException, EmptyDataSetException {
        try {
            return DataSet.union(s, null, in).getFirstElement();
        }
        catch (WrongLengthException doesNotHappen) {
            IllegalArgumentException i = new IllegalArgumentException(doesNotHappen.getMessage());
            i.setStackTrace(doesNotHappen.getStackTrace());
            throw i;
        }
    }

    public static final DataSet union(DataSet ... s) throws IllegalArgumentException {
        if (s == null || s.length == 0) {
            return null;
        }
        boolean[] in = new boolean[s.length];
        Arrays.fill(in, true);
        try {
            return DataSet.union(s, in);
        }
        catch (EmptyDataSetException doesNotHappen) {
            return null;
        }
    }

    public static final Pair<DataSet, double[]> union(DataSet[] s, double[][] weights, boolean[] in) throws IllegalArgumentException, EmptyDataSetException, WrongLengthException {
        if (s == null || s.length == 0) {
            return new Pair<Object, Object>(null, null);
        }
        if (weights != null && weights.length != s.length || in.length != s.length) {
            throw new IllegalArgumentException("The arrays have to have the same dimension.");
        }
        int i = 0;
        int l = s.length;
        while (i < l && !in[i]) {
            ++i;
        }
        if (i == l) {
            return new Pair<Object, Object>(null, null);
        }
        int start = i++;
        int len = s[start].getElementLength();
        int anz = s[start].getNumberOfElements();
        String annot = "the union of [" + s[start].getAnnotation();
        while (i < l && (!in[i] || s[start].alphabetContainer.checkConsistency(s[i].alphabetContainer))) {
            if (in[i]) {
                anz += s[i].getNumberOfElements();
                if (len != 0 && len != s[i].getElementLength()) {
                    len = 0;
                }
                annot = String.valueOf(annot) + ", " + s[i].getAnnotation();
            }
            ++i;
        }
        if (i < l) {
            throw new IllegalArgumentException("The alphabets of the data sets do not match.");
        }
        Sequence[] seqs = new Sequence[anz];
        anz = 0;
        DoubleList w = new DoubleList();
        i = 0;
        while (i < l) {
            if (in[i]) {
                int j = 0;
                ElementEnumerator ei = new ElementEnumerator(s[i]);
                while (ei.hasMoreElements()) {
                    seqs[anz++] = ei.nextElement();
                    if (weights == null || weights[i] == null) continue;
                    w.add(weights[i][j++]);
                }
            }
            ++i;
        }
        DataSet res = new DataSet(s[start].alphabetContainer, seqs, len, String.valueOf(annot) + "]");
        Pair<DataSet, Object> p = null;
        if (w.length() == 0) {
            p = new Pair<DataSet, Object>(res, null);
        } else if (w.length() == seqs.length) {
            p = new Pair<DataSet, double[]>(res, w.toArray());
        } else {
            throw new IllegalArgumentException("Some of the weight arrays are null and others not.");
        }
        return p;
    }

    private DataSet(AlphabetContainer abc, Sequence[] seqs, int length, String annotation) throws EmptyDataSetException {
        if (seqs == null || seqs.length == 0) {
            throw new EmptyDataSetException();
        }
        this.alphabetContainer = abc;
        this.seqs = seqs;
        this.length = length;
        this.annotation = annotation;
    }

    public DataSet(AlphabetContainer abc, AbstractStringExtractor se) throws WrongAlphabetException, EmptyDataSetException, WrongLengthException {
        this(abc, se, abc.getDelim(), 0);
    }

    public DataSet(AlphabetContainer abc, AbstractStringExtractor se, int subsequenceLength) throws WrongAlphabetException, WrongLengthException, EmptyDataSetException {
        this(abc, se, abc.getDelim(), subsequenceLength);
    }

    public DataSet(AlphabetContainer abc, AbstractStringExtractor se, String delim) throws WrongAlphabetException, EmptyDataSetException, WrongLengthException {
        this(abc, se, delim, 0);
    }

    /*
     * Unable to fully structure code
     */
    public DataSet(AlphabetContainer abc, AbstractStringExtractor se, String delim, int subsequenceLength) throws EmptyDataSetException, WrongAlphabetException, WrongLengthException {
        block23: {
            super();
            this.alphabetContainer = abc;
            newSeqs = new LinkedList<Sequence>();
            temp = new SymbolExtractor(delim);
            this.length = -1;
            try {
                if (this.alphabetContainer.isDiscrete()) {
                    l = (int)this.alphabetContainer.getMaximalAlphabetLength();
                    if (l <= 127) {
                        while (se.hasMoreElements()) {
                            annot = se.getCurrentSequenceAnnotations();
                            temp.setStringToBeParsed((String)se.nextElement());
                            if (this.length < 0) {
                                this.length = temp.countElements();
                            } else if (this.length > 0 && temp.countElements() != this.length) {
                                this.length = 0;
                            }
                            newSeqs.add(new ByteSequence(this.alphabetContainer, annot, temp));
                        }
                        break block23;
                    }
                    if (l <= 32767) {
                        while (se.hasMoreElements()) {
                            annot = se.getCurrentSequenceAnnotations();
                            temp.setStringToBeParsed((String)se.nextElement());
                            if (this.length < 0) {
                                this.length = temp.countElements();
                            } else if (this.length > 0 && temp.countElements() != this.length) {
                                this.length = 0;
                            }
                            newSeqs.add(new ShortSequence(this.alphabetContainer, annot, temp));
                        }
                        break block23;
                    }
                    if (l <= 0x7FFFFFFF) {
                        while (se.hasMoreElements()) {
                            annot = se.getCurrentSequenceAnnotations();
                            temp.setStringToBeParsed((String)se.nextElement());
                            if (this.length < 0) {
                                this.length = temp.countElements();
                            } else if (this.length > 0 && temp.countElements() != this.length) {
                                this.length = 0;
                            }
                            newSeqs.add(new IntSequence(this.alphabetContainer, annot, temp));
                        }
                        break block23;
                    }
                    throw new WrongAlphabetException("Could not encode. Too many symbols.");
                }
                if (delim.length() != 0) ** GOTO lbl60
                throw new IllegalArgumentException("delim has to be not empty");
lbl-1000:
                // 1 sources

                {
                    annot = se.getCurrentSequenceAnnotations();
                    temp.setStringToBeParsed((String)se.nextElement());
                    if (this.length < 0) {
                        this.length = temp.countElements();
                    } else if (this.length > 0 && temp.countElements() != this.length) {
                        this.length = 0;
                    }
                    newSeqs.add(new ArbitrarySequence(this.alphabetContainer, annot, temp));
lbl60:
                    // 2 sources

                    ** while (se.hasMoreElements())
                }
lbl61:
                // 1 sources

            }
            catch (WrongSequenceTypeException e) {
                doesNotHappen = new RuntimeException(e.getMessage());
                doesNotHappen.setStackTrace(e.getStackTrace());
                throw doesNotHappen;
            }
        }
        this.seqs = new Sequence[newSeqs.size()];
        if (this.seqs.length == 0) {
            throw new EmptyDataSetException();
        }
        newSeqs.toArray(this.seqs);
        this.setSubsequenceLength(subsequenceLength);
        this.annotation = subsequenceLength > 0 ? "all subsequences of length " + subsequenceLength + " from " + se.getAnnotation() : se.getAnnotation();
    }

    public DataSet(DataSet s, int subsequenceLength) throws WrongLengthException {
        this(s, subsequenceLength, false);
    }

    private DataSet(DataSet s, int subsequenceLength, boolean copy) throws WrongLengthException {
        if (copy) {
            this.alphabetContainer = s.alphabetContainer;
            this.seqs = s.getAllElements();
            this.setSubsequenceLength(subsequenceLength);
            this.seqs = this.getAllElements();
            this.indexOfFirstSubseq = null;
            this.length = subsequenceLength;
            this.annotation = "all subsequences of length " + subsequenceLength + " from " + s.annotation;
        } else {
            this.alphabetContainer = s.alphabetContainer;
            this.seqs = s.indexOfFirstSubseq == null ? s.seqs : s.getAllElements();
            this.length = s.length;
            this.setSubsequenceLength(subsequenceLength);
            this.annotation = "all subsequences of length " + subsequenceLength + " from " + s.annotation;
        }
    }

    public DataSet(String annotation, Sequence ... seqs) throws EmptyDataSetException, WrongAlphabetException {
        if (seqs == null || seqs.length == 0) {
            throw new EmptyDataSetException();
        }
        this.alphabetContainer = seqs[0].getAlphabetContainer();
        this.seqs = new Sequence[seqs.length];
        int i = 1;
        this.length = seqs[0].getLength();
        this.seqs[0] = seqs[0];
        while (i < seqs.length) {
            this.seqs[i] = seqs[i];
            if (this.length != seqs[i].getLength()) {
                this.length = 0;
            }
            if (this.alphabetContainer.checkConsistency(seqs[i++].getAlphabetContainer())) continue;
            throw new WrongAlphabetException("The sequences are not defined over the same AlphabetContainer.");
        }
        this.indexOfFirstSubseq = null;
        this.annotation = annotation;
    }

    public DataSet(String annotation, Collection<Sequence> seqs) throws EmptyDataSetException, WrongAlphabetException {
        if (seqs == null || seqs.size() == 0) {
            throw new EmptyDataSetException();
        }
        this.seqs = new Sequence[seqs.size()];
        Iterator<Sequence> it = seqs.iterator();
        this.seqs[0] = it.next();
        this.alphabetContainer = this.seqs[0].getAlphabetContainer();
        int i = 1;
        this.length = this.seqs[0].getLength();
        while (it.hasNext()) {
            this.seqs[i] = it.next();
            if (this.length != 0 && this.length != this.seqs[i].getLength()) {
                this.length = 0;
            }
            if (!this.alphabetContainer.checkConsistency(this.seqs[i].getAlphabetContainer())) {
                throw new WrongAlphabetException("The sequences are not defined over the same AlphabetContainer.");
            }
            ++i;
        }
        this.indexOfFirstSubseq = null;
        this.annotation = annotation;
    }

    public Sequence[] getAllElements() {
        Sequence[] res = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        int i = 0;
        while (i < res.length) {
            res[i] = ei.nextElement();
            ++i;
        }
        return res;
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabetContainer;
    }

    public final String getAnnotation() {
        return this.annotation;
    }

    public final DataSet getCompositeDataSet(int[] starts, int[] lengths) throws IllegalArgumentException {
        AlphabetContainer abc = this.alphabetContainer.getCompositeContainer(starts, lengths);
        Sequence[] n = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        int i = 0;
        int length = 0;
        while (i < n.length) {
            n[i++] = ei.nextElement().getCompositeSequence(abc, starts, lengths);
        }
        i = 0;
        while (i < lengths.length) {
            length += lengths[i];
            ++i;
        }
        try {
            return new DataSet(abc, n, length, "composite data set (starts=" + Arrays.toString(starts) + ", lengths=" + Arrays.toString(lengths) + ") of " + this.annotation);
        }
        catch (EmptyDataSetException doesNotHappen) {
            return null;
        }
    }

    public Sequence getElementAt(int i) {
        if (this.indexOfFirstSubseq == null) {
            return this.seqs[i];
        }
        int seqInd = this.getIndexOfSeq(i);
        int startPos = i - (seqInd == 0 ? 0 : this.indexOfFirstSubseq[seqInd - 1]);
        if (this.length == 0) {
            return this.seqs[seqInd].getSubSequence(startPos);
        }
        return this.seqs[seqInd].getSubSequence(startPos, this.length);
    }

    public int getElementLength() {
        return this.length;
    }

    public double getAverageElementLength() {
        if (this.length != 0) {
            return this.length;
        }
        double meanLength = 0.0;
        int i = 0;
        while (i < this.seqs.length) {
            meanLength += (double)this.seqs[i].getLength();
            ++i;
        }
        return meanLength /= (double)this.seqs.length;
    }

    public final DataSet getPartialDataSet(int start, int end) throws EmptyDataSetException {
        return this.getPartialDataSet(new int[][]{{start, end}});
    }

    public final DataSet getPartialDataSet(int[] ... indexes) throws EmptyDataSetException {
        LinkedList<Sequence> list = new LinkedList<Sequence>();
        int i = 0;
        while (i < indexes.length) {
            if (indexes[i].length > 2) {
                throw new IllegalArgumentException("Index array " + i + " longer than 2");
            }
            if (indexes[i][0] > indexes[i][1]) {
                throw new IllegalArgumentException("Start of index pair " + i + " greater than end");
            }
            if (indexes[i][0] < 0) {
                throw new ArrayIndexOutOfBoundsException("Start of index pair " + i + " smaller than 0");
            }
            if (indexes[i][1] > this.getNumberOfElements()) {
                throw new ArrayIndexOutOfBoundsException("End index " + i + " greater than total number of elements");
            }
            int j = indexes[i][0];
            while (j < indexes[i][1]) {
                list.add(this.getElementAt(j));
                ++j;
            }
            ++i;
        }
        DataSet part = null;
        try {
            part = new DataSet("Partial data set of (" + this.getAnnotation() + ")", list);
        }
        catch (WrongAlphabetException doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
        return part;
    }

    public final DataSet getInfixDataSet(int start, int length) throws IllegalArgumentException {
        int i;
        if (length <= 0) {
            throw new IllegalArgumentException("The length has to be positive.");
        }
        int n = i = this.length == 0 ? this.getMinimalElementLength() : this.length;
        if (i >= start + length) {
            if (start == 0 && length == this.length) {
                return this;
            }
            AlphabetContainer abc = this.alphabetContainer.getSubContainer(start, length);
            Sequence[] n2 = new Sequence[this.getNumberOfElements()];
            ElementEnumerator ei = new ElementEnumerator(this);
            i = 0;
            while (i < n2.length) {
                n2[i] = ei.nextElement().getSubSequence(abc, start, length);
                ++i;
            }
            try {
                return new DataSet(abc, n2, length, "infix data set (start=" + start + ", length=" + length + ") of " + this.annotation);
            }
            catch (EmptyDataSetException doesNotHappen) {
                return null;
            }
        }
        throw new IllegalArgumentException("The values for start and length or not suitable.");
    }

    public DataSet getReverseComplementaryDataSet() throws OperationNotSupportedException {
        Sequence[] rc = new Sequence[this.seqs.length];
        int i = 0;
        while (i < this.seqs.length) {
            rc[i] = this.seqs[i].reverseComplement();
            ++i;
        }
        try {
            return new DataSet(this.annotation == null ? null : "reverse complement of " + this.annotation, rc);
        }
        catch (EmptyDataSetException e) {
            return null;
        }
        catch (WrongAlphabetException ex) {
            return null;
        }
    }

    public int getMinimalElementLength() {
        if (this.length != 0) {
            return this.length;
        }
        if (this.indexOfFirstSubseq != null) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        ElementEnumerator ei = new ElementEnumerator(this);
        while (ei.hasMoreElements() && min != 0) {
            int l = ei.nextElement().getLength();
            if (l >= min) continue;
            min = l;
        }
        return min;
    }

    public int getMaximalElementLength() {
        if (this.length != 0) {
            return this.length;
        }
        int max = Integer.MIN_VALUE;
        ElementEnumerator ei = new ElementEnumerator(this);
        while (ei.hasMoreElements()) {
            int l = ei.nextElement().getLength();
            if (l <= max) continue;
            max = l;
        }
        return max;
    }

    public int getNumberOfElements() {
        if (this.indexOfFirstSubseq == null) {
            return this.seqs.length;
        }
        return this.indexOfFirstSubseq[this.seqs.length - 1];
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new ElementEnumerator(this);
    }

    public int getNumberOfElementsWithLength(int len) throws WrongLengthException {
        return (int)this.getNumberOfElementsWithLength(len, null);
    }

    public double getNumberOfElementsWithLength(int len, double[] weights) throws WrongLengthException, IllegalArgumentException {
        double w = 1.0;
        double all = 0.0;
        if (weights != null && weights.length != this.getNumberOfElements()) {
            throw new IllegalArgumentException("The weights array has the wrong dimension");
        }
        if (this.length == 0 || weights != null) {
            int i = 0;
            while (i < this.seqs.length) {
                int l = this.seqs[i].getLength();
                if (weights != null) {
                    w = weights[i];
                }
                if (l < len) {
                    throw new WrongLengthException(len);
                }
                all += w * (double)(l - len + 1);
                ++i;
            }
        } else {
            if (this.length < len) {
                throw new WrongLengthException(len);
            }
            all = (this.length - len + 1) * this.seqs.length;
        }
        return all;
    }

    public final DataSet getSuffixDataSet(int start) throws IllegalArgumentException {
        int l = 0;
        if (this.length != 0) {
            l = this.length - start;
        }
        if (this.alphabetContainer.isSimple()) {
            AlphabetContainer alphabetContainer = this.alphabetContainer;
        }
        AlphabetContainer abc = this.alphabetContainer.getSubContainer(start, l);
        Sequence[] n = new Sequence[this.getNumberOfElements()];
        ElementEnumerator ei = new ElementEnumerator(this);
        int i = 0;
        while (i < n.length) {
            n[i] = ei.nextElement().getSubSequence(abc, start);
            ++i;
        }
        try {
            return new DataSet(abc, n, l, "suffix data set (start=" + start + ") of " + this.annotation);
        }
        catch (EmptyDataSetException doesNotHappen) {
            return null;
        }
    }

    public final boolean isSimpleDataSet() {
        return this.alphabetContainer.isSimple();
    }

    public final boolean isDiscreteDataSet() {
        return this.alphabetContainer.isDiscrete();
    }

    private static double getSumOfWeights(double[] weights) {
        double res = 0.0;
        int i = 0;
        while (i < weights.length) {
            res += weights[i];
            ++i;
        }
        return res;
    }

    public DataSet[] partition(PartitionMethod method, double ... percentage) throws IllegalArgumentException, EmptyDataSetException {
        return this.partition(null, method, percentage).getFirstElement();
    }

    public Pair<DataSet[], double[][]> partition(double[] sequenceWeights, PartitionMethod method, double ... percentage) throws IllegalArgumentException, EmptyDataSetException {
        double l;
        if (percentage == null | percentage.length <= 1) {
            return new Pair<DataSet[], double[][]>(new DataSet[]{this}, new double[][]{sequenceWeights});
        }
        int i = 0;
        double sum = 0.0;
        while (i < percentage.length) {
            if (0.0 > percentage[i] || 1.0 < percentage[i]) {
                throw new IllegalArgumentException("The value of percentage[" + i + "] is not in [0,1].");
            }
            sum += percentage[i];
            ++i;
        }
        if (Math.abs(1.0 - sum) > 1.0E-10) {
            throw new IllegalArgumentException("The sum of the percentages is not 1. (sum = " + sum + ")");
        }
        if (sequenceWeights == null && method == PartitionMethod.PARTITION_BY_WEIGHTS) {
            method = PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS;
        }
        double[] anz = new double[percentage.length];
        switch (method) {
            case PARTITION_BY_NUMBER_OF_ELEMENTS: {
                l = this.getNumberOfElements();
                break;
            }
            case PARTITION_BY_NUMBER_OF_SYMBOLS: {
                l = 0.0;
                ElementEnumerator ei = new ElementEnumerator(this);
                while (ei.hasMoreElements()) {
                    l += (double)ei.nextElement().getLength();
                }
                break;
            }
            case PARTITION_BY_WEIGHTS: {
                l = DataSet.getSumOfWeights(sequenceWeights);
                break;
            }
            default: {
                throw new IllegalArgumentException("The partitioning criterion is unknown.");
            }
        }
        double sumAnz = 0.0;
        i = 0;
        while (i < anz.length) {
            anz[i] = Math.ceil(l * percentage[i]);
            sumAnz += anz[i];
            ++i;
        }
        i = anz.length - 1;
        double d = Math.ceil((l - sumAnz) / (double)percentage.length);
        while (i >= 0 && l - sumAnz > d) {
            int n = i--;
            anz[n] = anz[n] + d;
            sumAnz += d;
        }
        if (i >= 0) {
            int n = i;
            anz[n] = anz[n] + (l - sumAnz);
        }
        return this.partitionDataSetAndWeights(anz, method, sequenceWeights);
    }

    public DataSet[] partition(PartitionMethod method, int k) throws IllegalArgumentException, EmptyDataSetException {
        return this.partition((double[])null, method, k).getFirstElement();
    }

    public Pair<DataSet[], double[][]> partition(double[] sequenceWeights, PartitionMethod method, int k) throws IllegalArgumentException, EmptyDataSetException {
        if (k < 1) {
            throw new IllegalArgumentException("Can't partition in " + k + " parts.");
        }
        if (k == 1) {
            return new Pair<DataSet[], double[][]>(new DataSet[]{this}, new double[][]{sequenceWeights});
        }
        double[] percentage = new double[k];
        Arrays.fill(percentage, 1.0 / (double)k);
        return this.partition(sequenceWeights, method, percentage);
    }

    private Pair<DataSet[], double[][]> partitionDataSetAndWeights(double[] anz, PartitionMethod method, double[] seqWeights) throws EmptyDataSetException {
        int[] pos = new int[this.getNumberOfElements()];
        int[] ends = new int[anz.length];
        int last = pos.length;
        int i = 0;
        i = 0;
        while (i < last) {
            pos[i] = i;
            ++i;
        }
        Random r = new Random();
        if (seqWeights == null && method == PartitionMethod.PARTITION_BY_WEIGHTS) {
            method = PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS;
        }
        i = anz.length - 1;
        while (i > 0) {
            ends[i] = last;
            double current = 0.0;
            while (current < anz[i]) {
                int drawn = r.nextInt(last);
                int help = pos[drawn];
                pos[drawn] = pos[--last];
                pos[last] = help;
                switch (method) {
                    case PARTITION_BY_NUMBER_OF_ELEMENTS: {
                        current += 1.0;
                        break;
                    }
                    case PARTITION_BY_NUMBER_OF_SYMBOLS: {
                        current += (double)this.getElementAt(help).getLength();
                        break;
                    }
                    case PARTITION_BY_WEIGHTS: {
                        current += seqWeights[help];
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("The partitioning criterion is unknown.");
                    }
                }
            }
            --i;
        }
        ends[i] = last;
        return this.getPartitionsOfElements(pos, ends, seqWeights);
    }

    public DataSet subSampling(double number) throws EmptyDataSetException {
        return this.subSampling(number, null).getFirstElement();
    }

    /*
     * Unable to fully structure code
     */
    public Pair<DataSet, double[]> subSampling(double number, double[] weights) throws EmptyDataSetException {
        block5: {
            if (number <= 0.0) {
                throw new EmptyDataSetException();
            }
            r = new Random();
            subsampled_seqs = new LinkedList<Sequence>();
            w = new DoubleList();
            numOfElements = this.getNumberOfElements();
            current = 0.0;
            v0 = sum = weights == null ? (double)numOfElements : ToolBox.sum(0, numOfElements, weights);
            if (weights != null) ** GOTO lbl27
            current = 0.0;
            while (current < sum) {
                subsampled_seqs.add(this.getElementAt(r.nextInt(numOfElements)));
                current += 1.0;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                idx = r.nextDouble() * sum;
                j = 0;
                while (weights[j] < idx) {
                    idx -= weights[j];
                    ++j;
                }
                subsampled_seqs.add(this.getElementAt(j));
                w.add(weights[j]);
                current += weights[j];
lbl27:
                // 2 sources

                ** while (current < sum)
            }
        }
        res = new DataSet(this.alphabetContainer, subsampled_seqs.toArray(new Sequence[0]), this.length, "subsample of " + this.annotation);
        if (w.length() == 0) {
            return new Pair<DataSet, Object>(res, null);
        }
        return new Pair<DataSet, double[]>(res, w.toArray());
    }

    public final Pair<DataSet, double[]> resize(double[] weights, int subsequenceLength) throws WrongLengthException {
        if (subsequenceLength == 0 || this.getElementLength() == subsequenceLength) {
            return new Pair<DataSet, double[]>(this, weights);
        }
        DataSet d = new DataSet(this, subsequenceLength);
        if (weights == null) {
            return new Pair<DataSet, Object>(d, null);
        }
        double[] w = new double[d.getNumberOfElements()];
        int i = 0;
        int j = 0;
        while (i < this.getNumberOfElements()) {
            Sequence seq = this.getElementAt(i);
            int k = seq.getLength() - subsequenceLength + 1;
            Arrays.fill(w, j, j + k, weights[i]);
            j += k;
            ++i;
        }
        return new Pair<DataSet, double[]>(d, w);
    }

    public final void save(File f) throws IOException {
        this.save(new FileOutputStream(f), '>', null);
    }

    public final void save(OutputStream stream, char commentChar, SequenceAnnotationParser p) throws IOException {
        BufferedWriter b = new BufferedWriter(new OutputStreamWriter(stream));
        ElementEnumerator ei = new ElementEnumerator(this);
        if (p == null) {
            p = NullSequenceAnnotationParser.DEFAULT_INSTANCE;
        }
        while (ei.hasMoreElements()) {
            Sequence current = ei.nextElement();
            b.write(p.parseAnnotationToComment(commentChar, current.getAnnotation()));
            b.newLine();
            b.write(current.toString());
            if (!ei.hasMoreElements()) continue;
            b.newLine();
        }
        b.close();
    }

    public String toString() {
        ElementEnumerator ei = new ElementEnumerator(this);
        int l = this.getNumberOfElements();
        StringBuffer erg = new StringBuffer(l * Math.max(this.getElementLength(), 10));
        erg.append("annotation       : " + this.annotation + "\n\n");
        erg.append("AlphabetContainer:\n" + this.alphabetContainer + "\n");
        erg.append("element length   : " + this.getElementLength() + "\n");
        erg.append("# of elements    : " + l + "\n\nsequences:\n");
        Pattern cp = Pattern.compile("\n");
        Matcher m = cp.matcher(erg);
        String temp = m.replaceAll("\n# ");
        erg.delete(0, erg.length());
        erg.append("# ");
        erg.append(temp);
        erg.append("\n");
        while (ei.hasMoreElements()) {
            erg.append(ei.nextElement() + "\n");
        }
        return erg.toString();
    }

    private int getIndexOfSeq(int overAllIndex) throws IndexOutOfBoundsException {
        if (overAllIndex < 0 || overAllIndex > this.indexOfFirstSubseq[this.seqs.length - 1]) {
            throw new IndexOutOfBoundsException();
        }
        int lower = 0;
        int upper = this.seqs.length - 1;
        if (overAllIndex < this.indexOfFirstSubseq[lower]) {
            return 0;
        }
        do {
            int sep;
            if (overAllIndex < this.indexOfFirstSubseq[sep = (upper + lower) / 2]) {
                upper = sep;
                continue;
            }
            lower = sep;
        } while (upper - lower > 1);
        return lower + 1;
    }

    private Pair<DataSet[], double[][]> getPartitionsOfElements(int[] pos, int[] ends, double[] seqWeights) throws EmptyDataSetException {
        int i = 0;
        int last = 0;
        DataSet[] parts = new DataSet[ends.length];
        double[][] partWeights = new double[ends.length][];
        DoubleList w = new DoubleList();
        i = 0;
        while (i < ends.length) {
            w.clear();
            Sequence[] seqs = new Sequence[ends[i] - last];
            int j = 0;
            while (j < seqs.length) {
                seqs[j] = this.getElementAt(pos[last + j]);
                if (seqWeights != null) {
                    w.add(seqWeights[pos[last + j]]);
                }
                ++j;
            }
            last = ends[i];
            partWeights[i] = w.length() == 0 ? null : w.toArray();
            parts[i] = new DataSet(this.alphabetContainer, seqs, this.length, "partition of " + this.annotation);
            ++i;
        }
        return new Pair<DataSet[], double[][]>(parts, partWeights);
    }

    private void setSubsequenceLength(int len) throws WrongLengthException {
        if (len < 0) {
            throw new WrongLengthException(len);
        }
        if (this.length != len) {
            if (len == 0) {
                return;
            }
            if (this.indexOfFirstSubseq != null) {
                throw new UnsupportedOperationException("operation not supported since indexOfFirstSubseq != null");
            }
            if (this.isSimpleDataSet()) {
                this.indexOfFirstSubseq = new int[this.seqs.length];
                if (this.length == 0) {
                    int i = 0;
                    int all = 0;
                    while (i < this.seqs.length) {
                        int l = this.seqs[i].getLength();
                        if (l < len) {
                            throw new WrongLengthException(len);
                        }
                        this.indexOfFirstSubseq[i++] = all += l - len + 1;
                    }
                } else {
                    int offset;
                    if (this.length < len) {
                        throw new WrongLengthException(len);
                    }
                    int i = 0;
                    int all = offset = this.length - len + 1;
                    while (i < this.seqs.length) {
                        this.indexOfFirstSubseq[i] = all;
                        ++i;
                        all += offset;
                    }
                }
                this.length = len;
            } else {
                throw new UnsupportedOperationException("For this data set it is impossible to have a sliding window, since the AlphabetContainer is not simple.");
            }
        }
    }

    public Hashtable<String, HashSet<String>> getAnnotationTypesAndIdentifier() {
        Hashtable<String, HashSet<String>> res = new Hashtable<String, HashSet<String>>();
        for (Sequence s : this) {
            SequenceAnnotation[] seqAn = s.getAnnotation();
            if (seqAn == null) continue;
            SequenceAnnotation[] sequenceAnnotationArray = seqAn;
            int n = seqAn.length;
            int n2 = 0;
            while (n2 < n) {
                SequenceAnnotation current = sequenceAnnotationArray[n2];
                HashSet<String> help = res.get(current.getType());
                boolean add = false;
                if (help == null) {
                    add = true;
                    help = new HashSet();
                }
                help.add(current.getIdentifier());
                if (add) {
                    res.put(current.getType(), help);
                }
                ++n2;
            }
        }
        return res;
    }

    public int[][] getSequenceAnnotationIndexMatrix(String rowType, Hashtable<String, Integer> rowHash, String columnType, Hashtable<String, Integer> columnHash) {
        int[][] result = new int[rowHash.size()][columnHash.size()];
        int r = 0;
        while (r < result.length) {
            Arrays.fill(result[r], -1);
            ++r;
        }
        int idx = 0;
        for (Sequence s : this) {
            SequenceAnnotation[] seqAn = s.getAnnotation();
            int idxColumn = -1;
            int idxRow = -1;
            if (seqAn != null) {
                SequenceAnnotation[] sequenceAnnotationArray = seqAn;
                int n = seqAn.length;
                int n2 = 0;
                while (n2 < n) {
                    SequenceAnnotation current = sequenceAnnotationArray[n2];
                    String help = current.getType();
                    if (help.equals(rowType)) {
                        idxRow = rowHash.get(current.getIdentifier());
                    } else if (help.equals(columnType)) {
                        idxColumn = columnHash.get(current.getIdentifier());
                    }
                    ++n2;
                }
            }
            if (idxRow >= 0 && idxColumn >= 0) {
                result[idxRow][idxColumn] = idx;
            }
            ++idx;
        }
        return result;
    }

    public static class ElementEnumerator
    implements RecyclableSequenceEnumerator,
    Iterator<Sequence> {
        private int seqCounter;
        private int startPosCounter;
        private DataSet s;

        public ElementEnumerator(DataSet data) {
            this.s = data;
            this.reset();
        }

        @Override
        public boolean hasMoreElements() {
            return this.seqCounter < this.s.seqs.length;
        }

        @Override
        public Sequence nextElement() {
            if (this.s.indexOfFirstSubseq == null) {
                return this.s.seqs[this.seqCounter++];
            }
            Sequence current = this.s.length != 0 ? this.s.seqs[this.seqCounter].getSubSequence(this.startPosCounter, this.s.length) : this.s.seqs[this.seqCounter].getSubSequence(this.startPosCounter);
            if (++this.startPosCounter + this.s.length > this.s.seqs[this.seqCounter].getLength()) {
                ++this.seqCounter;
                this.startPosCounter = 0;
            }
            return current;
        }

        @Override
        public void reset() {
            this.startPosCounter = 0;
            this.seqCounter = 0;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public Sequence next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("DataSets are immutable");
        }
    }

    public static enum PartitionMethod {
        PARTITION_BY_NUMBER_OF_ELEMENTS,
        PARTITION_BY_NUMBER_OF_SYMBOLS,
        PARTITION_BY_WEIGHTS;

    }

    public static class WeightedDataSetFactory {
        private DataSet res;
        private double[] weights;

        public WeightedDataSetFactory(SortOperation sort, DataSet ... data) throws WrongAlphabetException, WrongLengthException {
            this(sort, data, null, 0);
        }

        public WeightedDataSetFactory(SortOperation sort, DataSet data, double[] weights) throws WrongAlphabetException, WrongLengthException {
            this(sort, new DataSet[]{data}, new double[][]{weights}, 0);
        }

        public WeightedDataSetFactory(SortOperation sort, DataSet data, double[] weights, int length) throws WrongAlphabetException, WrongLengthException {
            this(sort, new DataSet[]{data}, new double[][]{weights}, length);
        }

        public WeightedDataSetFactory(SortOperation sort, DataSet[] data, double[][] weights, int length) throws WrongAlphabetException, WrongLengthException {
            Hashtable<Sequence, double[]> ht = new Hashtable<Sequence, double[]>(data.length * data[0].getNumberOfElements());
            int i = 0;
            while (i < data.length) {
                if (data[0].alphabetContainer.checkConsistency(data[i].alphabetContainer)) {
                    if (weights != null) {
                        this.add(ht, data[i], weights[i], length);
                    } else {
                        this.add(ht, data[i], null, length);
                    }
                } else {
                    throw new WrongAlphabetException("The AlphabetContainer for all DataSet has to be consistent.");
                }
                ++i;
            }
            this.create("all sequences" + (length > 0 ? " of length " + length : "") + " that occur in " + DataSet.getAnnotation(data), sort, ht);
        }

        private void add(Hashtable<Sequence, double[]> ht, DataSet data, double[] weights, int length) throws WrongLengthException {
            double w = 1.0;
            int i = 0;
            int anz = data.getNumberOfElements();
            while (i < anz) {
                Sequence s = data.getElementAt(i);
                if (weights != null) {
                    w = weights[i];
                }
                if (length == 0) {
                    this.put(ht, s, w);
                } else {
                    int l = s.getLength() - length + 1;
                    if (l > 0) {
                        int j = 0;
                        while (j < l) {
                            this.put(ht, s.getSubSequence(s.getAlphabetContainer(), j, length), w);
                            ++j;
                        }
                    } else {
                        throw new WrongLengthException(length);
                    }
                }
                ++i;
            }
        }

        private void put(Hashtable<Sequence, double[]> ht, Sequence s, double w) {
            double[] value = ht.get(s);
            if (value != null) {
                value[0] = value[0] + w;
            } else {
                ht.put(s, new double[]{w});
            }
        }

        private void create(String annotation, SortOperation sort, Hashtable<Sequence, double[]> ht) {
            Map.Entry[] array = ht.entrySet().toArray(new Map.Entry[0]);
            switch (sort) {
                case NO_SORT: {
                    break;
                }
                case SORT_BY_SEQUENCE: {
                    Arrays.sort(array, SequenceComparator.DEFAULT);
                    break;
                }
                case SORT_BY_WEIGHTS: {
                    Arrays.sort(array, WeightsComparator.DEFAULT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown sort operation");
                }
            }
            Sequence[] seqs = new Sequence[array.length];
            this.weights = new double[array.length];
            int i = 0;
            while (i < this.weights.length) {
                Map.Entry e = array[i];
                seqs[i] = (Sequence)e.getKey();
                this.weights[i] = ((double[])e.getValue())[0];
                ++i;
            }
            try {
                this.res = new DataSet(annotation, seqs);
            }
            catch (Exception doesNotHappen) {
                RuntimeException r = new RuntimeException(doesNotHappen.getMessage());
                r.setStackTrace(doesNotHappen.getStackTrace());
                throw r;
            }
        }

        public Sequence getElementAt(int index) {
            return this.res.getElementAt(index);
        }

        public int getNumberOfElements() {
            return this.res.getNumberOfElements();
        }

        public DataSet getDataSet() {
            return this.res;
        }

        public double getSumOfWeights() {
            return DataSet.getSumOfWeights(this.weights);
        }

        public double getWeight(int index) {
            return this.weights[index];
        }

        public double[] getWeights() {
            return (double[])this.weights.clone();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer((10 + this.res.getElementLength()) * this.weights.length);
            int i = 0;
            while (i < this.weights.length) {
                sb.append(String.valueOf(i) + " " + this.res.getElementAt(i) + "\t" + this.weights[i] + "\n");
                ++i;
            }
            return sb.toString();
        }

        private static final class SequenceComparator
        implements Comparator<Map.Entry<Sequence, double[]>> {
            public static final SequenceComparator DEFAULT = new SequenceComparator();

            private SequenceComparator() {
            }

            @Override
            public int compare(Map.Entry<Sequence, double[]> o1, Map.Entry<Sequence, double[]> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        }

        public static enum SortOperation {
            NO_SORT,
            SORT_BY_SEQUENCE,
            SORT_BY_WEIGHTS;

        }

        private static final class WeightsComparator
        implements Comparator<Map.Entry<Sequence, double[]>> {
            public static final WeightsComparator DEFAULT = new WeightsComparator();

            private WeightsComparator() {
            }

            @Override
            public int compare(Map.Entry<Sequence, double[]> o1, Map.Entry<Sequence, double[]> o2) {
                return (int)Math.signum(o2.getValue()[0] - o1.getValue()[0]);
            }
        }
    }
}

