/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.MRGParams;
import java.util.Arrays;

public class ErlangMRGParams
extends MRGParams {
    private int[] alpha;
    private int sum;

    public ErlangMRGParams(int alpha, int n) throws IllegalArgumentException {
        if (n < 2) {
            throw new IllegalArgumentException("The parameter n has to be at least 2.");
        }
        if ((double)alpha <= 0.0) {
            throw new IllegalArgumentException("The parameter alpha has to be positive.");
        }
        this.alpha = new int[n];
        Arrays.fill(this.alpha, alpha);
        this.sum = n * alpha;
    }

    public ErlangMRGParams(int[] alpha) throws IllegalArgumentException {
        this.alpha = new int[alpha.length];
        this.sum = 0;
        int i = 0;
        while (i < alpha.length) {
            if ((double)alpha[i] <= 0.0) {
                throw new IllegalArgumentException("Each parameter alpha[i] has to be positive.");
            }
            this.alpha[i] = alpha[i];
            this.sum += alpha[i];
            ++i;
        }
    }

    public int getDimension() {
        return this.alpha.length;
    }

    public int getHyperparameter(int i) {
        return this.alpha[i];
    }

    public int getSumOfHyperparameter() {
        return this.sum;
    }
}

